/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.WebSocketFactory;

public abstract class WebSocketServlet
extends HttpServlet
implements WebSocketFactory.Acceptor {
    private final Logger LOG = Log.getLogger(this.getClass());
    private WebSocketFactory _webSocketFactory;

    public void init() throws ServletException {
        try {
            String bs = this.getInitParameter("bufferSize");
            this._webSocketFactory = new WebSocketFactory(this, bs == null ? 8192 : Integer.parseInt(bs));
            this._webSocketFactory.start();
            String max = this.getInitParameter("maxIdleTime");
            if (max != null) {
                this._webSocketFactory.setMaxIdleTime(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("maxTextMessageSize")) != null) {
                this._webSocketFactory.setMaxTextMessageSize(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("maxBinaryMessageSize")) != null) {
                this._webSocketFactory.setMaxBinaryMessageSize(Integer.parseInt(max));
            }
        }
        catch (ServletException x) {
            throw x;
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this._webSocketFactory.acceptWebSocket(request, response) || response.isCommitted()) {
            return;
        }
        super.service(request, response);
    }

    public boolean checkOrigin(HttpServletRequest request, String origin) {
        return true;
    }

    public void destroy() {
        try {
            this._webSocketFactory.stop();
        }
        catch (Exception x) {
            this.LOG.ignore(x);
        }
    }
}

