package org.cdavies.itunes.rendezvous;

import javax.jmdns.*;
import java.io.IOException;

import java.net.*;

import org.cdavies.applerecords.*;
import org.cdavies.itunes.request.*;
import org.cdavies.itunes.*;

public class ItunesListener implements ServiceListener {
	
	public static final String ITUNES_SERVICE_DESC = "_daap._tcp.local.";
	private JmDNS _resolver;
	private ItunesConnectionFactory _producer;
	
	private AppleRecordsServerControl _serverControl;
	private AppleRecordsStatusPanel _status;
	
	public ItunesListener(InetAddress localhost, AppleRecordsServerControl serverControl, AppleRecordsStatusPanel status) throws IOException {
		
		if (localhost != null)
			_resolver = new JmDNS(localhost);
		else
			_resolver = new JmDNS();
		
		_resolver.addServiceListener(ITUNES_SERVICE_DESC, this);
		
		_status = status;
		_serverControl = serverControl;
		
		_producer = new ItunesConnectionFactory();
		
	}
	
	public ItunesListener(AppleRecordsServerControl serverControl, AppleRecordsStatusPanel status) throws IOException {
		
		new ItunesListener(null, serverControl, status);
		
	}
	
	public void close() {
		
		_resolver.close();
		
	}
	
	public void addService(JmDNS resolver, String type, String name) {
		
		if (name.endsWith("." + type)) 
			name = name.substring(0, name.length() - (type.length() + 1));
		
		
		resolver.requestServiceInfo(ITUNES_SERVICE_DESC, name);
		
	}
	
	public void removeService(JmDNS resolver, String type, String name) {
		
		if (name.endsWith("." + type)) 
			name = name.substring(0, name.length() - (type.length() + 1));
		
		/* Hrm, this is dodgy. I'm sure Rendezvous names aren't guaranteed unique */
		
		_serverControl.removeItunesConnection(name);
		_producer.removeCachedItunesConnection(name);
		_status.setTimedText("Service '" + name + "' has gone offline.");
		
	}
	
	public void resolveService(JmDNS jmdns, String type, String name, ServiceInfo info) {
		
		if (name.endsWith("." + type)) 
			name = name.substring(0, name.length() - (type.length() + 1));
		
		ItunesConnection _conn;
		
		try {
			
			_conn = _producer.produceConnectionInstance(info.getAddress(), Request.ITUNES_PORT, name);
			_conn.connect();
			
		}
		catch (NoServerPermissionException _e) {
			
			_status.setTimedText("Could not add service '" + name + "'. Permission Denied");
			return;
			
		}
		
		_serverControl.addItunesConnection(_conn);
		_status.setTimedText("Discovered Service '" + name + "'");
		
		
	}
	
}
