/*
 * Decompiled with CFR 0.152.
 */
package bref;

import bref.AsIsBref3Writer;
import bref.BrefWriter;
import bref.SeqCoder3;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import vcf.RefGTRec;
import vcf.Samples;

public class CompressBref3Writer
implements BrefWriter {
    private final int maxNAlleles;
    private final List<RefGTRec> buffer = new ArrayList<RefGTRec>(500);
    private final SeqCoder3 seqCoder;
    private final AsIsBref3Writer brefWriter;
    private final int nonMajThreshold;

    public CompressBref3Writer(String string, Samples samples, int n, File file) {
        this.maxNAlleles = 255;
        this.seqCoder = new SeqCoder3(samples, n);
        this.brefWriter = new AsIsBref3Writer(string, samples, file);
        this.nonMajThreshold = n / 4 + 1;
    }

    @Override
    public Samples samples() {
        return this.brefWriter.samples();
    }

    @Override
    public void write(RefGTRec refGTRec) {
        if (!refGTRec.isAlleleCoded()) {
            refGTRec = RefGTRec.alleleCodedInstance(refGTRec);
        }
        if (this.buffer.size() == Integer.MAX_VALUE) {
            this.flushBuffer();
        }
        if (this.convertToSeqCoding(refGTRec)) {
            boolean bl = this.seqCoder.add(refGTRec);
            if (!bl) {
                this.flushBuffer();
                bl = this.seqCoder.add(refGTRec);
                assert (bl);
            }
            this.buffer.add(null);
        } else {
            this.buffer.add(refGTRec);
        }
    }

    private boolean convertToSeqCoding(RefGTRec refGTRec) {
        assert (refGTRec.isAlleleCoded());
        if (refGTRec.marker().nAlleles() > this.maxNAlleles) {
            return false;
        }
        int n = refGTRec.majorAllele();
        int n2 = 0;
        int n3 = refGTRec.marker().nAlleles();
        for (int i = 0; i < n3; ++i) {
            if (i == n) continue;
            n2 += refGTRec.alleleCount(i);
        }
        return n2 >= this.nonMajThreshold;
    }

    private void flushBuffer() {
        List<RefGTRec> list = this.seqCoder.getCompressedList();
        int n = 0;
        int n2 = this.buffer.size();
        for (int i = 0; i < n2; ++i) {
            RefGTRec refGTRec = this.buffer.get(i);
            this.brefWriter.write(refGTRec == null ? list.get(n++) : refGTRec);
        }
        assert (n == list.size());
        this.buffer.clear();
    }

    @Override
    public void close() {
        this.flushBuffer();
        this.brefWriter.close();
    }
}

