/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.impl;

import edu.umd.marbl.mhap.impl.MhapRuntimeException;
import edu.umd.marbl.mhap.impl.Sequence;
import edu.umd.marbl.mhap.impl.SequenceId;
import edu.umd.marbl.mhap.sketch.BottomOverlapSketch;
import edu.umd.marbl.mhap.sketch.FrequencyCounts;
import edu.umd.marbl.mhap.sketch.MinHashSketch;
import edu.umd.marbl.mhap.sketch.ZeroNGramsFoundException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;

public final class SequenceSketch
implements Serializable {
    private static final long serialVersionUID = -3155689614837922443L;
    private final SequenceId id;
    private final MinHashSketch mainHashes;
    private final BottomOverlapSketch orderedHashes;
    private final int sequenceLength;
    public static final int BIT_SKETCH_SIZE = 20;
    public static final int SUBSEQUENCE_SIZE = 50;
    public static final int BIT_KMER_SIZE = 7;

    public static SequenceSketch fromByteStream(DataInputStream input, int offset) throws IOException {
        try {
            boolean isFwd = input.readBoolean();
            SequenceId id = new SequenceId(input.readLong() + (long)offset, isFwd, input.readUTF());
            int sequenceLength = input.readInt();
            MinHashSketch mainHashes = MinHashSketch.fromByteStream(input);
            if (mainHashes == null) {
                throw new MhapRuntimeException("Unexpected data read error.");
            }
            BottomOverlapSketch orderedHashes = null;
            orderedHashes = BottomOverlapSketch.fromByteStream(input);
            if (orderedHashes == null) {
                throw new MhapRuntimeException("Unexpected data read error when reading ordered k-mers.");
            }
            return new SequenceSketch(id, sequenceLength, mainHashes, orderedHashes);
        }
        catch (EOFException e) {
            return null;
        }
    }

    public SequenceSketch(SequenceId id, int sequenceLength, MinHashSketch mainHashes, BottomOverlapSketch orderedHashes) {
        this.sequenceLength = sequenceLength;
        this.id = id;
        this.mainHashes = mainHashes;
        this.orderedHashes = orderedHashes;
    }

    public SequenceSketch(Sequence seq, int kmerSize, int numHashes, int orderedKmerSize, int orderedSketchSize, FrequencyCounts kmerFilter, boolean doReverseCompliment, double repeatWeight) throws ZeroNGramsFoundException {
        this.sequenceLength = seq.length();
        this.id = seq.getId();
        this.mainHashes = new MinHashSketch(seq.getSquenceString(), kmerSize, numHashes, kmerFilter, false, repeatWeight);
        this.orderedHashes = new BottomOverlapSketch(seq.getSquenceString(), orderedKmerSize, orderedSketchSize, false);
    }

    public SequenceSketch createOffset(int offset) {
        return new SequenceSketch(this.id.createOffset(offset), this.sequenceLength, this.mainHashes, this.orderedHashes);
    }

    public byte[] getAsByteArray() {
        byte[] mainHashesBytes = this.mainHashes.getAsByteArray();
        byte[] orderedHashesBytes = this.orderedHashes.getAsByteArray();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(mainHashesBytes.length + orderedHashesBytes.length);
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeBoolean(this.id.isForward());
            dos.writeLong(this.id.getHeaderId());
            dos.writeUTF(this.id.getHeader());
            dos.writeInt(this.sequenceLength);
            dos.write(mainHashesBytes);
            dos.write(orderedHashesBytes);
            dos.flush();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new MhapRuntimeException("Unexpected IO error.");
        }
    }

    public MinHashSketch getMinHashes() {
        return this.mainHashes;
    }

    public BottomOverlapSketch getOrderedHashes() {
        return this.orderedHashes;
    }

    public SequenceId getSequenceId() {
        return this.id;
    }

    public int getSequenceLength() {
        return this.sequenceLength;
    }
}

