/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class ReleaseAddress
extends BaseCmd {
    public ReleaseAddress(String[] args) {
        super("ec2reladdr", "ec2-release-address");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    protected String getOptionString() {
        return "IP";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Release an allocated elastic IP address.");
        System.out.println("     The IP parameter specifies the address to release.");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("IP");
        String publicIp = this.getNonOptions()[0];
        this.warnIfTooManyNonOptions();
        RequestResultPair rsp = jec2.releaseAddress(publicIp);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputAddress(System.out, publicIp, null);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    public static void main(String[] args) {
        new ReleaseAddress(args).invoke();
    }
}

