/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Iterator;
import net.sf.saxon.expr.AscendingRangeIterator;
import net.sf.saxon.expr.DescendingRangeIterator;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public class IntegerRange
implements AtomicSequence {
    public long start;
    public long step;
    public long end;

    public IntegerRange(long start, long step, long end) {
        if (step == 0L) {
            throw new IllegalArgumentException("step = 0 in IntegerRange");
        }
        if (end != start && end > start != step > 0L) {
            throw new IllegalArgumentException("end before start in IntegerRange");
        }
        if (Math.abs((end - start) / step) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum length of sequence in Saxon is 2147483647");
        }
        this.start = start;
        this.step = step;
        this.end = start + step * (end - start) / step;
    }

    public long getStart() {
        return this.start;
    }

    public long getStep() {
        return this.step;
    }

    public long getEnd() {
        return this.end;
    }

    @Override
    public AtomicIterator iterate() {
        if (this.step > 0L) {
            return new AscendingRangeIterator(this.start, this.step, this.end);
        }
        return new DescendingRangeIterator(this.start, -this.step, this.end);
    }

    @Override
    public IntegerValue itemAt(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.start + (long)n * this.step);
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        if (length <= 0) {
            return EmptySequence.getInstance();
        }
        long newStart = this.start + (long)Math.max(start, 0);
        long newEnd = newStart + (long)length * this.step - 1L;
        if (newEnd > this.end) {
            newEnd = this.end;
        }
        if (newEnd >= newStart) {
            return new IntegerRange(newStart, this.step, newEnd);
        }
        return EmptySequence.getInstance();
    }

    @Override
    public int getLength() {
        return (int)((this.end - this.start) / this.step) + 1;
    }

    @Override
    public IntegerValue head() {
        return new Int64Value(this.start);
    }

    @Override
    public UnicodeString getCanonicalLexicalRepresentation() {
        return this.getUnicodeStringValue();
    }

    @Override
    public UnicodeString getUnicodeStringValue() {
        try {
            return SequenceTool.getStringValue(this);
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
    }

    @Override
    public String getStringValue() {
        try {
            return SequenceTool.stringify(this);
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public GroundedValue reduce() {
        if (this.start == this.end) {
            return this.itemAt(0);
        }
        return this;
    }

    public String toString() {
        return "(" + this.start + (this.step == 1L ? "" : " by " + this.step) + " to " + this.end + ")";
    }

    @Override
    public Iterator<AtomicValue> iterator() {
        return new IntegerRangeIterator(this);
    }

    private static class IntegerRangeIterator
    implements Iterator<AtomicValue> {
        private IntegerRange range;
        private long current;

        public IntegerRangeIterator(IntegerRange range) {
            this.range = range;
            this.current = range.start;
        }

        @Override
        public boolean hasNext() {
            return this.current <= this.range.end;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AtomicValue next() {
            return new Int64Value(this.current++);
        }
    }
}

