/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import net.sf.gogui.game.Node;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.Move;
import net.sf.gogui.gui.GameTreePanel;

class GameTreeNode
extends JComponent {
    private final int m_moveNumber;
    private static final long serialVersionUID = 0L;
    private static final Color COLOR_LIGHT_BLUE = new Color(103, 122, 164);
    private final GameTreePanel m_gameTreePanel;
    private final Node m_node;

    public GameTreeNode(Node node, int n, GameTreePanel gameTreePanel, MouseListener mouseListener, Font font, Dimension dimension) {
        this.m_gameTreePanel = gameTreePanel;
        this.m_node = node;
        this.m_moveNumber = n;
        this.addMouseListener(mouseListener);
        this.setOpaque(false);
        this.setFocusable(false);
        this.setFocusTraversalKeysEnabled(false);
        if (font != null) {
            this.setFont(font);
        }
        this.setPreferredSize(dimension);
    }

    public Node getNode() {
        return this.m_node;
    }

    public void paintComponent(Graphics graphics) {
        int n = this.m_gameTreePanel.getNodeSize();
        int n2 = this.m_gameTreePanel.getNodeFullSize();
        int n3 = n / 2;
        int n4 = this.m_node.getNumberChildren();
        boolean bl = this.m_gameTreePanel.isExpanded(this.m_node);
        graphics.setColor(Color.DARK_GRAY);
        if (n4 > 1 && (bl || !this.m_gameTreePanel.getShowSubtreeSizes()) || n4 == 1) {
            graphics.drawLine(n, n3, n2, n3);
        }
        if (n4 > 1) {
            if (bl) {
                graphics.drawLine(n3, n, n3, n2);
            } else {
                int n5 = n * 7 / 10;
                graphics.drawLine(n5, n5, n, n);
                graphics.drawLine(n, n, n2 - n / 5, n);
            }
        }
        Move move = this.m_node.getMove();
        if (this.m_node.getNumberAddBlack() + this.m_node.getNumberAddWhite() > 0) {
            graphics.setColor(Color.black);
            graphics.fillOval(0, 0, n3, n3);
            graphics.fillOval(n3, n3, n3, n3);
            graphics.setColor(Color.white);
            graphics.fillOval(n3, 0, n3, n3);
            graphics.fillOval(0, n3, n3, n3);
        } else if (move == null) {
            graphics.setColor(COLOR_LIGHT_BLUE);
            int[] nArray = new int[]{n3, n, n3, 0};
            int[] nArray2 = new int[]{0, n3, n, n3};
            graphics.fillPolygon(nArray, nArray2, 4);
        } else {
            if (move.getColor() == GoColor.BLACK) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.white);
            }
            graphics.fillOval(0, 0, n, n);
            this.drawText(graphics);
        }
        if (this.m_node.hasComment()) {
            graphics.setColor(COLOR_LIGHT_BLUE);
            int n6 = n + (n2 - n) / 4;
            int n7 = n / 5;
            graphics.drawLine(n7, n6, n - n7, n6);
        }
        if (this.m_gameTreePanel.isCurrent(this.m_node)) {
            graphics.setColor(Color.red);
            int n8 = n / 6;
            int n9 = n;
            graphics.drawLine(n8, n8, 2 * n8, n8);
            graphics.drawLine(n8, n8, n8, 2 * n8);
            graphics.drawLine(n8, n9 - 2 * n8 - 1, n8, n9 - n8 - 1);
            graphics.drawLine(n8, n9 - n8 - 1, 2 * n8, n9 - n8 - 1);
            graphics.drawLine(n9 - 2 * n8 - 1, n8, n9 - n8 - 1, n8);
            graphics.drawLine(n9 - n8 - 1, n8, n9 - n8 - 1, 2 * n8);
            graphics.drawLine(n9 - n8 - 1, n9 - n8 - 1, n9 - n8 - 1, n9 - 2 * n8 - 1);
            graphics.drawLine(n9 - n8 - 1, n9 - n8 - 1, n9 - 2 * n8 - 1, n9 - n8 - 1);
        }
    }

    private void drawText(Graphics graphics) {
        String string;
        int n = this.m_gameTreePanel.getLabelMode();
        if (n == 2) {
            return;
        }
        Move move = this.m_node.getMove();
        int n2 = this.m_gameTreePanel.getNodeSize();
        if (n == 1) {
            if (move.getPoint() == null) {
                return;
            }
            string = move.getPoint().toString();
        } else {
            string = Integer.toString(this.m_moveNumber);
        }
        int n3 = graphics.getFontMetrics().stringWidth(string);
        int n4 = graphics.getFont().getSize();
        int n5 = (n2 - n3) / 2;
        int n6 = n4 + (n2 - n4) / 2;
        if (move.getColor() == GoColor.BLACK) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        graphics.drawString(string, n5, n6);
    }
}

