/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.game;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.game.Node;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.utils.StringUtils;

public final class NodeUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Node findByMoveNumber(Node node, int n) {
        int n2 = NodeUtils.getMoveNumber(node) + NodeUtils.getMovesLeft(node);
        if (n < 0 || n > n2) {
            return null;
        }
        if (n <= NodeUtils.getMoveNumber(node)) {
            while (node.getFather() != null && (NodeUtils.getMoveNumber(node) > n || node.getMove() == null)) {
                node = node.getFather();
            }
        } else {
            while (node.getChild() != null && NodeUtils.getMoveNumber(node) < n) {
                node = node.getChild();
            }
        }
        return node;
    }

    public static Node findByVariation(Node node, String string) {
        if (string.trim().equals("")) {
            return node;
        }
        String[] stringArray = StringUtils.split(string, '.');
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]) - 1;
                if (nArray[i] >= 0) continue;
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        Node node2 = node;
        for (int i = 0; i < nArray.length; ++i) {
            while (node2.getNumberChildren() <= 1) {
                if ((node2 = node2.getChild()) != null) continue;
                return null;
            }
            if (nArray[i] >= node2.getNumberChildren()) {
                return null;
            }
            node2 = node2.getChild(nArray[i]);
        }
        return node2;
    }

    public static boolean commentContains(Node node, Pattern pattern) {
        String string = node.getComment();
        return string != null && pattern.matcher(string).find();
    }

    public static Node findInComments(Node node, Pattern pattern) {
        node = NodeUtils.nextNode(node);
        while (node != null) {
            if (NodeUtils.commentContains(node, pattern)) {
                return node;
            }
            node = NodeUtils.nextNode(node);
        }
        return null;
    }

    public static ArrayList getAllAsMoves(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            Node node = (Node)arrayList.get(i);
            arrayList2.addAll(NodeUtils.getAllAsMoves(node));
            if (!$assertionsDisabled && i != 0 && !node.isChildOf((Node)arrayList.get(i - 1))) {
                throw new AssertionError();
            }
        }
        return arrayList2;
    }

    public static ArrayList getAllAsMoves(Node node) {
        Move move;
        ArrayList<Move> arrayList;
        block10: {
            int n;
            boolean bl;
            arrayList = new ArrayList<Move>();
            move = node.getMove();
            if (!node.hasSetup()) break block10;
            int n2 = node.getNumberAddBlack();
            int n3 = node.getNumberAddWhite();
            boolean bl2 = bl = move == null && node.getPlayer() == GoColor.WHITE && n2 > 0 && n3 > 0;
            if (bl) {
                for (n = 0; n < n3; ++n) {
                    arrayList.add(Move.get(node.getAddWhite(n), GoColor.WHITE));
                }
                for (n = 0; n < n2; ++n) {
                    arrayList.add(Move.get(node.getAddBlack(n), GoColor.BLACK));
                }
            } else {
                for (n = 0; n < n2; ++n) {
                    arrayList.add(Move.get(node.getAddBlack(n), GoColor.BLACK));
                }
                for (n = 0; n < n3; ++n) {
                    arrayList.add(Move.get(node.getAddWhite(n), GoColor.WHITE));
                }
            }
            for (n = 0; n < node.getNumberAddEmpty(); ++n) {
                arrayList.add(Move.get(node.getAddEmpty(n), GoColor.EMPTY));
            }
        }
        if (move != null) {
            arrayList.add(move);
        }
        if (arrayList.size() > 0) {
            GoColor goColor = node.getToMove();
            Move move2 = (Move)arrayList.get(arrayList.size() - 1);
            GoColor goColor2 = move2.getColor().otherColor();
            if (goColor != GoColor.EMPTY && goColor != goColor2 && goColor2 != GoColor.EMPTY) {
                arrayList.add(Move.getPass(goColor2));
            }
        }
        return arrayList;
    }

    public static Node getBackToMainVariation(Node node) {
        while (!NodeUtils.isInMainVariation(node)) {
            node = node.getFather();
        }
        return node;
    }

    public static ArrayList getChildrenMoves(Node node) {
        ArrayList<GoPoint> arrayList = new ArrayList<GoPoint>();
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            Move move = node.getChild(i).getMove();
            if (move == null || move.getPoint() == null) continue;
            arrayList.add(move.getPoint());
        }
        return arrayList;
    }

    public static Node getChildWithMove(Node node, Move move) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            Node node2 = node.getChild(i);
            Move move2 = node.getChild(i).getMove();
            if (move2 == null || !move2.equals(move)) continue;
            return node2;
        }
        return null;
    }

    public static int getDepth(Node node) {
        int n = 0;
        while (node.getFather() != null) {
            node = node.getFather();
            ++n;
        }
        return n;
    }

    public static Node getLast(Node node) {
        while (node.getNumberChildren() > 0) {
            node = node.getChild();
        }
        return node;
    }

    public static int getMoveNumber(Node node) {
        int n = 0;
        while (node != null) {
            if (node.getMove() != null) {
                ++n;
            }
            node = node.getFather();
        }
        return n;
    }

    public static int getMovesLeft(Node node) {
        int n = 0;
        for (node = node.getChild(); node != null; node = node.getChild()) {
            if (node.getMove() == null) continue;
            ++n;
        }
        return n;
    }

    public static Node getNextVariation(Node node) {
        Node node2 = node.getFather();
        if (node2 == null) {
            return null;
        }
        return node2.variationAfter(node);
    }

    public static Node getNextEarlierVariation(Node node) {
        Node node2 = node;
        for (node = node.getFather(); node != null && node.variationAfter(node2) == null; node = node.getFather()) {
            node2 = node;
        }
        if (node == null) {
            return null;
        }
        return node.variationAfter(node2);
    }

    public static int getNodesLeft(Node node) {
        int n = 0;
        while (node != null) {
            ++n;
            node = node.getChild();
        }
        return n;
    }

    public static ArrayList getPathFromRoot(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        while (node != null) {
            arrayList.add(0, node);
            node = node.getFather();
        }
        return arrayList;
    }

    public static Node getPreviousVariation(Node node) {
        Node node2 = node.getFather();
        if (node2 == null) {
            return null;
        }
        return node2.variationBefore(node);
    }

    public static Node getPreviousEarlierVariation(Node node) {
        Node node2 = node;
        for (node = node.getFather(); node != null && node.variationBefore(node2) == null; node = node.getFather()) {
            node2 = node;
        }
        if (node == null) {
            return null;
        }
        if ((node = node.variationBefore(node2)) == null) {
            return null;
        }
        while (NodeUtils.hasSubtree(node)) {
            node = node.getChild(node.getNumberChildren() - 1);
        }
        return node;
    }

    public static int getShortestPath(Node node, Node node2, ArrayList arrayList) {
        ArrayList arrayList2 = NodeUtils.getPathFromRoot(node);
        ArrayList arrayList3 = NodeUtils.getPathFromRoot(node2);
        while (arrayList2.size() > 0 && arrayList3.size() > 0 && arrayList2.get(0) == arrayList3.get(0)) {
            arrayList2.remove(0);
            arrayList3.remove(0);
        }
        arrayList.clear();
        for (int i = 0; i < arrayList3.size(); ++i) {
            arrayList.add(arrayList3.get(i));
        }
        return arrayList2.size();
    }

    public static String getVariationString(Node node) {
        int n;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (node != null) {
            object = node.getFather();
            if (object != null && ((Node)object).getNumberChildren() > 1) {
                n = ((Node)object).getChildIndex(node) + 1;
                arrayList.add(0, Integer.toString(n));
            }
            node = object;
        }
        object = new StringBuffer(arrayList.size() * 3);
        for (n = 0; n < arrayList.size(); ++n) {
            ((StringBuffer)object).append((String)arrayList.get(n));
            if (n >= arrayList.size() - 1) continue;
            ((StringBuffer)object).append('.');
        }
        return ((StringBuffer)object).toString();
    }

    public static boolean hasSubtree(Node node) {
        while (node != null && node.getNumberChildren() < 2) {
            node = node.getChild();
        }
        return node != null;
    }

    public static boolean isInCleanup(Node node) {
        boolean bl = false;
        while (node != null) {
            Move move = node.getMove();
            if (move != null) {
                if (move.getPoint() == null) {
                    if (bl) {
                        return true;
                    }
                    bl = true;
                } else {
                    bl = false;
                }
            }
            node = node.getFather();
        }
        return false;
    }

    public static boolean isInMainVariation(Node node) {
        while (node.getFather() != null) {
            if (node.getFather().getChild(0) != node) {
                return false;
            }
            node = node.getFather();
        }
        return true;
    }

    public static boolean isRootWithoutChildren(Node node) {
        return node.getFather() == null && node.getChild() == null;
    }

    public static void makeMainVariation(Node node) {
        while (node.getFather() != null) {
            node.getFather().makeMainVariation(node);
            node = node.getFather();
        }
    }

    public static GameTree makeTreeFromPosition(GameInformation gameInformation, Board board) {
        GameTree gameTree = new GameTree(board.getSize(), gameInformation.m_komi, null, gameInformation.m_rules, gameInformation.m_timeSettings);
        Node node = gameTree.getRoot();
        for (int i = 0; i < board.getNumberPoints(); ++i) {
            GoPoint goPoint = board.getPoint(i);
            GoColor goColor = board.getColor(goPoint);
            if (goColor == GoColor.BLACK) {
                node.addBlack(goPoint);
                continue;
            }
            if (goColor != GoColor.WHITE) continue;
            node.addWhite(goPoint);
        }
        node.setPlayer(board.getToMove());
        return gameTree;
    }

    public static Node nextNode(Node node) {
        Node node2 = node.getChild();
        if (node2 != null) {
            return node2;
        }
        return NodeUtils.getNextEarlierVariation(node);
    }

    public static Node nextNode(Node node, int n) {
        if ((node = NodeUtils.nextNode(node)) == null || NodeUtils.getDepth(node) <= n) {
            return null;
        }
        return node;
    }

    public static String nodeInfo(Node node) {
        String string;
        Object object;
        Map.Entry entry;
        Object object2;
        Object object3;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NodeProperties:\n");
        NodeUtils.appendInfo(stringBuffer, "Depth", NodeUtils.getDepth(node));
        NodeUtils.appendInfo(stringBuffer, "Children", node.getNumberChildren());
        if (node.getMove() != null) {
            NodeUtils.appendInfo(stringBuffer, "Move", node.getMove().toString());
            NodeUtils.appendInfo(stringBuffer, "MoveNumber", NodeUtils.getMoveNumber(node));
        }
        NodeUtils.appendInfo(stringBuffer, "Variation", NodeUtils.getVariationString(node));
        ArrayList<GoPoint> arrayList = new ArrayList<GoPoint>();
        for (int i = 0; i < node.getNumberAddBlack(); ++i) {
            arrayList.add(node.getAddBlack(i));
        }
        if (node.getNumberAddBlack() > 0) {
            NodeUtils.appendInfo(stringBuffer, "AddBlack", arrayList);
        }
        ArrayList<GoPoint> arrayList2 = new ArrayList<GoPoint>();
        for (int i = 0; i < node.getNumberAddWhite(); ++i) {
            arrayList2.add(node.getAddWhite(i));
        }
        if (node.getNumberAddWhite() > 0) {
            NodeUtils.appendInfo(stringBuffer, "AddWhite", arrayList2);
        }
        ArrayList<GoPoint> arrayList3 = new ArrayList<GoPoint>();
        for (n = 0; n < node.getNumberAddEmpty(); ++n) {
            arrayList3.add(node.getAddEmpty(n));
        }
        if (node.getNumberAddEmpty() > 0) {
            NodeUtils.appendInfo(stringBuffer, "AddEmpty", arrayList3);
        }
        if (node.getPlayer() != GoColor.EMPTY) {
            NodeUtils.appendInfo(stringBuffer, "Player", node.getPlayer().toString());
        }
        if (!Double.isNaN(node.getTimeLeft(GoColor.BLACK))) {
            NodeUtils.appendInfo(stringBuffer, "TimeLeftBlack", node.getTimeLeft(GoColor.BLACK));
        }
        if (node.getMovesLeft(GoColor.BLACK) >= 0) {
            NodeUtils.appendInfo(stringBuffer, "MovesLeftBlack", node.getMovesLeft(GoColor.BLACK));
        }
        if (!Double.isNaN(node.getTimeLeft(GoColor.WHITE))) {
            NodeUtils.appendInfo(stringBuffer, "TimeLeftWhite", node.getTimeLeft(GoColor.WHITE));
        }
        if (node.getMovesLeft(GoColor.WHITE) >= 0) {
            NodeUtils.appendInfo(stringBuffer, "MovesLeftWhite", node.getMovesLeft(GoColor.WHITE));
        }
        NodeUtils.appendInfoComment(stringBuffer, node);
        for (n = 0; n < MarkType.ALL.length; ++n) {
            object3 = MarkType.ALL[n];
            object2 = node.getMarked((MarkType)object3);
            if (object2 == null || ((ArrayList)object2).size() <= 0) continue;
            NodeUtils.appendInfo(stringBuffer, "Marked " + StringUtils.capitalize(((MarkType)object3).toString()), object2);
        }
        Map map = node.getLabels();
        if (map != null && map.size() > 0) {
            object3 = new StringBuffer();
            object2 = map.entrySet().iterator();
            while (object2.hasNext()) {
                entry = (Map.Entry)object2.next();
                object = (GoPoint)entry.getKey();
                string = (String)entry.getValue();
                ((StringBuffer)object3).append(object);
                ((StringBuffer)object3).append(':');
                ((StringBuffer)object3).append(string);
                if (!object2.hasNext()) continue;
                ((StringBuffer)object3).append(' ');
            }
            NodeUtils.appendInfo(stringBuffer, "Labels", ((StringBuffer)object3).toString());
        }
        if (!Float.isNaN(node.getValue())) {
            NodeUtils.appendInfo(stringBuffer, "Value", Float.toString(node.getValue()));
        }
        if ((object3 = node.getSgfProperties()) != null) {
            stringBuffer.append("SgfProperties:\n");
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                entry = object2.next();
                object = (String)entry.getKey();
                string = (String)entry.getValue();
                NodeUtils.appendInfo(stringBuffer, (String)object, string);
            }
        }
        return stringBuffer.toString();
    }

    public static boolean subtreeGreaterThan(Node node, int n) {
        int n2 = 0;
        int n3 = NodeUtils.getDepth(node);
        while (node != null) {
            if (++n2 > n) {
                return true;
            }
            node = NodeUtils.nextNode(node, n3);
        }
        return false;
    }

    public static int subtreeSize(Node node) {
        int n = 0;
        int n2 = NodeUtils.getDepth(node);
        while (node != null) {
            ++n;
            node = NodeUtils.nextNode(node, n2);
        }
        return n;
    }

    public static String treeInfo(Node node) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n7 = NodeUtils.getDepth(node);
        while (node != null) {
            ++n2;
            n = node.getNumberChildren();
            int n8 = NodeUtils.getDepth(node) - n7;
            if (!$assertionsDisabled && n8 < 0) {
                throw new AssertionError();
            }
            if (n8 > n5) {
                n5 = n8;
            }
            if (n > n6) {
                n6 = n;
            }
            if (n == 0) {
                ++n3;
            } else {
                d3 += (double)n;
            }
            if (n > 1) {
                ++n4;
            }
            d += (double)n8;
            d2 += (double)n;
            node = NodeUtils.nextNode(node, n7);
        }
        n = n2 - n3;
        d /= (double)n2;
        d2 /= (double)n2;
        d3 /= (double)Math.max(n, 1);
        NumberFormat numberFormat = StringUtils.getNumberFormat(3);
        numberFormat.setMinimumFractionDigits(3);
        StringBuffer stringBuffer = new StringBuffer();
        NodeUtils.appendInfo(stringBuffer, "Nodes", n2);
        NodeUtils.appendInfo(stringBuffer, "Terminal", n3);
        NodeUtils.appendInfo(stringBuffer, "Inner", n);
        NodeUtils.appendInfo(stringBuffer, "AvgDepth", numberFormat.format(d));
        NodeUtils.appendInfo(stringBuffer, "MaxDepth", n5);
        NodeUtils.appendInfo(stringBuffer, "AvgChildren", numberFormat.format(d2));
        NodeUtils.appendInfo(stringBuffer, "AvgChildrenInner", numberFormat.format(d3));
        NodeUtils.appendInfo(stringBuffer, "MaxChildren", n6);
        NodeUtils.appendInfo(stringBuffer, "MoreThanOneChild", n4);
        return stringBuffer.toString();
    }

    public static void truncateChildren(Node node) {
        Node node2;
        while ((node2 = node.getChild()) != null) {
            node.removeChild(node2);
        }
    }

    private static void appendInfo(StringBuffer stringBuffer, String string, int n) {
        NodeUtils.appendInfo(stringBuffer, string, Integer.toString(n));
    }

    private static void appendInfo(StringBuffer stringBuffer, String string, double d) {
        NodeUtils.appendInfo(stringBuffer, string, Double.toString(d));
    }

    private static void appendInfo(StringBuffer stringBuffer, String string, ArrayList arrayList) {
        NodeUtils.appendInfoLabel(stringBuffer, string);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i % 10 == 9 && i < arrayList.size() - 1) {
                stringBuffer.append('\n');
                NodeUtils.appendInfoLabel(stringBuffer, "");
            }
            stringBuffer.append((GoPoint)arrayList.get(i));
            stringBuffer.append(' ');
        }
        stringBuffer.append('\n');
    }

    private static void appendInfo(StringBuffer stringBuffer, String string, String string2) {
        NodeUtils.appendInfoLabel(stringBuffer, string);
        stringBuffer.append(string2);
        stringBuffer.append('\n');
    }

    private static void appendInfoComment(StringBuffer stringBuffer, Node node) {
        String string = node.getComment();
        if (string == null) {
            return;
        }
        boolean bl = false;
        int n = string.indexOf("\n");
        if (n >= 0) {
            string = string.substring(0, n);
            bl = true;
        }
        if (string.length() > 30) {
            string = string.substring(0, 30);
            bl = true;
        }
        if (bl) {
            string = string + "...";
        }
        NodeUtils.appendInfo(stringBuffer, "Comment", string);
    }

    private static void appendInfoLabel(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string);
        int n = Math.max(0, 20 - string.length());
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(' ');
    }

    private NodeUtils() {
    }

    static {
        $assertionsDisabled = !NodeUtils.class.desiredAssertionStatus();
    }
}

