/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.sf.gogui.gui.SgfPreview;
import net.sf.gogui.sgf.SgfFilter;
import net.sf.gogui.thumbnail.Thumbnail;
import net.sf.gogui.utils.Platform;
import net.sf.gogui.utils.StringUtils;

public final class SimpleDialogs {
    public static final int FILE_OPEN = 0;
    public static final int FILE_SAVE = 1;
    public static final int FILE_SELECT = 2;
    private static final String APP_NAME = "GoGui";
    private static File s_lastFile;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void showError(Component component, String string) {
        String string2 = "Error";
        if (component == null) {
            string2 = string2 + " - " + APP_NAME;
        }
        JOptionPane.showMessageDialog(component, string, string2, 0);
    }

    public static void showError(Component component, String string, Exception exception) {
        SimpleDialogs.showError(component, string + "\n" + StringUtils.printException(exception));
    }

    public static void showInfo(Component component, String string) {
        String string2 = "Info";
        if (component == null) {
            string2 = string2 + " - " + APP_NAME;
        }
        JOptionPane.showMessageDialog(component, string, string2, 1);
    }

    public static File showOpen(Component component, String string) {
        return SimpleDialogs.showFileChooser(component, 0, null, false, string);
    }

    public static File showOpenSgf(Component component) {
        return SimpleDialogs.showFileChooser(component, 0, null, true, null);
    }

    public static boolean showQuestion(Component component, String string) {
        int n;
        String string2 = "Question";
        if (component == null) {
            string2 = string2 + " - " + APP_NAME;
        }
        return (n = JOptionPane.showConfirmDialog(component, string, string2, 0)) == 0;
    }

    public static File showSave(Component component, String string) {
        return SimpleDialogs.showFileChooserSave(component, null, false, string);
    }

    public static File showSaveSgf(Frame frame) {
        return SimpleDialogs.showFileChooserSave(frame, s_lastFile, true, null);
    }

    public static File showSelectFile(Component component, String string) {
        return SimpleDialogs.showFileChooser(component, 2, s_lastFile, false, string);
    }

    public static void showWarning(Component component, String string) {
        String string2 = "Warning";
        if (component == null) {
            string2 = string2 + " - " + APP_NAME;
        }
        JOptionPane.showMessageDialog(component, string, string2, 2);
    }

    public static void setLastFile(File file) {
        s_lastFile = file;
    }

    private SimpleDialogs() {
    }

    private static Frame findParentFrame(Component component) {
        while (component != null) {
            if (component instanceof Frame) {
                return (Frame)component;
            }
            component = component.getParent();
        }
        return null;
    }

    private static File showFileChooser(Component component, int n, File file, boolean bl, String string) {
        if (Platform.isMac() && n != 2) {
            Frame frame = SimpleDialogs.findParentFrame(component);
            return SimpleDialogs.showFileChooserAWT(frame, n, string);
        }
        return SimpleDialogs.showFileChooserSwing(component, n, file, bl, string);
    }

    private static File showFileChooserSave(Component component, File file, boolean bl, String string) {
        File file2 = SimpleDialogs.showFileChooser(component, 1, file, bl, string);
        if (Platform.isMac()) {
            return file2;
        }
        while (file2 != null && file2.exists() && !SimpleDialogs.showQuestion(component, "Overwrite " + file2 + "?")) {
            file2 = SimpleDialogs.showFileChooser(component, 1, file, bl, string);
        }
        return file2;
    }

    private static File showFileChooserAWT(Frame frame, int n, String string) {
        FileDialog fileDialog = new FileDialog(frame);
        if (string == null) {
            switch (n) {
                case 0: {
                    string = "Open";
                    break;
                }
                case 1: {
                    string = "Save";
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
        fileDialog.setTitle(string);
        int n2 = 0;
        if (n == 1) {
            n2 = 1;
        }
        fileDialog.setMode(n2);
        fileDialog.setLocationRelativeTo(frame);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return null;
        }
        return new File(fileDialog.getDirectory(), fileDialog.getFile());
    }

    private static File showFileChooserSwing(Component component, int n, File file, boolean bl, String string) {
        File file2;
        int n2;
        JFileChooser jFileChooser = s_lastFile == null ? (Platform.isMac() ? new JFileChooser((String)null) : new JFileChooser(System.getProperty("user.dir"))) : new JFileChooser(s_lastFile);
        jFileChooser.setMultiSelectionEnabled(false);
        SgfFilter sgfFilter = new SgfFilter();
        jFileChooser.addChoosableFileFilter(sgfFilter);
        if (n == 1 && file != null && file.isFile() && file.exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (bl) {
            jFileChooser.setFileFilter(sgfFilter);
            if (Thumbnail.checkThumbnailSupport() && !Platform.isGnuClasspath()) {
                SgfPreview sgfPreview = new SgfPreview();
                jFileChooser.setAccessory(sgfPreview);
                jFileChooser.addPropertyChangeListener(sgfPreview);
            }
        } else {
            jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
        }
        switch (n) {
            case 1: {
                n2 = jFileChooser.showSaveDialog(component);
                break;
            }
            case 0: {
                n2 = jFileChooser.showOpenDialog(component);
                break;
            }
            default: {
                if (string != null) {
                    jFileChooser.setDialogTitle(string);
                }
                n2 = jFileChooser.showDialog(component, "Select");
            }
        }
        if (n2 != 0) {
            return null;
        }
        s_lastFile = file2 = jFileChooser.getSelectedFile();
        return file2;
    }

    static {
        $assertionsDisabled = !SimpleDialogs.class.desiredAssertionStatus();
    }
}

