/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc;

import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.impl.StandardSerializationPolicy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public final class SerializationPolicyLoader {
    public static final String CLIENT_FIELDS_KEYWORD = "@ClientFields";
    public static final String FINAL_FIELDS_KEYWORD = "@FinalFields";
    public static final String SERIALIZATION_POLICY_FILE_ENCODING = "UTF-8";
    private static final String FORMAT_ERROR_MESSAGE = "Expected: className, [true | false], [true | false], [true | false], [true | false], typeId, signature";

    public static String getSerializationPolicyFileName(String serializationPolicyStrongName) {
        return serializationPolicyStrongName + ".gwt.rpc";
    }

    @Deprecated
    public static SerializationPolicy loadFromStream(InputStream inputStream) throws IOException, ParseException, ClassNotFoundException {
        ArrayList<ClassNotFoundException> classNotFoundExceptions = new ArrayList<ClassNotFoundException>();
        SerializationPolicy serializationPolicy = SerializationPolicyLoader.loadFromStream(inputStream, classNotFoundExceptions);
        if (!classNotFoundExceptions.isEmpty()) {
            throw (ClassNotFoundException)classNotFoundExceptions.get(0);
        }
        return serializationPolicy;
    }

    public static SerializationPolicy loadFromStream(InputStream inputStream, List<ClassNotFoundException> classNotFoundExceptions) throws IOException, ParseException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        HashMap whitelistSer = new HashMap();
        HashMap whitelistDeser = new HashMap();
        HashMap typeIds = new HashMap();
        HashMap clientFields = new HashMap();
        boolean shouldSerializeFinalFields = false;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        InputStreamReader isr = new InputStreamReader(inputStream, SERIALIZATION_POLICY_FILE_ENCODING);
        BufferedReader br = new BufferedReader(isr);
        String line = br.readLine();
        int lineNum = 1;
        while (line != null) {
            block19: {
                if ((line = line.trim()).length() > 0) {
                    String binaryTypeName;
                    String[] components = line.split(",");
                    if (components[0].equals(CLIENT_FIELDS_KEYWORD)) {
                        binaryTypeName = components[1].trim();
                        try {
                            Class<?> clazz = Class.forName(binaryTypeName, false, contextClassLoader);
                            HashSet<String> fieldNames = new HashSet<String>();
                            for (int i = 2; i < components.length; ++i) {
                                fieldNames.add(components[i]);
                            }
                            clientFields.put(clazz, fieldNames);
                        }
                        catch (ClassNotFoundException ex) {
                            if (classNotFoundExceptions != null) {
                                classNotFoundExceptions.add(ex);
                            }
                            break block19;
                        }
                    }
                    if (components[0].equals(FINAL_FIELDS_KEYWORD)) {
                        shouldSerializeFinalFields = Boolean.valueOf(components[1].trim());
                    } else {
                        String typeId;
                        boolean instantSer;
                        boolean instantDeser;
                        boolean fieldSer;
                        boolean fieldDeser;
                        if (components.length != 2 && components.length != 7) {
                            throw new ParseException(FORMAT_ERROR_MESSAGE, lineNum);
                        }
                        for (int i = 0; i < components.length; ++i) {
                            components[i] = components[i].trim();
                            if (components[i].length() != 0) continue;
                            throw new ParseException(FORMAT_ERROR_MESSAGE, lineNum);
                        }
                        binaryTypeName = components[0].trim();
                        if (components.length == 2) {
                            fieldDeser = true;
                            fieldSer = true;
                            instantSer = instantDeser = Boolean.valueOf(components[1]).booleanValue();
                            typeId = binaryTypeName;
                        } else {
                            int idx = 1;
                            fieldSer = Boolean.valueOf(components[idx++]);
                            instantSer = Boolean.valueOf(components[idx++]);
                            fieldDeser = Boolean.valueOf(components[idx++]);
                            instantDeser = Boolean.valueOf(components[idx++]);
                            typeId = components[idx++];
                            if (!(fieldSer || fieldDeser || "_".equals(typeId))) {
                                throw new ParseException("Type " + binaryTypeName + " is neither field serializable, field deserializable " + "nor the service interface", lineNum);
                            }
                        }
                        try {
                            Class<?> clazz = Class.forName(binaryTypeName, false, contextClassLoader);
                            if (fieldSer) {
                                whitelistSer.put(clazz, instantSer);
                            }
                            if (fieldDeser) {
                                whitelistDeser.put(clazz, instantDeser);
                            }
                            typeIds.put(clazz, typeId);
                        }
                        catch (ClassNotFoundException ex) {
                            if (classNotFoundExceptions == null) break block19;
                            classNotFoundExceptions.add(ex);
                        }
                    }
                }
            }
            line = br.readLine();
            ++lineNum;
        }
        return new StandardSerializationPolicy(whitelistSer, whitelistDeser, typeIds, clientFields, shouldSerializeFinalFields);
    }

    private SerializationPolicyLoader() {
    }
}

