#!/usr/pkg/bin/ruby32
# $Id: scrape-MDAPI-3-currefs.rb 7388 2020-12-24 15:28:00Z flaterco $
# 2020-12-23 14:43
# Given currents.json from scrape-MDAPI-0-stationlists.sh, get the harmonic
# constants and datums for all current reference stations.
# API documented at: https://api.tidesandcurrents.noaa.gov/mdapi/prod/
# If it should go away, there is another one at https://opendap.co-ops.nos.noaa.gov/ioos-dif-sos/

# The harcon query doesn't work for currents, so we try every station ID from
# currents.json that looks viable.  Code is semiduplicated from
# importNOS_CurSubs.rb.

require 'json'

subdir = "currefs"
Dir.mkdir(subdir) unless File.exist?(subdir)

Dir.chdir(subdir) do
  unless File.exist?("urls.txt")
    # Ignore that line saying "units": "feet"
    currents = JSON.parse(File.read("../currents.json"))["stations"]

    # Fetch on shortsid gets all bins.  Each bin shows up with a separate
    # record in this JSON, but we only need to fetch once.
    urls = Hash.new
    currents.each {|csta|
      # type is H, S, W, or Y.
      #   H = harmonic
      #   S = subordinate
      #   W = weak and variable with null offsets
      #   Y = undocumented ?  Is that like X only 1 more?
      type = csta["type"]
      case type
      when "H"
        # Throw out non-US stations here.  Previous were all PCT* (old IDs)
        # for B.C. subordinate current stations on Wrangell.
        urls[csta["id"]] = csta["harmonicConstituents"]["self"]
      when "S", "W"
	next
      else
	print cname, " is type ", type, "; not handled\n"
	raise "Unknown type not handled"
      end
    }

    # Dump the URLs.
    # FIXME:  Remove units spec when XTide handles SI velocity unit.
    File.open("urls.txt", "w") do |outf|
      urls.each_value {|v| outf.puts v+"?units=english"}
    end
  end

  system "wget --force-directories --no-host-directories --cut-dirs=4 --wait=10 --random-wait --no-clobber --input-file=urls.txt --append-output=scrape_log.txt"
end
