/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.generator;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Locale;
import org.eclipse.jetty.spdy.CompressionDictionary;
import org.eclipse.jetty.spdy.CompressionFactory;
import org.eclipse.jetty.spdy.api.Headers;

public class HeadersBlockGenerator {
    private final CompressionFactory.Compressor compressor;
    private boolean needsDictionary = true;

    public HeadersBlockGenerator(CompressionFactory.Compressor compressor) {
        this.compressor = compressor;
    }

    public ByteBuffer generate(short version, Headers headers) {
        Charset iso1 = Charset.forName("ISO-8859-1");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(headers.size() * 64);
        this.writeCount(version, buffer, headers.size());
        for (Headers.Header header : headers) {
            String name = header.name().toLowerCase(Locale.ENGLISH);
            byte[] nameBytes = name.getBytes(iso1);
            this.writeNameLength(version, buffer, nameBytes.length);
            buffer.write(nameBytes, 0, nameBytes.length);
            String value = header.value();
            byte[] valueBytes = value.getBytes(iso1);
            if (header.hasMultipleValues()) {
                String[] values = header.values();
                for (int i = 1; i < values.length; ++i) {
                    byte[] moreValueBytes = values[i].getBytes(iso1);
                    byte[] newValueBytes = new byte[valueBytes.length + 1 + moreValueBytes.length];
                    System.arraycopy(valueBytes, 0, newValueBytes, 0, valueBytes.length);
                    newValueBytes[valueBytes.length] = 0;
                    System.arraycopy(moreValueBytes, 0, newValueBytes, valueBytes.length + 1, moreValueBytes.length);
                    valueBytes = newValueBytes;
                }
            }
            this.writeValueLength(version, buffer, valueBytes.length);
            buffer.write(valueBytes, 0, valueBytes.length);
        }
        return this.compress(version, buffer.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer compress(short version, byte[] bytes) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(bytes.length);
        CompressionFactory.Compressor compressor = this.compressor;
        synchronized (compressor) {
            int compressed;
            if (this.needsDictionary) {
                this.compressor.setDictionary(CompressionDictionary.get(version));
                this.needsDictionary = false;
            }
            this.compressor.setInput(bytes);
            buffer.reset();
            byte[] output = new byte[Math.max(256, bytes.length)];
            do {
                compressed = this.compressor.compress(output);
                buffer.write(output, 0, compressed);
            } while (compressed >= output.length);
        }
        return ByteBuffer.wrap(buffer.toByteArray());
    }

    private void writeCount(short version, ByteArrayOutputStream buffer, int value) {
        switch (version) {
            case 2: {
                buffer.write((value & 0xFF00) >>> 8);
                buffer.write(value & 0xFF);
                break;
            }
            case 3: {
                buffer.write((value & 0xFF000000) >>> 24);
                buffer.write((value & 0xFF0000) >>> 16);
                buffer.write((value & 0xFF00) >>> 8);
                buffer.write(value & 0xFF);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void writeNameLength(short version, ByteArrayOutputStream buffer, int length) {
        this.writeCount(version, buffer, length);
    }

    private void writeValueLength(short version, ByteArrayOutputStream buffer, int length) {
        this.writeCount(version, buffer, length);
    }
}

