/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.utils.PasswordUtil;

public class ConfigUtils {
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "MS_SHOULD_BE_FINAL"})
    public static String PASSWORD_CMD_LINE_ARGS;
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "MS_SHOULD_BE_FINAL"})
    public static String PASSWORD_SYS_PROPS;

    public static File getAbsoluteFile(String path, ConfigurationService cfg) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            String scHomeDirName;
            String scHomeDirLocation;
            if (cfg == null) {
                scHomeDirLocation = System.getProperty("net.java.sip.communicator.SC_HOME_DIR_LOCATION");
                scHomeDirName = System.getProperty("net.java.sip.communicator.SC_HOME_DIR_NAME");
            } else {
                scHomeDirLocation = cfg.getScHomeDirLocation();
                scHomeDirName = cfg.getScHomeDirName();
            }
            if (scHomeDirLocation == null && (scHomeDirLocation = System.getProperty("user.home")) == null) {
                scHomeDirLocation = ".";
            }
            if (scHomeDirName == null) {
                scHomeDirName = ".";
            }
            file = new File(new File(scHomeDirLocation, scHomeDirName), path).getAbsoluteFile();
        }
        return file;
    }

    public static boolean getBoolean(ConfigurationService cfg, String property, boolean defaultValue) {
        String s2;
        boolean b = cfg == null ? ((s2 = System.getProperty(property)) == null || s2.length() == 0 ? defaultValue : Boolean.parseBoolean(s2)) : cfg.getBoolean(property, defaultValue);
        return b;
    }

    public static int getInt(ConfigurationService cfg, String property, int defaultValue) {
        int i;
        if (cfg == null) {
            String s2 = System.getProperty(property);
            if (s2 == null || s2.length() == 0) {
                i = defaultValue;
            } else {
                try {
                    i = Integer.parseInt(s2);
                }
                catch (NumberFormatException nfe) {
                    i = defaultValue;
                }
            }
        } else {
            i = cfg.getInt(property, defaultValue);
        }
        return i;
    }

    public static long getLong(ConfigurationService cfg, String property, long defaultValue) {
        long i;
        if (cfg == null) {
            String s2 = System.getProperty(property);
            if (s2 == null || s2.length() == 0) {
                i = defaultValue;
            } else {
                try {
                    i = Long.parseLong(s2);
                }
                catch (NumberFormatException nfe) {
                    i = defaultValue;
                }
            }
        } else {
            i = cfg.getLong(property, defaultValue);
        }
        return i;
    }

    public static String getString(ConfigurationService cfg, String property, String defaultValue) {
        String s2 = cfg == null ? System.getProperty(property, defaultValue) : cfg.getString(property, defaultValue);
        return s2;
    }

    public static String getString(ConfigurationService cfg, String property, String propertyAlternative, String defaultValue) {
        String ret = ConfigUtils.getString(cfg, property, null);
        if (ret == null) {
            ret = ConfigUtils.getString(cfg, propertyAlternative, defaultValue);
        }
        return ret;
    }

    public static String getSystemPropertiesDebugString() {
        StringBuilder str = new StringBuilder();
        try {
            Pattern exclusion = null;
            if (PASSWORD_SYS_PROPS != null) {
                exclusion = Pattern.compile(PASSWORD_SYS_PROPS, 2);
            }
            String[] passwordArgs = null;
            if (PASSWORD_CMD_LINE_ARGS != null) {
                passwordArgs = PASSWORD_CMD_LINE_ARGS.split(",");
            }
            for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                String key = String.valueOf(e.getKey());
                String value = String.valueOf(e.getValue());
                if (exclusion != null && exclusion.matcher(key).find()) {
                    value = "**********";
                }
                if (passwordArgs != null && "sun.java.command".equals(key)) {
                    value = PasswordUtil.replacePasswords(value, passwordArgs);
                }
                str.append(key).append("=").append(value).append("\n");
            }
        }
        catch (RuntimeException e) {
            str.append("An exception occurred while writing debug info").append(e.toString());
        }
        return str.toString();
    }
}

