/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/jicofo/xmpp/ConfigurationChangeHandler;", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Listener;", "Lorg/jivesoftware/smack/StanzaListener;", "xmppProvider", "Lorg/jitsi/jicofo/xmpp/XmppProvider;", "conferenceStore", "Lorg/jitsi/jicofo/ConferenceStore;", "(Lorg/jitsi/jicofo/xmpp/XmppProvider;Lorg/jitsi/jicofo/ConferenceStore;)V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "processStanza", "", "stanza", "Lorg/jivesoftware/smack/packet/Stanza;", "jicofo"})
@SourceDebugExtension(value={"SMAP\nConfigurationChangeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationChangeHandler.kt\norg/jitsi/jicofo/xmpp/ConfigurationChangeHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1755#2,3:69\n*S KotlinDebug\n*F\n+ 1 ConfigurationChangeHandler.kt\norg/jitsi/jicofo/xmpp/ConfigurationChangeHandler\n*L\n52#1:69,3\n*E\n"})
public final class ConfigurationChangeHandler
implements XmppProvider.Listener,
StanzaListener {
    @NotNull
    private final XmppProvider xmppProvider;
    @NotNull
    private final ConferenceStore conferenceStore;
    @NotNull
    private final Logger logger;

    public ConfigurationChangeHandler(@NotNull XmppProvider xmppProvider, @NotNull ConferenceStore conferenceStore) {
        Intrinsics.checkNotNullParameter((Object)xmppProvider, (String)"xmppProvider");
        Intrinsics.checkNotNullParameter((Object)conferenceStore, (String)"conferenceStore");
        this.xmppProvider = xmppProvider;
        this.conferenceStore = conferenceStore;
        this.logger = LoggerExtensionsKt.createLogger$default((Object)this, null, null, (int)3, null);
        this.xmppProvider.getXmppConnection().addSyncStanzaListener((StanzaListener)this, MessageTypeFilter.GROUPCHAT);
    }

    public void processStanza(@NotNull Stanza stanza) {
        block12: {
            boolean bl;
            Set set;
            Intrinsics.checkNotNullParameter((Object)stanza, (String)"stanza");
            if (!(stanza instanceof Message)) {
                this.logger.error((Object)"Not a message");
                return;
            }
            MUCUser mUCUser = MUCUser.from((Stanza)stanza);
            if (mUCUser == null) break block12;
            MUCUser mucUser = mUCUser;
            boolean bl2 = false;
            Set set2 = set = mucUser.getStatus();
            if (set2 != null) {
                boolean bl3;
                block11: {
                    Intrinsics.checkNotNull((Object)set2);
                    Iterable $this$any$iv = set;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            MUCUser.Status it = (MUCUser.Status)element$iv;
                            boolean bl4 = false;
                            if (!(it.getCode() == 104)) continue;
                            bl3 = true;
                            break block11;
                        }
                        bl3 = false;
                    }
                }
                bl = bl3;
            } else {
                bl = false;
            }
            if (bl) {
                Future<?> future;
                Future<?> future2;
                Jid roomJid = ((Message)stanza).getFrom();
                if (!(roomJid instanceof EntityBareJid)) {
                    this.logger.info((Object)"An occupant sending status 104?");
                    return;
                }
                this.logger.info((Object)("Configuration changed for " + roomJid));
                JitsiMeetConference jitsiMeetConference = this.conferenceStore.getConference((EntityBareJid)roomJid);
                if (jitsiMeetConference != null) {
                    JitsiMeetConference conference = jitsiMeetConference;
                    boolean bl5 = false;
                    future2 = TaskPools.Companion.getIoPool().submit(() -> ConfigurationChangeHandler.processStanza$lambda$4$lambda$2$lambda$1(conference));
                } else {
                    future2 = future = null;
                }
                if (future == null) {
                    ConfigurationChangeHandler $this$processStanza_u24lambda_u244_u24lambda_u243 = this;
                    boolean bl6 = false;
                    $this$processStanza_u24lambda_u244_u24lambda_u243.logger.info((Object)"Configuration changed for unknown conference.");
                }
            }
        }
    }

    public void componentsChanged(@NotNull Set<XmppProvider.Component> components) {
        XmppProvider.Listener.DefaultImpls.componentsChanged((XmppProvider.Listener)this, components);
    }

    public void registrationChanged(boolean registered) {
        XmppProvider.Listener.DefaultImpls.registrationChanged((XmppProvider.Listener)this, (boolean)registered);
    }

    private static final void processStanza$lambda$4$lambda$2$lambda$1(JitsiMeetConference $conference) {
        Intrinsics.checkNotNullParameter((Object)$conference, (String)"$conference");
        $conference.mucConfigurationChanged();
    }
}

