/*
 * Decompiled with CFR 0.152.
 */
package free.jin.console.prefs;

import free.jin.I18n;
import free.util.swing.ColorChooser;
import free.util.swing.FontSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TextStyleChooserPanel
extends JPanel {
    private static final String ANTIALIAS_OPTION_ID = "antialias";
    private final FontSelectorPanel fontSelector;
    private final ColorChooser foregroundChooser;
    private final ColorChooser backgroundChooser;
    private final ChangeEvent changeEvent = new ChangeEvent(this);
    static /* synthetic */ Class class$java$lang$Object;

    public TextStyleChooserPanel(Font font, Color color, Color color2, boolean bl, boolean bl2, boolean bl3) {
        I18n i18n = I18n.get(this.getClass(), (Class)TextStyleChooserPanel.class);
        String string = i18n.getString("antialiasOptionName");
        int n = i18n.getInt("antialiasOptionDisplayedMnemonicIndex");
        FontSelectorPanel.BooleanFontOption[] booleanFontOptionArray = new FontSelectorPanel.BooleanFontOption[]{FontSelectorPanel.createBoldFontOption(), FontSelectorPanel.createItalicFontOption(), new FontSelectorPanel.BooleanFontOption(ANTIALIAS_OPTION_ID, string, n, bl)};
        int[] nArray = new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
        this.fontSelector = bl3 ? new FontSelectorPanel(nArray, booleanFontOptionArray) : new FontSelectorPanel(nArray);
        this.foregroundChooser = i18n.createColorChooser("foregroundColorChooser");
        this.foregroundChooser.setColor(color);
        if (bl2) {
            this.backgroundChooser = i18n.createColorChooser("backgroundColorChooser");
            this.backgroundChooser.setColor(color2);
        } else {
            this.backgroundChooser = null;
        }
        this.fontSelector.setPreviewPanel((JComponent)((Object)new TextStylePreviewPanel(this.fontSelector, bl)));
        this.fontSelector.setSelectedFont(font);
        this.fontSelector.getPreviewPanel().setOpaque(true);
        this.fontSelector.getPreviewPanel().setBackground(color2);
        this.fontSelector.getPreviewPanel().setForeground(color);
        this.createUI();
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TextStyleChooserPanel.this.fontSelector.getPreviewPanel().setForeground(TextStyleChooserPanel.this.foregroundChooser.getColor());
                if (TextStyleChooserPanel.this.backgroundChooser != null) {
                    TextStyleChooserPanel.this.fontSelector.getPreviewPanel().setBackground(TextStyleChooserPanel.this.backgroundChooser.getColor());
                }
                TextStyleChooserPanel.this.fireStateChanged();
            }
        };
        this.foregroundChooser.addChangeListener(changeListener);
        if (this.backgroundChooser != null) {
            this.backgroundChooser.addChangeListener(changeListener);
        }
        this.fontSelector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TextStyleChooserPanel.this.fireStateChanged();
            }
        });
    }

    private void createUI() {
        LayoutManager layoutManager;
        LayoutManager layoutManager2;
        this.setLayout(new BorderLayout(5, 5));
        if (this.backgroundChooser == null) {
            layoutManager2 = new FlowLayout();
            layoutManager = layoutManager2;
        } else {
            layoutManager = new GridLayout(1, 2, 15, 5);
        }
        layoutManager2 = layoutManager;
        JPanel jPanel = new JPanel(layoutManager2);
        jPanel.add((Component)this.foregroundChooser);
        if (this.backgroundChooser != null) {
            jPanel.add((Component)this.backgroundChooser);
        }
        this.add((Component)this.fontSelector, "Center");
        this.add((Component)jPanel, "South");
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? TextStyleChooserPanel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(this.changeEvent);
        }
    }

    public void setSelectedForeground(Color color) {
        this.foregroundChooser.setColor(color);
    }

    public Color getSelectedForeground() {
        return this.foregroundChooser.getColor();
    }

    public void setSelectedFont(Font font) {
        this.fontSelector.setSelectedFont(font);
    }

    public Font getSelectedFont() {
        return this.fontSelector.getSelectedFont();
    }

    public void setSelectedBackground(Color color) {
        this.fontSelector.getPreviewPanel().setBackground(color);
        if (this.backgroundChooser != null) {
            this.backgroundChooser.setColor(color);
        } else {
            this.fireStateChanged();
        }
    }

    public Color getSelectedBackground() {
        if (this.backgroundChooser == null) {
            return this.fontSelector.getPreviewPanel().getBackground();
        }
        return this.backgroundChooser.getColor();
    }

    public boolean isAntialiasingSelectionEnabled() {
        return this.fontSelector.getFontOption(ANTIALIAS_OPTION_ID) != null;
    }

    public boolean isAntialias() {
        return this.fontSelector.getFontOptionValue(ANTIALIAS_OPTION_ID);
    }

    public void setAntialias(boolean bl) {
        FontSelectorPanel.BooleanFontOption booleanFontOption = this.fontSelector.getFontOption(ANTIALIAS_OPTION_ID);
        if (booleanFontOption != null) {
            booleanFontOption.setValue(bl);
        }
        ((TextStylePreviewPanel)((Object)this.fontSelector.getPreviewPanel())).setAntialias(bl);
    }

    private class TextStylePreviewPanel
    extends FontSelectorPanel.DefaultPreviewPanel {
        private boolean antialias;
        private boolean antialiasingSupported;

        public TextStylePreviewPanel(FontSelectorPanel fontSelectorPanel, boolean bl) {
            super(fontSelectorPanel);
            this.antialiasingSupported = true;
            this.antialias = bl;
        }

        public void paintComponent(Graphics graphics) {
            if (this.antialiasingSupported) {
                try {
                    Class<?> clazz = Class.forName("java.awt.Graphics2D");
                    Class<?> clazz2 = Class.forName("java.awt.RenderingHints$Key");
                    Method method = clazz.getMethod("setRenderingHint", clazz2, class$java$lang$Object == null ? (class$java$lang$Object = TextStyleChooserPanel.class$("java.lang.Object")) : class$java$lang$Object);
                    RenderingHints.Key key = RenderingHints.KEY_TEXT_ANTIALIASING;
                    Object object = this.antialias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
                    method.invoke((Object)graphics, key, object);
                }
                catch (Exception exception) {
                    this.antialiasingSupported = false;
                }
            }
            super.paintComponent(graphics);
        }

        public void setAntialias(boolean bl) {
            this.antialias = bl;
        }
    }
}

