/*
 * Decompiled with CFR 0.152.
 */
package free.jin.sound;

import free.jin.Connection;
import free.jin.Game;
import free.jin.Preferences;
import free.jin.event.BoardFlipEvent;
import free.jin.event.ChatEvent;
import free.jin.event.ChatListener;
import free.jin.event.ClockAdjustmentEvent;
import free.jin.event.ConnectionListener;
import free.jin.event.GameEndEvent;
import free.jin.event.GameListener;
import free.jin.event.GameStartEvent;
import free.jin.event.IllegalMoveEvent;
import free.jin.event.ListenerManager;
import free.jin.event.MoveMadeEvent;
import free.jin.event.OfferEvent;
import free.jin.event.PlainTextEvent;
import free.jin.event.PlainTextListener;
import free.jin.event.PositionChangedEvent;
import free.jin.event.TakebackEvent;
import free.jin.plugin.Plugin;
import free.util.audio.AudioClip;
import free.util.models.BooleanModel;
import free.util.models.Model;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SoundManager
extends Plugin
implements PlainTextListener,
ChatListener,
ConnectionListener,
GameListener,
PropertyChangeListener {
    protected static final Hashtable FILENAMES_TO_AUDIO_CLIPS = new Hashtable();
    protected final Hashtable chatPatternsToFilenames = new Hashtable();
    protected final Hashtable textPatternsToFilenames = new Hashtable();
    protected final Hashtable eventsToAudioClips = new Hashtable();
    protected BooleanModel soundState;

    public void start() {
        this.init();
        this.loadSounds();
        this.registerListeners();
    }

    public void stop() {
        this.unregisterListeners();
        this.unloadSounds();
    }

    public Model[] getHotPrefs() {
        return new Model[]{this.soundState};
    }

    protected void init() {
        this.soundState = new BooleanModel(this.getI18n().getString("enableSound"), this.getPrefs().getBool("on", true));
    }

    public void saveState() {
        this.getPrefs().setBool("on", this.soundState.isOn());
    }

    protected void loadSounds() {
        this.loadPatternSounds("chat", this.chatPatternsToFilenames);
        this.loadPatternSounds("text", this.textPatternsToFilenames);
        this.loadEventAudioClip("OnConnect");
        this.loadEventAudioClip("OnLogin");
        this.loadEventAudioClip("OnDisconnect");
        this.loadEventAudioClip("Move");
        this.loadEventAudioClip("Capture");
        this.loadEventAudioClip("Castling");
        this.loadEventAudioClip("IllegalMove");
        this.loadEventAudioClip("GameEnd");
        this.loadEventAudioClip("GameStart");
        this.loadEventAudioClip("DrawOffer");
        this.loadEventAudioClip("AbortOffer");
        this.loadEventAudioClip("AdjournOffer");
        this.loadEventAudioClip("TakebackOffer");
    }

    private void loadPatternSounds(String string, Hashtable hashtable) {
        Preferences preferences = this.getPrefs();
        int n = preferences.getInt("num-" + string + "-patterns", 0);
        for (int i = 0; i < n; ++i) {
            try {
                String string2 = preferences.getString(string + "-sound-" + i);
                String string3 = preferences.getString(string + "-pattern-" + i);
                Pattern pattern = Pattern.compile(string3);
                if (!FILENAMES_TO_AUDIO_CLIPS.containsKey(string2)) {
                    URL uRL = (class$free$jin$sound$SoundManager == null ? SoundManager.class$("free.jin.sound.SoundManager") : class$free$jin$sound$SoundManager).getResource(string2);
                    if (uRL == null) continue;
                    FILENAMES_TO_AUDIO_CLIPS.put(string2, new AudioClip(uRL));
                }
                hashtable.put(pattern, string2);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                patternSyntaxException.printStackTrace();
            }
        }
    }

    protected final void loadEventAudioClip(String string) {
        try {
            String string2 = this.getPrefs().getString(string, null);
            if (string2 == null) {
                return;
            }
            URL uRL = SoundManager.class.getResource(string2);
            if (uRL == null) {
                return;
            }
            this.eventsToAudioClips.put(string, new AudioClip(uRL));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void registerListeners() {
        Connection connection = this.getConn();
        ListenerManager listenerManager = connection.getListenerManager();
        listenerManager.addPlainTextListener((PlainTextListener)this);
        listenerManager.addChatListener((ChatListener)this);
        listenerManager.addConnectionListener((ConnectionListener)this);
        listenerManager.addGameListener((GameListener)this);
    }

    protected void unregisterListeners() {
        Connection connection = this.getConn();
        ListenerManager listenerManager = connection.getListenerManager();
        listenerManager.removePlainTextListener((PlainTextListener)this);
        listenerManager.removeChatListener((ChatListener)this);
        listenerManager.removeConnectionListener((ConnectionListener)this);
        listenerManager.removeGameListener((GameListener)this);
    }

    protected void unloadSounds() {
        this.chatPatternsToFilenames.clear();
        FILENAMES_TO_AUDIO_CLIPS.clear();
    }

    public void chatMessageReceived(ChatEvent chatEvent) {
        if (!this.isOn()) {
            return;
        }
        String string = chatEvent.getType();
        Object object = chatEvent.getForum();
        String string2 = chatEvent.getSender();
        String string3 = string + "." + (object == null ? "" : object.toString()) + "." + string2;
        Enumeration enumeration = this.chatPatternsToFilenames.keys();
        while (enumeration.hasMoreElements()) {
            Pattern pattern = (Pattern)enumeration.nextElement();
            Matcher matcher = pattern.matcher(string3);
            if (!matcher.find()) continue;
            String string4 = (String)this.chatPatternsToFilenames.get(pattern);
            AudioClip audioClip = (AudioClip)FILENAMES_TO_AUDIO_CLIPS.get(string4);
            audioClip.play();
        }
    }

    public void plainTextReceived(PlainTextEvent plainTextEvent) {
        if (!this.isOn()) {
            return;
        }
        String string = plainTextEvent.getText();
        Enumeration enumeration = this.textPatternsToFilenames.keys();
        while (enumeration.hasMoreElements()) {
            Pattern pattern = (Pattern)enumeration.nextElement();
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            String string2 = (String)this.textPatternsToFilenames.get(pattern);
            AudioClip audioClip = (AudioClip)FILENAMES_TO_AUDIO_CLIPS.get(string2);
            audioClip.play();
        }
    }

    public boolean playEventSound(String string) {
        AudioClip audioClip = (AudioClip)this.eventsToAudioClips.get(string);
        if (audioClip != null) {
            if (this.isOn()) {
                audioClip.play();
            }
            return true;
        }
        return false;
    }

    public void connectionEstablished(Connection connection) {
        this.playEventSound("OnConnect");
    }

    public void loginSucceeded(Connection connection) {
        this.playEventSound("OnLogin");
    }

    public void connectionLost(Connection connection) {
        this.playEventSound("OnDisconnect");
    }

    public void connectingFailed(Connection connection, String string) {
    }

    public void connectionAttempted(Connection connection, String string, int n) {
    }

    public void loginFailed(Connection connection, String string) {
    }

    public void gameStarted(GameStartEvent gameStartEvent) {
        Game game = gameStartEvent.getGame();
        if (game.getGameType() == 1 && game.isPlayed()) {
            this.playEventSound("GameStart");
            game.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Game game;
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (object instanceof Game && (game = (Game)object).getGameType() == 1 && "played".equals(string) && propertyChangeEvent.getOldValue().equals(Boolean.TRUE) && propertyChangeEvent.getNewValue().equals(Boolean.FALSE)) {
            this.playEventSound("GameEnd");
        }
    }

    public void illegalMoveAttempted(IllegalMoveEvent illegalMoveEvent) {
        this.playEventSound("IllegalMove");
    }

    public void gameEnded(GameEndEvent gameEndEvent) {
        Game game = gameEndEvent.getGame();
        if (game.getGameType() == 1 && game.isPlayed()) {
            this.playEventSound("GameEnd");
        }
        game.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void offerUpdated(OfferEvent offerEvent) {
        if (offerEvent.isOffered()) {
            switch (offerEvent.getOfferId()) {
                case 1: {
                    this.playEventSound("DrawOffer");
                    break;
                }
                case 3: {
                    this.playEventSound("AbortOffer");
                    break;
                }
                case 2: {
                    this.playEventSound("AdjournOffer");
                    break;
                }
                case 4: {
                    this.playEventSound("TakebackOffer");
                }
            }
        }
    }

    public void moveMade(MoveMadeEvent moveMadeEvent) {
    }

    public void positionChanged(PositionChangedEvent positionChangedEvent) {
    }

    public void takebackOccurred(TakebackEvent takebackEvent) {
    }

    public void clockAdjusted(ClockAdjustmentEvent clockAdjustmentEvent) {
    }

    public void boardFlipped(BoardFlipEvent boardFlipEvent) {
    }

    public boolean isOn() {
        return this.soundState.isOn();
    }

    public String getName() {
        return this.getI18n().getString("pluginName");
    }

    public String getId() {
        return "sound";
    }
}

