/*
 * Decompiled with CFR 0.152.
 */
package free.jin.scripter;

import bsh.EvalError;
import free.chess.Chess;
import free.chess.ChessMove;
import free.chess.Player;
import free.chess.Position;
import free.chess.Square;
import free.chess.WildVariant;
import free.jin.Connection;
import free.jin.FriendsConnection;
import free.jin.Game;
import free.jin.Preferences;
import free.jin.Seek;
import free.jin.SeekConnection;
import free.jin.event.BoardFlipEvent;
import free.jin.event.ClockAdjustmentEvent;
import free.jin.event.ConnectionListener;
import free.jin.event.FriendsEvent;
import free.jin.event.FriendsListener;
import free.jin.event.FriendsListenerManager;
import free.jin.event.GameEndEvent;
import free.jin.event.GameEvent;
import free.jin.event.GameListener;
import free.jin.event.GameStartEvent;
import free.jin.event.IllegalMoveEvent;
import free.jin.event.JinEvent;
import free.jin.event.ListenerManager;
import free.jin.event.MoveMadeEvent;
import free.jin.event.OfferEvent;
import free.jin.event.PlainTextEvent;
import free.jin.event.PlainTextListener;
import free.jin.event.PositionChangedEvent;
import free.jin.event.SeekEvent;
import free.jin.event.SeekListener;
import free.jin.event.SeekListenerManager;
import free.jin.event.TakebackEvent;
import free.jin.plugin.Plugin;
import free.jin.scripter.BeanShellScript;
import free.jin.scripter.CommandScript;
import free.jin.scripter.Script;
import free.jin.scripter.ScripterPreferencesPanel;
import free.jin.ui.PreferencesPanel;
import free.util.MemoryFile;
import free.util.Utilities;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Scripter
extends Plugin {
    private final Hashtable dispatchers = new Hashtable();
    private Hashtable oldToNewEventTypes = null;
    private Hashtable eventTypesToOldToNewEventSubtypes;

    public Scripter() {
        this.registerScriptDispatcher("connection", new ConnectionScriptDispatcher());
        this.registerScriptDispatcher("plainText", new PlainTextScriptDispatcher());
        this.registerScriptDispatcher("game", new GameScriptDispatcher());
        this.registerScriptDispatcher("seek", new SeekScriptDispatcher());
        this.registerScriptDispatcher("friends", new FriendsScriptDispatcher());
    }

    protected void registerScriptDispatcher(String string, ScriptDispatcher scriptDispatcher) {
        this.dispatchers.put(string, scriptDispatcher);
    }

    private ScriptDispatcher getScriptDispatcher(String string) {
        ScriptDispatcher scriptDispatcher = (ScriptDispatcher)this.dispatchers.get(string);
        if (scriptDispatcher == null || !scriptDispatcher.isSupportedBy(this.getConn())) {
            return null;
        }
        return scriptDispatcher;
    }

    public String[] getSupportedEventTypes() {
        Object[] objectArray;
        Connection connection = this.getConn();
        Enumeration enumeration = this.dispatchers.keys();
        Vector<Object[]> vector = new Vector<Object[]>(this.dispatchers.size());
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            ScriptDispatcher scriptDispatcher = (ScriptDispatcher)this.dispatchers.get(objectArray);
            if (!scriptDispatcher.isSupportedBy(connection)) continue;
            vector.addElement(objectArray);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] getEventSubtypes(String string) {
        ScriptDispatcher scriptDispatcher = this.getScriptDispatcher(string);
        if (scriptDispatcher == null) {
            throw new IllegalArgumentException("The specified event type (" + string + ") is not supported");
        }
        return scriptDispatcher.getEventSubtypes();
    }

    public Object[][] getAvailableVariables(String string, String[] stringArray) {
        ScriptDispatcher scriptDispatcher = this.getScriptDispatcher(string);
        if (scriptDispatcher == null) {
            throw new IllegalArgumentException("The specified event type (" + string + ") is not supported");
        }
        return scriptDispatcher.getAvailableVars(stringArray);
    }

    public void start() {
        this.loadScripts();
    }

    public void saveState() {
        this.saveScripts();
    }

    public void addScript(Script script) {
        if (script == null) {
            throw new IllegalArgumentException("Null script specified");
        }
        String string = script.getEventType();
        ScriptDispatcher scriptDispatcher = this.getScriptDispatcher(string);
        if (scriptDispatcher == null) {
            throw new IllegalArgumentException("" + script + " is of an unsupported/unknown event type (" + string + ")");
        }
        scriptDispatcher.addScript(script);
    }

    public void removeScript(Script script) {
        String string = script.getEventType();
        ScriptDispatcher scriptDispatcher = this.getScriptDispatcher(string);
        if (scriptDispatcher == null) {
            throw new IllegalArgumentException("" + script + " is of an unsupported/unknown event type (" + string + ")");
        }
        scriptDispatcher.removeScript(script);
    }

    public Script[] getScripts() {
        Vector<Script> vector = new Vector<Script>();
        String[] stringArray = this.getSupportedEventTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            ScriptDispatcher scriptDispatcher = this.getScriptDispatcher(string);
            Script[] scriptArray = scriptDispatcher.getScripts();
            for (int j = 0; j < scriptArray.length; ++j) {
                vector.addElement(scriptArray[j]);
            }
        }
        Object[] objectArray = new Script[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean hasPreferencesUI() {
        return true;
    }

    public PreferencesPanel getPreferencesUI() {
        return new ScripterPreferencesPanel(this);
    }

    private void loadScripts() {
        int n = this.getPrefs().getInt("scripts.count", 0);
        for (int i = 0; i < n; ++i) {
            MemoryFile memoryFile = this.getFile("script-" + i);
            if (memoryFile == null) continue;
            Script script = this.parseScript(memoryFile.getInputStream());
            try {
                if (script == null) continue;
                this.addScript(script);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("WARNING: " + illegalArgumentException.getMessage() + ". Script " + script + " will not be run");
            }
        }
    }

    private void saveScripts() {
        Preferences preferences = this.getPrefs();
        int n = preferences.getInt("scripts.count", 0);
        for (int i = 0; i < n; ++i) {
            this.setFile("script-" + i, null);
        }
        Script[] scriptArray = this.getScripts();
        preferences.setInt("scripts.count", scriptArray.length);
        for (int i = 0; i < scriptArray.length; ++i) {
            Script script = scriptArray[i];
            MemoryFile memoryFile = new MemoryFile();
            try {
                OutputStream outputStream = memoryFile.getOutputStream();
                this.writeScript(script, outputStream);
                outputStream.close();
                this.setFile("script-" + i, memoryFile);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private Script parseScript(InputStream inputStream) {
        try {
            Script script;
            String string;
            String string2;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            Properties properties = new Properties();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                string2 = dataInputStream.readUTF();
                string = dataInputStream.readUTF();
                properties.put(string2, string);
            }
            String string3 = properties.getProperty("name");
            string2 = properties.getProperty("type");
            string = this.eventTypeBackwardsCompatibility(properties.getProperty("event-type"));
            boolean bl = "true".equals(properties.getProperty("enabled"));
            String string4 = properties.getProperty("event-subtype.count");
            String[] stringArray = null;
            if (string4 != null) {
                stringArray = new String[Integer.parseInt(string4)];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = this.eventSubtypeBackwardsCompatibility(string, properties.getProperty("event-subtype." + i));
                }
            }
            if ("beanshell".equals(string2)) {
                String string5 = properties.getProperty("code");
                script = new BeanShellScript(this, string3, string, stringArray, string5);
            } else if ("commands".equals(string2)) {
                String string6 = properties.getProperty("condition");
                int n2 = Integer.parseInt(properties.getProperty("command-count"));
                String[] stringArray2 = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    stringArray2[i] = properties.getProperty("command-" + i);
                }
                script = new CommandScript(this, string3, string, stringArray, string6, stringArray2);
            } else {
                return null;
            }
            script.setEnabled(bl);
            return script;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        catch (EvalError evalError) {
            evalError.printStackTrace();
            return null;
        }
    }

    private String eventTypeBackwardsCompatibility(String string) {
        if (this.oldToNewEventTypes == null) {
            this.oldToNewEventTypes = new Hashtable();
            this.oldToNewEventTypes.put("Chat (All types of tells)", "chat");
            this.oldToNewEventTypes.put("Connection", "connection");
            this.oldToNewEventTypes.put("Text (Unparsed text)", "plainText");
            this.oldToNewEventTypes.put("Game", "game");
            this.oldToNewEventTypes.put("Seek", "seek");
            this.oldToNewEventTypes.put("Friends", "friends");
            this.oldToNewEventTypes.put("User Invoked", "userInvoked");
        }
        if (string == null) {
            return null;
        }
        String string2 = (String)this.oldToNewEventTypes.get(string);
        return string2 == null ? string : string2;
    }

    private String eventSubtypeBackwardsCompatibility(String string, String string2) {
        Object object;
        Hashtable hashtable;
        if (this.eventTypesToOldToNewEventSubtypes == null) {
            this.eventTypesToOldToNewEventSubtypes = new Hashtable();
            hashtable = new Hashtable();
            hashtable.put("Personal Tell", "personalTell");
            hashtable.put("(BugHouse) Partner Tell", "partnerTell");
            hashtable.put("Shout", "shout");
            hashtable.put("T-Shout", "tshout");
            hashtable.put("C-Shout", "cshout");
            hashtable.put("Announcement", "announcement");
            hashtable.put("Channel Tell", "channelTell");
            hashtable.put("Kibitz", "kibitz");
            hashtable.put("Whisper", "whisper");
            hashtable.put("QTell", "qtell");
            hashtable.put("Serious Shout", "sshout");
            hashtable.put("Channel QTell", "channelQTell");
            this.eventTypesToOldToNewEventSubtypes.put("chat", hashtable);
            object = new Hashtable();
            ((Hashtable)object).put("Attempt", "attempt");
            ((Hashtable)object).put("Connect", "connect");
            ((Hashtable)object).put("Login", "login");
            ((Hashtable)object).put("Disconnect", "disconnect");
            this.eventTypesToOldToNewEventSubtypes.put("connection", object);
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            hashtable2.put("Game Start", "gameStart");
            hashtable2.put("Move", "move");
            hashtable2.put("Takeback/Backward", "takebackOrBackward");
            hashtable2.put("Board Flip", "boardFlip");
            hashtable2.put("Illegal Move Attempt", "illegalMoveAttempt");
            hashtable2.put("Clock Update", "clockUpdate");
            hashtable2.put("Other Position Change", "otherPositionChange");
            hashtable2.put("Offers", "offers");
            hashtable2.put("Game End", "gameEnd");
            this.eventTypesToOldToNewEventSubtypes.put("game", hashtable2);
            Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
            hashtable3.put("Post", "post");
            hashtable3.put("Withdraw", "withdraw");
            this.eventTypesToOldToNewEventSubtypes.put("seek", hashtable3);
            Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
            hashtable4.put("Online", "online");
            hashtable4.put("Connected", "connected");
            hashtable4.put("Disconnected", "disconnected");
            hashtable4.put("Added", "added");
            hashtable4.put("Removed", "removed");
            this.eventTypesToOldToNewEventSubtypes.put("friends", hashtable4);
        }
        if (string == null || string2 == null) {
            return null;
        }
        hashtable = (Hashtable)this.eventTypesToOldToNewEventSubtypes.get(string);
        if (hashtable == null) {
            return string2;
        }
        object = (String)hashtable.get(string2);
        return object == null ? string2 : object;
    }

    private void writeScript(Script script, OutputStream outputStream) throws IOException {
        Object object;
        Object object2;
        String string = script.getType();
        Properties properties = new Properties();
        properties.put("name", script.getName());
        properties.put("type", string);
        properties.put("event-type", script.getEventType());
        properties.put("enabled", script.isEnabled() ? "true" : "false");
        String[] stringArray = script.getEventSubtypes();
        if (stringArray != null) {
            properties.put("event-subtype.count", String.valueOf(stringArray.length));
            for (int i = 0; i < stringArray.length; ++i) {
                properties.put("event-subtype." + i, stringArray[i]);
            }
        }
        if ("beanshell".equals(string)) {
            BeanShellScript beanShellScript = (BeanShellScript)script;
            object2 = beanShellScript.getCode();
            properties.put("code", object2);
        } else if ("commands".equals(string)) {
            CommandScript commandScript = (CommandScript)script;
            object2 = commandScript.getCondition();
            object = commandScript.getCommands();
            properties.put("condition", object2);
            properties.put("command-count", String.valueOf(((String[])object).length));
            for (int i = 0; i < ((String[])object).length; ++i) {
                properties.put("command-" + i, object[i]);
            }
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(properties.size());
        object2 = properties.propertyNames();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            String string2 = properties.getProperty((String)object);
            dataOutputStream.writeUTF((String)object);
            dataOutputStream.writeUTF(string2);
        }
    }

    public String getId() {
        return "scripter";
    }

    public String getName() {
        return this.getI18n().getString("pluginName");
    }

    private class FriendsScriptDispatcher
    extends ScriptDispatcher
    implements FriendsListener {
        private final String[] subtypes;

        private FriendsScriptDispatcher() {
            this.subtypes = new String[]{"online", "connected", "disconnected", "added", "removed"};
        }

        protected String[] getEventSubtypesImpl() {
            return this.subtypes;
        }

        public boolean isSupportedBy(Connection connection) {
            return connection instanceof FriendsConnection;
        }

        public void registerForEvent(ListenerManager listenerManager) {
            ((FriendsListenerManager)listenerManager).addFriendsListener((FriendsListener)this);
        }

        public void unregisterForEvent(ListenerManager listenerManager) {
            ((FriendsListenerManager)listenerManager).removeFriendsListener((FriendsListener)this);
        }

        public void friendOnline(FriendsEvent friendsEvent) {
            this.runScripts((JinEvent)friendsEvent, this.subtypes[0], new Object[][]{{"name", friendsEvent.getFriendName()}});
        }

        public void friendConnected(FriendsEvent friendsEvent) {
            this.runScripts((JinEvent)friendsEvent, this.subtypes[1], new Object[][]{{"name", friendsEvent.getFriendName()}});
        }

        public void friendDisconnected(FriendsEvent friendsEvent) {
            this.runScripts((JinEvent)friendsEvent, this.subtypes[2], new Object[][]{{"name", friendsEvent.getFriendName()}});
        }

        public void friendAdded(FriendsEvent friendsEvent) {
            this.runScripts((JinEvent)friendsEvent, this.subtypes[3], new Object[][]{{"name", friendsEvent.getFriendName()}});
        }

        public void friendRemoved(FriendsEvent friendsEvent) {
            this.runScripts((JinEvent)friendsEvent, this.subtypes[4], new Object[][]{{"name", friendsEvent.getFriendName()}});
        }

        protected Object[][] getAvailableVars(String[] stringArray) {
            return new Object[][]{{"name", "AlexTheGreat"}};
        }
    }

    private class SeekScriptDispatcher
    extends ScriptDispatcher
    implements SeekListener {
        private final String[] subtypes;

        private SeekScriptDispatcher() {
            this.subtypes = new String[]{"post", "withdraw"};
        }

        protected String[] getEventSubtypesImpl() {
            return this.subtypes;
        }

        public boolean isSupportedBy(Connection connection) {
            return connection instanceof SeekConnection;
        }

        public void registerForEvent(ListenerManager listenerManager) {
            ((SeekListenerManager)listenerManager).addSeekListener((SeekListener)this);
        }

        public void unregisterForEvent(ListenerManager listenerManager) {
            ((SeekListenerManager)listenerManager).removeSeekListener((SeekListener)this);
        }

        private Vector createVarsVector(SeekEvent seekEvent) {
            Vector<Object[]> vector = new Vector<Object[]>(15);
            Seek seek = seekEvent.getSeek();
            vector.addElement(new Object[]{"seek", seek});
            vector.addElement(new Object[]{"name", seek.getSeekerName()});
            vector.addElement(new Object[]{"title", seek.getSeekerTitle()});
            vector.addElement(new Object[]{"rating", new Integer(seek.getSeekerRating())});
            vector.addElement(new Object[]{"isProvisional", seek.isSeekerProvisional() ? Boolean.TRUE : Boolean.FALSE});
            vector.addElement(new Object[]{"isRegistered", seek.isSeekerRegistered() ? Boolean.TRUE : Boolean.FALSE});
            vector.addElement(new Object[]{"isComputer", seek.isSeekerComputer() ? Boolean.TRUE : Boolean.FALSE});
            vector.addElement(new Object[]{"ratingCategory", seek.getRatingCategoryString()});
            vector.addElement(new Object[]{"time", new Integer(seek.getTime() / 60000)});
            vector.addElement(new Object[]{"inc", new Integer(seek.getInc() / 1000)});
            vector.addElement(new Object[]{"isRated", seek.isRated() ? Boolean.TRUE : Boolean.FALSE});
            String string = seek.getSoughtColor() == null ? null : (seek.getSoughtColor().isWhite() ? "white" : "black");
            vector.addElement(new Object[]{"color", string});
            vector.addElement(new Object[]{"ratingLimited", seek.isRatingLimited() ? Boolean.TRUE : Boolean.FALSE});
            vector.addElement(new Object[]{"minRating", new Integer(seek.getMinRating())});
            vector.addElement(new Object[]{"maxRating", new Integer(seek.getMaxRating())});
            vector.addElement(new Object[]{"isManualAccept", seek.isManualAccept() ? Boolean.TRUE : Boolean.FALSE});
            vector.addElement(new Object[]{"isFormula", seek.isFormula() ? Boolean.TRUE : Boolean.FALSE});
            return vector;
        }

        public void seekAdded(SeekEvent seekEvent) {
            Vector vector = this.createVarsVector(seekEvent);
            Object[][] objectArray = new Object[vector.size()][];
            vector.copyInto((Object[])objectArray);
            this.runScripts((JinEvent)seekEvent, this.subtypes[0], objectArray);
        }

        public void seekRemoved(SeekEvent seekEvent) {
            Vector vector = this.createVarsVector(seekEvent);
            Object[][] objectArray = new Object[vector.size()][];
            vector.copyInto((Object[])objectArray);
            this.runScripts((JinEvent)seekEvent, this.subtypes[1], objectArray);
        }

        protected Object[][] getAvailableVars(String[] stringArray) {
            Vector<Object[]> vector = new Vector<Object[]>(25);
            Seek seek = new Seek("64", "AlexTheGreat", "C", 1800, false, true, true, true, (WildVariant)Chess.getInstance(), "Blitz", 300000, 2000, true, null, true, 1700, 1900, false, false);
            vector.addElement(new Object[]{"seek", seek});
            vector.addElement(new Object[]{"name", seek.getSeekerName()});
            vector.addElement(new Object[]{"title", seek.getSeekerTitle()});
            vector.addElement(new Object[]{"rating", new Integer(seek.getSeekerRating())});
            vector.addElement(new Object[]{"isProvisional", seek.isSeekerProvisional() ? Boolean.TRUE : Boolean.FALSE});
            vector.addElement(new Object[]{"isRegistered", seek.isSeekerRegistered() ? Boolean.TRUE : Boolean.FALSE});
            vector.addElement(new Object[]{"isComputer", seek.isSeekerComputer() ? Boolean.TRUE : Boolean.FALSE});
            vector.addElement(new Object[]{"ratingCategory", seek.getRatingCategoryString()});
            vector.addElement(new Object[]{"time", new Integer(seek.getTime() / 60000)});
            vector.addElement(new Object[]{"inc", new Integer(seek.getInc() / 1000)});
            vector.addElement(new Object[]{"isRated", seek.isRated() ? Boolean.TRUE : Boolean.FALSE});
            String string = seek.getSoughtColor() == null ? null : (seek.getSoughtColor().isWhite() ? "white" : "black");
            vector.addElement(new Object[]{"color", string});
            vector.addElement(new Object[]{"ratingLimited", seek.isRatingLimited() ? Boolean.TRUE : Boolean.FALSE});
            vector.addElement(new Object[]{"minRating", new Integer(seek.getMinRating())});
            vector.addElement(new Object[]{"maxRating", new Integer(seek.getMaxRating())});
            vector.addElement(new Object[]{"isManualAccept", seek.isManualAccept() ? Boolean.TRUE : Boolean.FALSE});
            vector.addElement(new Object[]{"isFormula", seek.isFormula() ? Boolean.TRUE : Boolean.FALSE});
            Object[][] objectArray = new Object[vector.size()][];
            vector.copyInto((Object[])objectArray);
            return objectArray;
        }
    }

    private class GameScriptDispatcher
    extends ScriptDispatcher
    implements GameListener {
        private final String[] subtypes;

        private GameScriptDispatcher() {
            this.subtypes = new String[]{"gameStart", "move", "takebackOrBackward", "boardFlip", "illegalMoveAttempt", "clockUpdate", "otherPositionChange", "offers", "gameEnd"};
        }

        protected String[] getEventSubtypesImpl() {
            return this.subtypes;
        }

        public boolean isSupportedBy(Connection connection) {
            return true;
        }

        public void registerForEvent(ListenerManager listenerManager) {
            listenerManager.addGameListener((GameListener)this);
        }

        public void unregisterForEvent(ListenerManager listenerManager) {
            listenerManager.removeGameListener((GameListener)this);
        }

        private Vector createVarsVector(GameEvent gameEvent) {
            String string;
            Vector<Object[]> vector = new Vector<Object[]>(29);
            Game game = gameEvent.getGame();
            vector.addElement(new Object[]{"game", game});
            int n = game.getGameType();
            switch (n) {
                case 1: {
                    string = "my";
                    break;
                }
                case 2: {
                    string = "observed";
                    break;
                }
                case 3: {
                    string = "isolated";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown game type: " + n);
                }
            }
            vector.addElement(new Object[]{"gameType", string});
            vector.addElement(new Object[]{"initialPosition", game.getInitialPosition()});
            vector.addElement(new Object[]{"variant", game.getVariant().getName()});
            Player player = game.getUserPlayer();
            vector.addElement(new Object[]{"whiteName", game.getWhiteName()});
            vector.addElement(new Object[]{"blackName", game.getBlackName()});
            vector.addElement(new Object[]{"whiteTime", new Integer(game.getWhiteTime() / 60000)});
            vector.addElement(new Object[]{"whiteInc", new Integer(game.getWhiteInc() / 1000)});
            vector.addElement(new Object[]{"blackTime", new Integer(game.getBlackTime() / 60000)});
            vector.addElement(new Object[]{"blackInc", new Integer(game.getBlackInc() / 1000)});
            vector.addElement(new Object[]{"whiteRating", new Integer(game.getWhiteRating())});
            vector.addElement(new Object[]{"blackRating", new Integer(game.getBlackRating())});
            vector.addElement(new Object[]{"whiteTitle", game.getWhiteTitles()});
            vector.addElement(new Object[]{"blackTitle", game.getBlackTitles()});
            vector.addElement(new Object[]{"isGameRated", game.isRated() ? Boolean.TRUE : Boolean.FALSE});
            vector.addElement(new Object[]{"ratingCategory", game.getRatingCategoryString()});
            vector.addElement(new Object[]{"isPlayed", game.isPlayed() ? Boolean.TRUE : Boolean.FALSE});
            vector.addElement(new Object[]{"isTimeOdds", game.isTimeOdds() ? Boolean.TRUE : Boolean.FALSE});
            if (player != null) {
                if (player.isWhite()) {
                    vector.addElement(new Object[]{"myName", game.getWhiteName()});
                    vector.addElement(new Object[]{"oppName", game.getBlackName()});
                    vector.addElement(new Object[]{"myTime", new Integer(game.getWhiteTime() / 60000)});
                    vector.addElement(new Object[]{"myInc", new Integer(game.getWhiteInc() / 1000)});
                    vector.addElement(new Object[]{"oppTime", new Integer(game.getBlackTime() / 60000)});
                    vector.addElement(new Object[]{"oppInc", new Integer(game.getBlackInc() / 1000)});
                    vector.addElement(new Object[]{"myRating", new Integer(game.getWhiteRating())});
                    vector.addElement(new Object[]{"oppRating", new Integer(game.getBlackRating())});
                    vector.addElement(new Object[]{"myTitle", game.getWhiteTitles()});
                    vector.addElement(new Object[]{"oppTitle", game.getBlackTitles()});
                } else {
                    vector.addElement(new Object[]{"oppName", game.getWhiteName()});
                    vector.addElement(new Object[]{"myName", game.getBlackName()});
                    vector.addElement(new Object[]{"oppTime", new Integer(game.getWhiteTime() / 60000)});
                    vector.addElement(new Object[]{"oppInc", new Integer(game.getWhiteInc() / 1000)});
                    vector.addElement(new Object[]{"myTime", new Integer(game.getBlackTime() / 60000)});
                    vector.addElement(new Object[]{"myInc", new Integer(game.getBlackInc() / 1000)});
                    vector.addElement(new Object[]{"oppRating", new Integer(game.getWhiteRating())});
                    vector.addElement(new Object[]{"myRating", new Integer(game.getBlackRating())});
                    vector.addElement(new Object[]{"oppTitle", game.getWhiteTitles()});
                    vector.addElement(new Object[]{"myTitle", game.getBlackTitles()});
                }
                vector.addElement(new Object[]{"userPlayer", game.getUserPlayer().toString().toLowerCase()});
            }
            return vector;
        }

        public void gameStarted(GameStartEvent gameStartEvent) {
            Vector vector = this.createVarsVector((GameEvent)gameStartEvent);
            Object[][] objectArray = new Object[vector.size()][];
            vector.copyInto((Object[])objectArray);
            this.runScripts((JinEvent)gameStartEvent, this.subtypes[0], objectArray);
        }

        public void moveMade(MoveMadeEvent moveMadeEvent) {
            Vector vector = this.createVarsVector((GameEvent)moveMadeEvent);
            vector.addElement(new Object[]{"move", moveMadeEvent.getMove()});
            Object[][] objectArray = new Object[vector.size()][];
            vector.copyInto((Object[])objectArray);
            this.runScripts((JinEvent)moveMadeEvent, this.subtypes[1], objectArray);
        }

        public void positionChanged(PositionChangedEvent positionChangedEvent) {
            Vector vector = this.createVarsVector((GameEvent)positionChangedEvent);
            vector.addElement(new Object[]{"newPosition", positionChangedEvent.getPosition()});
            Object[][] objectArray = new Object[vector.size()][];
            vector.copyInto((Object[])objectArray);
            this.runScripts((JinEvent)positionChangedEvent, this.subtypes[6], objectArray);
        }

        public void takebackOccurred(TakebackEvent takebackEvent) {
            Vector vector = this.createVarsVector((GameEvent)takebackEvent);
            vector.addElement(new Object[]{"takebackCount", new Integer(takebackEvent.getTakebackCount())});
            Object[][] objectArray = new Object[vector.size()][];
            vector.copyInto((Object[])objectArray);
            this.runScripts((JinEvent)takebackEvent, this.subtypes[2], objectArray);
        }

        public void illegalMoveAttempted(IllegalMoveEvent illegalMoveEvent) {
            Vector vector = this.createVarsVector((GameEvent)illegalMoveEvent);
            vector.addElement(new Object[]{"illegalMove", illegalMoveEvent.getMove()});
            Object[][] objectArray = new Object[vector.size()][];
            vector.copyInto((Object[])objectArray);
            this.runScripts((JinEvent)illegalMoveEvent, this.subtypes[4], objectArray);
        }

        public void clockAdjusted(ClockAdjustmentEvent clockAdjustmentEvent) {
            Vector vector = this.createVarsVector((GameEvent)clockAdjustmentEvent);
            vector.addElement(new Object[]{"player", clockAdjustmentEvent.getPlayer().toString().toLowerCase()});
            vector.addElement(new Object[]{"time", new Integer(clockAdjustmentEvent.getTime())});
            vector.addElement(new Object[]{"isClockRunning", clockAdjustmentEvent.isClockRunning() ? Boolean.TRUE : Boolean.FALSE});
            Object[][] objectArray = new Object[vector.size()][];
            vector.copyInto((Object[])objectArray);
            this.runScripts((JinEvent)clockAdjustmentEvent, this.subtypes[5], objectArray);
        }

        public void boardFlipped(BoardFlipEvent boardFlipEvent) {
            Vector vector = this.createVarsVector((GameEvent)boardFlipEvent);
            vector.addElement(new Object[]{"isFlipped", boardFlipEvent.isFlipped() ? Boolean.TRUE : Boolean.FALSE});
            Object[][] objectArray = new Object[vector.size()][];
            vector.copyInto((Object[])objectArray);
            this.runScripts((JinEvent)boardFlipEvent, this.subtypes[3], objectArray);
        }

        public void offerUpdated(OfferEvent offerEvent) {
            String string;
            switch (offerEvent.getOfferId()) {
                case 1: {
                    string = "draw";
                    break;
                }
                case 2: {
                    string = "adjourn";
                    break;
                }
                case 3: {
                    string = "abort";
                    break;
                }
                case 4: {
                    string = "takeback";
                    break;
                }
                default: {
                    return;
                }
            }
            Vector vector = this.createVarsVector((GameEvent)offerEvent);
            vector.addElement(new Object[]{"offerType", string});
            vector.addElement(new Object[]{"isOffered", offerEvent.isOffered() ? Boolean.TRUE : Boolean.FALSE});
            vector.addElement(new Object[]{"player", offerEvent.getPlayer().toString().toLowerCase()});
            if (offerEvent.getOfferId() == 4) {
                vector.addElement(new Object[]{"takebackCount", new Integer(offerEvent.getTakebackCount())});
            }
            Object[][] objectArray = new Object[vector.size()][];
            vector.copyInto((Object[])objectArray);
            this.runScripts((JinEvent)offerEvent, this.subtypes[7], objectArray);
        }

        public void gameEnded(GameEndEvent gameEndEvent) {
            String string;
            Vector vector;
            block19: {
                int n;
                block20: {
                    Player player;
                    block18: {
                        vector = this.createVarsVector((GameEvent)gameEndEvent);
                        n = gameEndEvent.getResult();
                        player = gameEndEvent.getGame().getUserPlayer();
                        if (player != null) break block18;
                        switch (n) {
                            case 1: {
                                string = "1-0";
                                break block19;
                            }
                            case 2: {
                                string = "0-1";
                                break block19;
                            }
                            case 3: {
                                string = "1/2-1/2";
                                break block19;
                            }
                            case 4: {
                                string = "unknown";
                                break block19;
                            }
                            default: {
                                throw new IllegalStateException("Unknown/bad game result value: " + n);
                            }
                        }
                    }
                    if (!player.isWhite()) break block20;
                    switch (n) {
                        case 1: {
                            string = "win";
                            break block19;
                        }
                        case 2: {
                            string = "loss";
                            break block19;
                        }
                        case 3: {
                            string = "draw";
                            break block19;
                        }
                        case 4: {
                            string = "unknown";
                            break block19;
                        }
                        default: {
                            throw new IllegalStateException("Unknown game result value: " + n);
                        }
                    }
                }
                switch (n) {
                    case 1: {
                        string = "loss";
                        break;
                    }
                    case 2: {
                        string = "win";
                        break;
                    }
                    case 3: {
                        string = "draw";
                        break;
                    }
                    case 4: {
                        string = "unknown";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown game result value: " + n);
                    }
                }
            }
            vector.addElement(new Object[]{"gameResult", string});
            Object[][] objectArray = new Object[vector.size()][];
            vector.copyInto((Object[])objectArray);
            this.runScripts((JinEvent)gameEndEvent, this.subtypes[8], objectArray);
        }

        protected Object[][] getAvailableVars(String[] stringArray) {
            Vector<Object[]> vector = new Vector<Object[]>(29);
            Game game = new Game(1, new Position(), 0, "AlexTheGreat", "Kasparov", 300000, 2000, 300000, 2000, 1800, 2852, (Object)"blah", "Blitz", true, true, "C", "GM", false, Player.WHITE_PLAYER);
            vector.addElement(new Object[]{"game", game});
            vector.addElement(new Object[]{"gameType", new Integer(game.getGameType())});
            vector.addElement(new Object[]{"initialPosition", game.getInitialPosition()});
            vector.addElement(new Object[]{"variant", game.getVariant()});
            vector.addElement(new Object[]{"myName", game.getWhiteName()});
            vector.addElement(new Object[]{"oppName", game.getBlackName()});
            vector.addElement(new Object[]{"myTime", new Integer(game.getWhiteTime() / 60000)});
            vector.addElement(new Object[]{"myInc", new Integer(game.getWhiteInc() / 1000)});
            vector.addElement(new Object[]{"oppTime", new Integer(game.getBlackTime() / 60000)});
            vector.addElement(new Object[]{"oppInc", new Integer(game.getBlackInc() / 1000)});
            vector.addElement(new Object[]{"myRating", new Integer(game.getWhiteRating())});
            vector.addElement(new Object[]{"oppRating", new Integer(game.getBlackRating())});
            vector.addElement(new Object[]{"myTitle", game.getWhiteTitles()});
            vector.addElement(new Object[]{"oppTitle", game.getBlackTitles()});
            vector.addElement(new Object[]{"whiteName", game.getWhiteName()});
            vector.addElement(new Object[]{"blackName", game.getBlackName()});
            vector.addElement(new Object[]{"whiteTime", new Integer(game.getWhiteTime() / 60000)});
            vector.addElement(new Object[]{"whiteInc", new Integer(game.getWhiteInc() / 1000)});
            vector.addElement(new Object[]{"blackTime", new Integer(game.getBlackTime() / 60000)});
            vector.addElement(new Object[]{"blackInc", new Integer(game.getBlackInc() / 1000)});
            vector.addElement(new Object[]{"whiteRating", new Integer(game.getWhiteRating())});
            vector.addElement(new Object[]{"blackRating", new Integer(game.getBlackRating())});
            vector.addElement(new Object[]{"whiteTitle", game.getWhiteTitles()});
            vector.addElement(new Object[]{"blackTitle", game.getBlackTitles()});
            vector.addElement(new Object[]{"isGameRated", game.isRated() ? Boolean.TRUE : Boolean.FALSE});
            vector.addElement(new Object[]{"ratingCategory", game.getRatingCategoryString()});
            vector.addElement(new Object[]{"isPlayed", game.isPlayed() ? Boolean.TRUE : Boolean.FALSE});
            vector.addElement(new Object[]{"isTimeOdds", game.isTimeOdds() ? Boolean.TRUE : Boolean.FALSE});
            ChessMove chessMove = new ChessMove(Square.parseSquare((String)"e2"), Square.parseSquare((String)"e4"), Player.WHITE_PLAYER, false, false, false, null, 4, null, "e4");
            if (Utilities.contains((Object[])stringArray, (Object)this.subtypes[1])) {
                vector.addElement(new Object[]{"move", chessMove});
            }
            if (Utilities.contains((Object[])stringArray, (Object)this.subtypes[6])) {
                vector.addElement(new Object[]{"newPosition", new Position()});
            }
            if (Utilities.contains((Object[])stringArray, (Object)this.subtypes[2])) {
                vector.addElement(new Object[]{"takebackCount", new Integer(3)});
            }
            if (Utilities.contains((Object[])stringArray, (Object)this.subtypes[4])) {
                vector.addElement(new Object[]{"illegalMove", chessMove});
            }
            if (Utilities.contains((Object[])stringArray, (Object)this.subtypes[5])) {
                vector.addElement(new Object[]{"player", Player.WHITE_PLAYER.toString().toLowerCase()});
                vector.addElement(new Object[]{"time", new Integer(240000)});
                vector.addElement(new Object[]{"isClockRunning", Boolean.TRUE});
            }
            if (Utilities.contains((Object[])stringArray, (Object)this.subtypes[3])) {
                vector.addElement(new Object[]{"isFlipped", Boolean.TRUE});
            }
            if (Utilities.contains((Object[])stringArray, (Object)this.subtypes[7])) {
                vector.addElement(new Object[]{"offerType", "draw"});
                vector.addElement(new Object[]{"isMade", Boolean.TRUE});
                vector.addElement(new Object[]{"player", Player.WHITE_PLAYER.toString().toLowerCase()});
            }
            if (Utilities.contains((Object[])stringArray, (Object)this.subtypes[8])) {
                vector.addElement(new Object[]{"gameResult", "win"});
            }
            Object[][] objectArray = new Object[vector.size()][];
            vector.copyInto((Object[])objectArray);
            return objectArray;
        }
    }

    private class PlainTextScriptDispatcher
    extends ScriptDispatcher
    implements PlainTextListener {
        private PlainTextScriptDispatcher() {
        }

        protected String[] getEventSubtypesImpl() {
            return null;
        }

        public boolean isSupportedBy(Connection connection) {
            return true;
        }

        public void registerForEvent(ListenerManager listenerManager) {
            listenerManager.addPlainTextListener((PlainTextListener)this);
        }

        public void unregisterForEvent(ListenerManager listenerManager) {
            listenerManager.removePlainTextListener((PlainTextListener)this);
        }

        public void plainTextReceived(PlainTextEvent plainTextEvent) {
            this.runScripts((JinEvent)plainTextEvent, null, new Object[][]{{"text", plainTextEvent.getText()}});
        }

        protected Object[][] getAvailableVars(String[] stringArray) {
            return new Object[][]{{"text", "hello!"}};
        }
    }

    private class ConnectionScriptDispatcher
    extends ScriptDispatcher
    implements ConnectionListener {
        private final String[] subtypes;

        private ConnectionScriptDispatcher() {
            this.subtypes = new String[]{"attempt", "connect", "login", "disconnect"};
        }

        protected String[] getEventSubtypesImpl() {
            return this.subtypes;
        }

        public boolean isSupportedBy(Connection connection) {
            return true;
        }

        public void registerForEvent(ListenerManager listenerManager) {
            listenerManager.addConnectionListener((ConnectionListener)this);
        }

        public void unregisterForEvent(ListenerManager listenerManager) {
            listenerManager.removeConnectionListener((ConnectionListener)this);
        }

        public void connectionAttempted(Connection connection, String string, int n) {
            this.runScripts(null, this.subtypes[0], null);
        }

        public void connectionEstablished(Connection connection) {
            this.runScripts(null, this.subtypes[1], null);
        }

        public void loginSucceeded(Connection connection) {
            this.runScripts(null, this.subtypes[2], null);
        }

        public void connectionLost(Connection connection) {
            this.runScripts(null, this.subtypes[3], null);
        }

        public void connectingFailed(Connection connection, String string) {
        }

        public void loginFailed(Connection connection, String string) {
        }

        protected Object[][] getAvailableVars(String[] stringArray) {
            return null;
        }
    }

    protected abstract class ScriptDispatcher {
        private final Vector scripts = new Vector();

        public final String[] getEventSubtypes() {
            String[] stringArray = this.getEventSubtypesImpl();
            return stringArray == null ? null : (String[])stringArray.clone();
        }

        protected abstract String[] getEventSubtypesImpl();

        public void addScript(Script script) {
            if (this.scripts.size() == 0) {
                this.registerForEvent(Scripter.this.getConn().getListenerManager());
            }
            this.scripts.addElement(script);
        }

        public void removeScript(Script script) {
            if (!this.scripts.removeElement(script)) {
                throw new IllegalArgumentException("The specified script (" + script + ") has not been previously registered with this ScriptDispatcher (" + this + ").");
            }
            if (this.scripts.size() == 0) {
                this.unregisterForEvent(Scripter.this.getConn().getListenerManager());
            }
        }

        public Script[] getScripts() {
            Object[] objectArray = new Script[this.scripts.size()];
            this.scripts.copyInto(objectArray);
            return objectArray;
        }

        protected void runScripts(JinEvent jinEvent, String string, Object[][] objectArray) {
            Object[] objectArray2 = this.getEventSubtypesImpl();
            if (!(objectArray2 == null || string != null && Utilities.contains((Object[])objectArray2, (Object)string))) {
                System.err.println("Unknown event subtype occurred: " + string);
                return;
            }
            if (objectArray == null) {
                objectArray = new Object[][]{};
            }
            int n = this.scripts.size();
            for (int i = 0; i < n; ++i) {
                Script script = (Script)this.scripts.elementAt(i);
                Object[] objectArray3 = script.getEventSubtypes();
                if (!script.isEnabled() || string != null && !Utilities.contains((Object[])objectArray3, (Object)string)) continue;
                try {
                    script.run(jinEvent, string, objectArray);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                }
            }
        }

        public abstract boolean isSupportedBy(Connection var1);

        protected abstract void registerForEvent(ListenerManager var1);

        protected abstract void unregisterForEvent(ListenerManager var1);

        protected abstract Object[][] getAvailableVars(String[] var1);
    }
}

