/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHCastExpression;
import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.Capabilities;
import bsh.ClassPathException;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Name;
import bsh.NameSource;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.This;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NameSpace
implements Serializable,
BshClassManager.Listener,
NameSource {
    public static final NameSpace JAVACODE = new NameSpace("Called from compiled Java code");
    private static transient boolean superImport;
    public String name;
    private NameSpace parent;
    private Hashtable variables;
    private Hashtable methods;
    private Hashtable importedClasses;
    private This thisReference;
    private Vector importedPackages;
    private transient Hashtable classCache;
    SimpleNode callerInfoNode;
    Vector nameSourceListeners;
    private static /* synthetic */ Class class$Ljava$lang$Boolean;
    private static /* synthetic */ Class class$Ljava$lang$Character;
    private static /* synthetic */ Class class$Ljava$lang$Number;
    private static /* synthetic */ Class class$Ljava$lang$Short;
    private static /* synthetic */ Class class$Ljava$lang$Byte;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$lang$Long;
    private static /* synthetic */ Class class$Ljava$lang$Float;
    private static /* synthetic */ Class class$Ljava$lang$Double;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    void setNode(SimpleNode simpleNode) {
        this.callerInfoNode = simpleNode;
    }

    SimpleNode getNode() {
        return this.callerInfoNode;
    }

    public Object get(String string, Interpreter interpreter) throws EvalError {
        CallStack callStack = new CallStack();
        return this.getNameResolver(string).toObject(callStack, interpreter);
    }

    public void setVariable(String string, Object object) throws EvalError {
        if (this.variables == null) {
            this.variables = new Hashtable();
        }
        if (object == null) {
            this.variables.remove(string);
            return;
        }
        boolean bl = Interpreter.strictJava;
        Object object2 = this.getVariableImpl(string, bl);
        if (object2 != null && object2 instanceof TypedVariable) {
            try {
                ((TypedVariable)object2).setValue(object);
            }
            catch (EvalError evalError) {
                throw new EvalError("Typed variable: " + string + ": " + evalError.getMessage());
            }
        } else {
            if (Interpreter.strictJava) {
                throw new EvalError("(Strict Java mode) Assignment to undeclared variable: " + string);
            }
            this.variables.put(string, object);
        }
    }

    public String[] getVariableNames() {
        if (this.variables == null) {
            return new String[0];
        }
        return this.enumerationToStringArray(this.variables.keys());
    }

    public String[] getMethodNames() {
        if (this.methods == null) {
            return new String[0];
        }
        return this.enumerationToStringArray(this.methods.keys());
    }

    public BshMethod[] getMethods() {
        if (this.methods == null) {
            return new BshMethod[0];
        }
        return this.flattenMethodCollection(this.methods.elements());
    }

    private final String[] enumerationToStringArray(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private final BshMethod[] flattenMethodCollection(Enumeration enumeration) {
        Object object;
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object instanceof BshMethod) {
                vector.addElement(object);
                continue;
            }
            Vector vector2 = (Vector)object;
            int n = 0;
            while (n < vector2.size()) {
                vector.addElement(vector2.elementAt(n));
                ++n;
            }
        }
        object = new BshMethod[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public NameSpace getParent() {
        return this.parent;
    }

    public NameSpace getSuper() {
        if (this.parent != null) {
            return this.parent;
        }
        return this;
    }

    public NameSpace getGlobal() {
        if (this.parent != null) {
            return this.parent.getGlobal();
        }
        return this;
    }

    This getThis(Interpreter interpreter) {
        if (this.thisReference == null) {
            this.thisReference = This.getThis(this, interpreter);
        }
        return this.thisReference;
    }

    public void prune() {
        this.setParent(null);
    }

    public void setParent(NameSpace nameSpace) {
        this.parent = nameSpace;
        if (nameSpace == null) {
            this.loadDefaultImports();
        }
    }

    public Object getVariable(String string) {
        return this.getVariable(string, true);
    }

    public Object getVariable(String string, boolean bl) {
        Object object = this.getVariableImpl(string, bl);
        return this.unwrapVariable(object);
    }

    protected Object unwrapVariable(Object object) {
        if (object instanceof TypedVariable) {
            object = ((TypedVariable)object).getValue();
        }
        return object == null ? Primitive.VOID : object;
    }

    protected Object getVariableImpl(String string, boolean bl) {
        Object object = null;
        if (this.variables != null) {
            object = this.variables.get(string);
        }
        if (bl && object == null && this.parent != null) {
            object = this.parent.getVariableImpl(string, bl);
        }
        return object;
    }

    public void setTypedVariable(String string, Class clazz, Object object, boolean bl) throws EvalError {
        Object object2;
        if (this.variables == null) {
            this.variables = new Hashtable();
        }
        if (object == null) {
            if (clazz.isPrimitive()) {
                if (clazz == Boolean.TYPE) {
                    object = new Primitive(Boolean.FALSE);
                } else if (clazz == Byte.TYPE) {
                    object = new Primitive(0);
                } else if (clazz == Short.TYPE) {
                    object = new Primitive(0);
                } else if (clazz == Character.TYPE) {
                    object = new Primitive('\u0000');
                } else if (clazz == Integer.TYPE) {
                    object = new Primitive(0);
                } else if (clazz == Long.TYPE) {
                    object = new Primitive(0L);
                } else if (clazz == Float.TYPE) {
                    object = new Primitive(0.0f);
                } else if (clazz == Double.TYPE) {
                    object = new Primitive(0.0);
                }
            } else {
                object = Primitive.NULL;
            }
        }
        if (this.variables.containsKey(string) && (object2 = this.getVariableImpl(string, false)) instanceof TypedVariable) {
            if (((TypedVariable)object2).getType() != clazz) {
                throw new EvalError("Typed variable: " + string + " was previously declared with type: " + ((TypedVariable)object2).getType());
            }
            ((TypedVariable)object2).setValue(object);
            return;
        }
        this.variables.put(string, new TypedVariable(clazz, object, bl));
    }

    public void setMethod(String string, BshMethod bshMethod) {
        Object v;
        if (this.methods == null) {
            this.methods = new Hashtable();
        }
        if ((v = this.methods.get(string)) == null) {
            this.methods.put(string, bshMethod);
        } else if (v instanceof BshMethod) {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(v);
            vector.addElement(bshMethod);
            this.methods.put(string, vector);
        } else {
            ((Vector)v).addElement(bshMethod);
        }
    }

    public BshMethod getMethod(String string, Class[] classArray) {
        Object object = null;
        Object var4_4 = null;
        if (this.methods != null) {
            var4_4 = this.methods.get(string);
        }
        if (var4_4 instanceof Vector) {
            Vector vector = var4_4;
            Object[] objectArray = new BshMethod[vector.size()];
            vector.copyInto(objectArray);
            Class[][] classArray2 = new Class[objectArray.length][];
            int n = 0;
            while (n < objectArray.length) {
                classArray2[n] = ((BshMethod)objectArray[n]).getArgTypes();
                ++n;
            }
            n = Reflect.findMostSpecificSignature(classArray, classArray2);
            if (n != -1) {
                object = objectArray[n];
            }
        } else {
            object = var4_4;
        }
        if (object == null && this.parent != null) {
            return this.parent.getMethod(string, classArray);
        }
        return object;
    }

    public void importClass(String string) {
        if (this.importedClasses == null) {
            this.importedClasses = new Hashtable();
        }
        this.importedClasses.put(Name.suffix(string, 1), string);
        this.nameSpaceChanged();
    }

    public void importPackage(String string) {
        if (this.importedPackages == null) {
            this.importedPackages = new Vector();
        }
        this.importedPackages.addElement(string);
        this.nameSpaceChanged();
    }

    public String[] getImportedPackages() {
        Vector vector = this.getImportedPackages(true);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Vector getImportedPackages(boolean bl) {
        if (!bl) {
            return this.importedPackages;
        }
        Vector<String> vector = new Vector<String>();
        if (this.parent != null) {
            String[] stringArray = this.parent.getImportedPackages();
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
        }
        if (this.importedPackages != null) {
            int n = 0;
            while (n < this.importedPackages.size()) {
                vector.addElement((String)this.importedPackages.elementAt(n));
                ++n;
            }
        }
        return vector;
    }

    private final void cacheClass(Class clazz) {
        if (this.classCache == null) {
            this.classCache = new Hashtable();
        }
        this.classCache.put(this.name, clazz);
    }

    public Class getClass(String string) throws ClassPathException {
        Class clazz = this.getClassImpl(string);
        if (clazz != null) {
            return clazz;
        }
        if (this.parent != null) {
            return this.parent.getClass(string);
        }
        return null;
    }

    private final Class getClassImpl(String string) throws ClassPathException {
        boolean bl = !Name.isCompound(string);
        Class clazz = null;
        if (this.classCache != null && (clazz = (Class)this.classCache.get(string)) != null) {
            return clazz;
        }
        if (bl && (clazz = this.getImportedClassImpl(string)) != null) {
            this.cacheClass(clazz);
            return clazz;
        }
        clazz = this.classForName(string);
        if (clazz != null) {
            if (bl) {
                this.cacheClass(clazz);
            }
            return clazz;
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("getClass(): " + string + " not\tfound in " + this);
        }
        return null;
    }

    private final Class getImportedClassImpl(String string) throws ClassPathException {
        BshClassManager bshClassManager;
        String string2;
        String string3 = null;
        if (this.importedClasses != null) {
            string3 = (String)this.importedClasses.get(string);
        }
        if (string3 != null) {
            Class clazz = this.classForName(string3);
            if (clazz == null) {
                if (Name.isCompound(string3)) {
                    try {
                        clazz = this.getNameResolver(string3).toClass();
                    }
                    catch (EvalError evalError) {}
                } else if (Interpreter.DEBUG) {
                    Interpreter.debug("imported unpackaged name not found:" + string3);
                }
                if (clazz != null) {
                    BshClassManager.cacheClassInfo(string3, clazz);
                    return clazz;
                }
            } else {
                return clazz;
            }
            return null;
        }
        if (this.importedPackages != null) {
            int n = this.importedPackages.size() - 1;
            while (n >= 0) {
                string2 = (String)this.importedPackages.elementAt(n) + "." + string;
                Class clazz = this.classForName(string2);
                if (clazz != null) {
                    return clazz;
                }
                --n;
            }
        }
        if (superImport && (bshClassManager = BshClassManager.getClassManager()) != null && (string2 = bshClassManager.getClassNameByUnqName(string)) != null) {
            return this.classForName(string2);
        }
        return null;
    }

    private final Class classForName(String string) {
        return BshClassManager.classForName(string);
    }

    public String[] getAllNames() {
        Vector vector = new Vector();
        this.getAllNamesAux(vector);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected void getAllNamesAux(Vector vector) {
        Enumeration enumeration = this.variables.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Enumeration enumeration2 = this.methods.keys();
        while (enumeration2.hasMoreElements()) {
            vector.addElement(enumeration2.nextElement());
        }
        if (this.parent != null) {
            this.parent.getAllNamesAux(vector);
        }
    }

    public void addNameSourceListener(NameSource.Listener listener) {
        if (this.nameSourceListeners == null) {
            this.nameSourceListeners = new Vector();
        }
        this.nameSourceListeners.addElement(listener);
    }

    public static void doSuperImport() throws EvalError {
        BshClassManager bshClassManager = BshClassManager.getClassManager();
        if (bshClassManager != null) {
            bshClassManager.doSuperImport();
        }
        superImport = true;
    }

    public static Object checkAssignableFrom(Object object, Class clazz) throws EvalError {
        return NameSpace.getAssignableForm(object, clazz);
    }

    public static Object getAssignableForm(Object object, Class clazz) throws EvalError {
        Class clazz2;
        Class<Boolean> clazz3;
        if (clazz == null) {
            throw new InterpreterError("Null value for type in getAssignableForm");
        }
        if (object == null) {
            throw new InterpreterError("Null value in getAssignableForm.");
        }
        if (object == Primitive.VOID) {
            throw new EvalError("Undefined variable or class name");
        }
        if (object == Primitive.NULL) {
            if (!clazz.isPrimitive()) {
                return object;
            }
            throw new EvalError("Can't assign null to primitive type " + clazz.getName());
        }
        if (object instanceof Primitive) {
            clazz3 = ((Primitive)object).getType();
            clazz2 = clazz3;
            if (!clazz.isPrimitive()) {
                if ((class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = NameSpace.class$("java.lang.Boolean"))).isAssignableFrom(clazz) || (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = NameSpace.class$("java.lang.Character"))).isAssignableFrom(clazz) || (class$Ljava$lang$Number != null ? class$Ljava$lang$Number : (class$Ljava$lang$Number = NameSpace.class$("java.lang.Number"))).isAssignableFrom(clazz)) {
                    object = ((Primitive)object).getValue();
                    clazz2 = object.getClass();
                } else {
                    NameSpace.assignmentError(clazz, clazz3);
                }
            }
        } else {
            clazz3 = object.getClass();
            clazz2 = clazz3;
            if (clazz.isPrimitive()) {
                if (clazz2 == (class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = NameSpace.class$("java.lang.Boolean")))) {
                    object = new Primitive((Boolean)object);
                    clazz2 = Boolean.TYPE;
                } else if (clazz2 == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = NameSpace.class$("java.lang.Character")))) {
                    object = new Primitive((Character)object);
                    clazz2 = Character.TYPE;
                } else if ((class$Ljava$lang$Number != null ? class$Ljava$lang$Number : (class$Ljava$lang$Number = NameSpace.class$("java.lang.Number"))).isAssignableFrom(clazz2)) {
                    object = new Primitive((Number)object);
                    clazz2 = ((Primitive)object).getType();
                } else {
                    NameSpace.assignmentError(clazz, clazz3);
                }
            }
        }
        if (Reflect.isAssignableFrom(clazz, clazz2)) {
            return object;
        }
        if (clazz == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = NameSpace.class$("java.lang.Short"))) && clazz2 == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = NameSpace.class$("java.lang.Byte")))) {
            return new Short(((Number)object).shortValue());
        }
        if (clazz == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = NameSpace.class$("java.lang.Integer")))) {
            if (clazz2 == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = NameSpace.class$("java.lang.Byte"))) || clazz2 == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = NameSpace.class$("java.lang.Short")))) {
                return new Integer(((Number)object).intValue());
            }
            if (clazz2 == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = NameSpace.class$("java.lang.Character")))) {
                return new Integer(((Number)object).intValue());
            }
        }
        if (clazz == (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = NameSpace.class$("java.lang.Long")))) {
            if (clazz2 == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = NameSpace.class$("java.lang.Byte"))) || clazz2 == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = NameSpace.class$("java.lang.Short"))) || clazz2 == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = NameSpace.class$("java.lang.Integer")))) {
                return new Long(((Number)object).longValue());
            }
            if (clazz2 == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = NameSpace.class$("java.lang.Character")))) {
                return new Long(((Number)object).longValue());
            }
        }
        if (clazz == (class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = NameSpace.class$("java.lang.Float")))) {
            if (clazz2 == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = NameSpace.class$("java.lang.Byte"))) || clazz2 == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = NameSpace.class$("java.lang.Short"))) || clazz2 == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = NameSpace.class$("java.lang.Integer"))) || clazz2 == (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = NameSpace.class$("java.lang.Long")))) {
                return new Float(((Number)object).floatValue());
            }
            if (clazz2 == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = NameSpace.class$("java.lang.Character")))) {
                return new Float(((Number)object).floatValue());
            }
        }
        if (clazz == (class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = NameSpace.class$("java.lang.Double")))) {
            if (clazz2 == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = NameSpace.class$("java.lang.Byte"))) || clazz2 == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = NameSpace.class$("java.lang.Short"))) || clazz2 == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = NameSpace.class$("java.lang.Integer"))) || clazz2 == (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = NameSpace.class$("java.lang.Long"))) || clazz2 == (class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = NameSpace.class$("java.lang.Float")))) {
                return new Double(((Number)object).doubleValue());
            }
            if (clazz2 == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = NameSpace.class$("java.lang.Character")))) {
                return new Double(((Number)object).doubleValue());
            }
        }
        if (Capabilities.canGenerateInterfaces() && clazz.isInterface() && object instanceof This) {
            return ((This)object).getInterface(clazz);
        }
        NameSpace.assignmentError(clazz, clazz3);
        return object;
    }

    private static final void assignmentError(Class clazz, Class clazz2) throws EvalError {
        String string = Reflect.normalizeClassName(clazz);
        String string2 = Reflect.normalizeClassName(clazz2);
        throw new EvalError("Can't assign " + string2 + " to " + string);
    }

    public String toString() {
        return "NameSpace: " + (this.name == null ? super.toString() : this.name + " (" + super.toString() + ")");
    }

    private final synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public Object invokeMethod(String string, Object[] objectArray, Interpreter interpreter) throws EvalError {
        return this.invokeMethod(string, objectArray, interpreter, null, null);
    }

    public Object invokeMethod(String string, Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws EvalError {
        BshMethod bshMethod;
        if (callStack == null) {
            callStack = new CallStack();
            callStack.push(this);
        }
        if ((bshMethod = this.getMethod(string, Reflect.getTypes(objectArray))) != null) {
            return bshMethod.invokeDeclaredMethod(objectArray, interpreter, callStack, simpleNode);
        }
        bshMethod = this.getMethod("invoke", new Class[]{null, null});
        if (bshMethod != null) {
            return bshMethod.invokeDeclaredMethod(new Object[]{string, objectArray}, interpreter, callStack, simpleNode);
        }
        throw new EvalError("No locally declared method: " + string + " in namespace: " + this);
    }

    public void classLoaderChanged() {
        this.nameSpaceChanged();
    }

    public void nameSpaceChanged() {
        this.classCache = null;
    }

    public void loadDefaultImports() {
        this.importClass("bsh.EvalError");
        this.importPackage("javax.swing.event");
        this.importPackage("javax.swing");
        this.importPackage("java.awt.event");
        this.importPackage("java.awt");
        this.importPackage("java.net");
        this.importPackage("java.util");
        this.importPackage("java.io");
        this.importPackage("java.lang");
    }

    Name getNameResolver(String string) {
        return new Name(this, string);
    }

    public int getInvocationLine() {
        SimpleNode simpleNode = this.getNode();
        if (simpleNode != null) {
            return simpleNode.getLineNumber();
        }
        return -1;
    }

    public String getInvocationText() {
        SimpleNode simpleNode = this.getNode();
        if (simpleNode != null) {
            return simpleNode.getText();
        }
        return "<invoked from Java code>";
    }

    public static Class identifierToClass(Name.ClassIdentifier classIdentifier) {
        return classIdentifier.getTargetClass();
    }

    public void clear() {
        this.variables = null;
        this.methods = null;
        this.importedClasses = null;
        this.importedPackages = null;
        superImport = false;
        if (this.parent == null) {
            this.loadDefaultImports();
        }
        this.classCache = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public NameSpace(String string) {
        this(null, string);
    }

    public NameSpace(NameSpace nameSpace, String string) {
        this.setName(string);
        this.setParent(nameSpace);
        BshClassManager.addCMListener(this);
    }

    static class TypedVariable
    implements Serializable {
        Class type;
        Object value = null;
        boolean isFinal;

        void setValue(Object object) throws EvalError {
            if (this.isFinal && this.value != null) {
                throw new EvalError("Final variable, can't assign");
            }
            if ((object = NameSpace.getAssignableForm(object, this.type)) instanceof Primitive && ((Primitive)object).isNumber()) {
                try {
                    object = BSHCastExpression.castPrimitive((Primitive)object, this.type);
                }
                catch (EvalError evalError) {
                    throw new InterpreterError("auto assignment cast failed");
                }
            }
            this.value = object;
        }

        Object getValue() {
            return this.value;
        }

        Class getType() {
            return this.type;
        }

        public String toString() {
            return "TypedVariable: " + this.type + ", value:" + this.value;
        }

        TypedVariable(Class clazz, Object object, boolean bl) throws EvalError {
            this.type = clazz;
            if (clazz == null) {
                throw new InterpreterError("null type in typed var: " + object);
            }
            this.isFinal = bl;
            this.setValue(object);
        }
    }
}

