/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb;

import java.time.Duration;
import kotlin.Metadata;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb.EcnMarking;
import org.jitsi.utils.DurationKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"kHeaderPerMediaSsrcLength", "", "kTimestampLength", "to13BitAto", "arrivalTimeOffset", "Ljava/time/Duration;", "atoToTimeDelta", "receiveInfo", "toEcnMarking", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/ccfb/EcnMarking;", "to2BitEcn", "ecnMarking", "rtp"})
public final class RtcpFbCcfbPacketKt {
    private static final int kHeaderPerMediaSsrcLength = 8;
    private static final int kTimestampLength = 4;

    private static final int to13BitAto(Duration arrivalTimeOffset) {
        if (arrivalTimeOffset.isNegative()) {
            return 8191;
        }
        return Math.min((int)((double)1024 * DurationKt.toDouble(arrivalTimeOffset)), 8190);
    }

    private static final Duration atoToTimeDelta(int receiveInfo) {
        int ato = receiveInfo & 0x1FFF;
        if (ato == 8190) {
            return DurationKt.getMAX_DURATION();
        }
        if (ato == 8191) {
            return DurationKt.getMIN_DURATION();
        }
        return DurationKt.div(DurationKt.getSecs(ato), 1024L);
    }

    private static final EcnMarking toEcnMarking(int receiveInfo) {
        return EcnMarking.Companion.fromBits((byte)(receiveInfo >> 13 & 3));
    }

    private static final int to2BitEcn(EcnMarking ecnMarking) {
        return ecnMarking.getBits() << 13;
    }

    public static final /* synthetic */ int access$to2BitEcn(EcnMarking ecnMarking) {
        return RtcpFbCcfbPacketKt.to2BitEcn(ecnMarking);
    }

    public static final /* synthetic */ int access$to13BitAto(Duration arrivalTimeOffset) {
        return RtcpFbCcfbPacketKt.to13BitAto(arrivalTimeOffset);
    }

    public static final /* synthetic */ Duration access$atoToTimeDelta(int receiveInfo) {
        return RtcpFbCcfbPacketKt.atoToTimeDelta(receiveInfo);
    }

    public static final /* synthetic */ EcnMarking access$toEcnMarking(int receiveInfo) {
        return RtcpFbCcfbPacketKt.toEcnMarking(receiveInfo);
    }
}

