/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.time.Clock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.utils.queue.CountingErrorHandler;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.videobridge.metrics.QueueMetrics;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.xmpp.XmppConnection;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/ColibriQueue;", "Lorg/jitsi/utils/queue/PacketQueue;", "Lorg/jitsi/videobridge/xmpp/XmppConnection$ColibriRequest;", "packetHandler", "Lorg/jitsi/utils/queue/PacketQueue$PacketHandler;", "<init>", "(Lorg/jitsi/utils/queue/PacketQueue$PacketHandler;)V", "Companion", "jitsi-videobridge"})
public abstract class ColibriQueue
extends PacketQueue<XmppConnection.ColibriRequest> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String QUEUE_NAME = "colibri-queue";
    @NotNull
    private static final CounterMetric droppedPacketsMetric = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "colibri_queue_dropped_packets", "Number of packets dropped out of the Colibri queue.", 0L, null, 12, null);
    @NotNull
    private static final CounterMetric exceptionsMetric = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "colibri_queue_exceptions", "Number of exceptions from the Colibri queue.", 0L, null, 12, null);
    @NotNull
    private static final CountingErrorHandler queueErrorCounter = new CountingErrorHandler(){

        public void packetDropped() {
            Unit unit;
            super.packetDropped();
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            CounterMetric.inc$default(ColibriQueue.Companion.getDroppedPacketsMetric(), null, 1, null);
            CounterMetric.inc$default(QueueMetrics.INSTANCE.getDroppedPackets(), null, 1, null);
        }

        public void packetHandlingFailed(Throwable t2) {
            Unit unit;
            super.packetHandlingFailed(t2);
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            CounterMetric.inc$default(ColibriQueue.Companion.getExceptionsMetric(), null, 1, null);
            CounterMetric.inc$default(QueueMetrics.INSTANCE.getExceptions(), null, 1, null);
        }
    };

    public ColibriQueue(@NotNull PacketQueue.PacketHandler<XmppConnection.ColibriRequest> packetHandler) {
        Intrinsics.checkNotNullParameter(packetHandler, "packetHandler");
        super(Integer.MAX_VALUE, true, QUEUE_NAME, packetHandler, TaskPools.IO_POOL, Clock.systemUTC(), false);
        this.setErrorHandler(queueErrorCounter);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/videobridge/ColibriQueue$Companion;", "", "<init>", "()V", "QUEUE_NAME", "", "getQUEUE_NAME", "()Ljava/lang/String;", "droppedPacketsMetric", "Lorg/jitsi/metrics/CounterMetric;", "getDroppedPacketsMetric", "()Lorg/jitsi/metrics/CounterMetric;", "exceptionsMetric", "getExceptionsMetric", "queueErrorCounter", "Lorg/jitsi/utils/queue/CountingErrorHandler;", "getQueueErrorCounter", "()Lorg/jitsi/utils/queue/CountingErrorHandler;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getQUEUE_NAME() {
            return QUEUE_NAME;
        }

        @NotNull
        public final CounterMetric getDroppedPacketsMetric() {
            return droppedPacketsMetric;
        }

        @NotNull
        public final CounterMetric getExceptionsMetric() {
            return exceptionsMetric;
        }

        @NotNull
        public final CountingErrorHandler getQueueErrorCounter() {
            return queueErrorCounter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

