/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.av1;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacket;
import org.jitsi.nlj.util.ArrayCache;
import org.jitsi.nlj.util.RtpSequenceIndexTracker;
import org.jitsi.videobridge.cc.av1.Av1DDFrame;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0018\u001a\u00020\u0004H\u0086\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\fJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0002H\u0014J$\u0010&\u001a\u0004\u0018\u00010\u00022\u0006\u0010 \u001a\u00020\u00022\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001f0(J$\u0010)\u001a\u0004\u0018\u00010\u00022\u0006\u0010 \u001a\u00020\u00022\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001f0(J6\u0010*\u001a\u0004\u0018\u00010\u00022\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001f0(2\u0006\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u0004H\u0002R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0006R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006."}, d2={"Lorg/jitsi/videobridge/cc/av1/FrameHistory;", "Lorg/jitsi/nlj/util/ArrayCache;", "Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;", "size", "", "<init>", "(I)V", "numCached", "getNumCached", "()I", "setNumCached", "firstIndex", "", "getFirstIndex", "()J", "setFirstIndex", "(J)V", "indexTracker", "Lorg/jitsi/nlj/util/RtpSequenceIndexTracker;", "getIndexTracker", "()Lorg/jitsi/nlj/util/RtpSequenceIndexTracker;", "setIndexTracker", "(Lorg/jitsi/nlj/util/RtpSequenceIndexTracker;)V", "get", "frameNumber", "getIndex", "index", "latestFrame", "getLatestFrame", "()Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;", "insert", "", "frame", "packet", "Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;", "discardItem", "", "item", "findBefore", "pred", "Lkotlin/Function1;", "findAfter", "doFind", "startIndex", "endIndex", "increment", "jitsi-videobridge"})
public final class FrameHistory
extends ArrayCache<Av1DDFrame> {
    private int numCached;
    private long firstIndex = -1L;
    @NotNull
    private RtpSequenceIndexTracker indexTracker = new RtpSequenceIndexTracker();

    public FrameHistory(int size) {
        super(size, FrameHistory::_init_$lambda$0, false, null, 8, null);
    }

    public final int getNumCached() {
        return this.numCached;
    }

    public final void setNumCached(int n) {
        this.numCached = n;
    }

    public final long getFirstIndex() {
        return this.firstIndex;
    }

    public final void setFirstIndex(long l) {
        this.firstIndex = l;
    }

    @NotNull
    public final RtpSequenceIndexTracker getIndexTracker() {
        return this.indexTracker;
    }

    public final void setIndexTracker(@NotNull RtpSequenceIndexTracker rtpSequenceIndexTracker) {
        Intrinsics.checkNotNullParameter(rtpSequenceIndexTracker, "<set-?>");
        this.indexTracker = rtpSequenceIndexTracker;
    }

    @Nullable
    public final Av1DDFrame get(int frameNumber) {
        long index = this.indexTracker.interpret(frameNumber);
        return this.getIndex(index);
    }

    @Nullable
    public final Av1DDFrame getIndex(long index) {
        if (index <= this.getLastIndex() - (long)this.getSize()) {
            return null;
        }
        ArrayCache.Container container = ArrayCache.getContainer$default(this, index, false, 2, null);
        if (container == null) {
            return null;
        }
        ArrayCache.Container c = container;
        return (Av1DDFrame)c.getItem();
    }

    @Nullable
    public final Av1DDFrame getLatestFrame() {
        return this.getIndex(this.getLastIndex());
    }

    public final boolean insert(@NotNull Av1DDFrame frame) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        boolean ret = super.insertItem(frame, frame.getIndex());
        if (ret) {
            int n = this.numCached;
            this.numCached = n + 1;
            if (this.firstIndex == -1L || frame.getIndex() < this.firstIndex) {
                this.firstIndex = frame.getIndex();
            }
        }
        return ret;
    }

    @Nullable
    public final Av1DDFrame insert(@NotNull Av1DDPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        long index = this.indexTracker.update(packet.getFrameNumber());
        Av1DDFrame frame = new Av1DDFrame(packet, index);
        return this.insert(frame) ? frame : null;
    }

    @Override
    protected void discardItem(@NotNull Av1DDFrame item) {
        Intrinsics.checkNotNullParameter(item, "item");
        int n = this.numCached;
        this.numCached = n + -1;
    }

    @Nullable
    public final Av1DDFrame findBefore(@NotNull Av1DDFrame frame, @NotNull Function1<? super Av1DDFrame, Boolean> pred) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(pred, "pred");
        long lastIndex = this.getLastIndex();
        if (lastIndex == -1L) {
            return null;
        }
        long index = frame.getIndex();
        long searchStartIndex = Math.min(index - 1L, lastIndex);
        long searchEndIndex = Math.max(lastIndex - (long)this.getSize(), this.firstIndex - 1L);
        return this.doFind(pred, searchStartIndex, searchEndIndex, -1);
    }

    @Nullable
    public final Av1DDFrame findAfter(@NotNull Av1DDFrame frame, @NotNull Function1<? super Av1DDFrame, Boolean> pred) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(pred, "pred");
        long lastIndex = this.getLastIndex();
        if (lastIndex == -1L) {
            return null;
        }
        long index = frame.getIndex();
        if (index >= lastIndex) {
            return null;
        }
        long searchStartIndex = Math.max(index + 1L, Math.max(lastIndex - (long)this.getSize() + 1L, this.firstIndex));
        return this.doFind(pred, searchStartIndex, lastIndex + 1L, 1);
    }

    private final Av1DDFrame doFind(Function1<? super Av1DDFrame, Boolean> pred, long startIndex, long endIndex, int increment) {
        if (!(increment > 0 && startIndex <= endIndex || increment < 0 && startIndex >= endIndex)) {
            boolean bl = false;
            String string = "Values of startIndex=" + startIndex + ", endIndex=" + endIndex + ", and increment=" + increment + " could lead to infinite loop";
            throw new IllegalArgumentException(string.toString());
        }
        for (long index = startIndex; index != endIndex; index += (long)increment) {
            Av1DDFrame frame = this.getIndex(index);
            if (frame == null || !pred.invoke(frame).booleanValue()) continue;
            return frame;
        }
        return null;
    }

    private static final Av1DDFrame _init_$lambda$0(Av1DDFrame k) {
        Intrinsics.checkNotNullParameter(k, "k");
        return k;
    }
}

