/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.load_management;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.stats.TransceiverStats;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.load_management.PacketRateMeasurement;
import org.jitsi.videobridge.relay.Relay;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jitsi/videobridge/load_management/PacketRateLoadSampler;", "Ljava/lang/Runnable;", "videobridge", "Lorg/jitsi/videobridge/Videobridge;", "newMeasurementHandler", "Lkotlin/Function1;", "Lorg/jitsi/videobridge/load_management/PacketRateMeasurement;", "", "<init>", "(Lorg/jitsi/videobridge/Videobridge;Lkotlin/jvm/functions/Function1;)V", "run", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nPacketRateLoadSampler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PacketRateLoadSampler.kt\norg/jitsi/videobridge/load_management/PacketRateLoadSampler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1855#2:44\n1855#2,2:45\n1855#2,2:47\n1856#2:49\n*S KotlinDebug\n*F\n+ 1 PacketRateLoadSampler.kt\norg/jitsi/videobridge/load_management/PacketRateLoadSampler\n*L\n28#1:44\n29#1:45,2\n35#1:47,2\n28#1:49\n*E\n"})
public final class PacketRateLoadSampler
implements Runnable {
    @NotNull
    private final Videobridge videobridge;
    @NotNull
    private final Function1<PacketRateMeasurement, Unit> newMeasurementHandler;

    public PacketRateLoadSampler(@NotNull Videobridge videobridge, @NotNull Function1<? super PacketRateMeasurement, Unit> newMeasurementHandler) {
        Intrinsics.checkNotNullParameter(videobridge, "videobridge");
        Intrinsics.checkNotNullParameter(newMeasurementHandler, "newMeasurementHandler");
        this.videobridge = videobridge;
        this.newMeasurementHandler = newMeasurementHandler;
    }

    @Override
    public void run() {
        long totalPacketRate = 0L;
        Collection<Conference> collection = this.videobridge.getConferences();
        Intrinsics.checkNotNullExpressionValue(collection, "getConferences(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Conference conf = (Conference)element$iv;
            boolean bl = false;
            List<Endpoint> list = conf.getLocalEndpoints();
            Intrinsics.checkNotNullExpressionValue(list, "getLocalEndpoints(...)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Endpoint ep = (Endpoint)element$iv2;
                boolean bl2 = false;
                TransceiverStats $this$run_u24lambda_u243_u24lambda_u241_u24lambda_u240 = ep.getTransceiver().getTransceiverStats();
                boolean bl3 = false;
                totalPacketRate += $this$run_u24lambda_u243_u24lambda_u241_u24lambda_u240.getRtpReceiverStats().getPacketStreamStats().getPacketRate();
                totalPacketRate += $this$run_u24lambda_u243_u24lambda_u241_u24lambda_u240.getOutgoingPacketStreamStats().getPacketRate();
            }
            List<Relay> list2 = conf.getRelays();
            Intrinsics.checkNotNullExpressionValue(list2, "getRelays(...)");
            $this$forEach$iv2 = list2;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Relay relay = (Relay)element$iv2;
                boolean bl4 = false;
                totalPacketRate += relay.getIncomingPacketRate();
                totalPacketRate += relay.getOutgoingPacketRate();
            }
        }
        this.newMeasurementHandler.invoke(new PacketRateMeasurement(totalPacketRate));
    }
}

