/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.internals.StateStoreProvider;

public class GlobalStateStoreProvider
implements StateStoreProvider {
    private final Map<String, StateStore> globalStateStores;

    public GlobalStateStoreProvider(Map<String, StateStore> globalStateStores) {
        this.globalStateStores = globalStateStores;
    }

    @Override
    public <T> List<T> stores(String storeName, QueryableStoreType<T> queryableStoreType) {
        StateStore store = this.globalStateStores.get(storeName);
        if (store == null || !queryableStoreType.accepts(store)) {
            return Collections.emptyList();
        }
        if (!store.isOpen()) {
            throw new InvalidStateStoreException("the state store, " + storeName + ", is not open.");
        }
        return Collections.singletonList(store);
    }
}

