#!/bin/sh

# Copyright (C) 2020-2025 Internet Systems Consortium, Inc. ("ISC")
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# Exit with error if commands exit with non-zero and if undefined variables are
# used.
set -eu

# shellcheck disable=SC2034
# SC2034: ... appears unused. Verify use (or export if used externally).
prefix="/usr/pkg"

# Include utilities based on location of this script. Check for sources first,
# so that the unexpected situations with weird paths fall on the default
# case of installed.
script_path=$(cd "$(dirname "${0}")" && pwd)
if test "${script_path}" = "XXX-tests-builddir-XXX/src/share/database/scripts/mysql"; then
    # shellcheck source=./src/bin/admin/admin-utils.sh.in
    . "XXX-tests-builddir-XXX/src/bin/admin/admin-utils.sh"
else
    # shellcheck source=./src/bin/admin/admin-utils.sh.in
    . "${prefix}/share/kea/scripts/admin-utils.sh"
fi

VERSION=$(mysql_version "$@")

if [ "$VERSION" != "9.0" ]; then
    printf 'This script upgrades 9.0 to 9.1. '
    printf 'Reported version is %s. Skipping upgrade.\n' "${VERSION}"
    exit 0
fi

mysql "$@" <<EOF
-- This line starts the schema upgrade to version 9.1.

# Add new DDNS related columns to shared networks and subnets
ALTER TABLE dhcp4_shared_network
    ADD COLUMN ddns_send_updates TINYINT(1) DEFAULT NULL,
    ADD COLUMN ddns_override_no_update TINYINT(1) DEFAULT NULL,
    ADD COLUMN ddns_override_client_update TINYINT(1) DEFAULT NULL,
    ADD COLUMN ddns_replace_client_name TINYINT(3) DEFAULT NULL,
    ADD COLUMN ddns_generated_prefix VARCHAR(255) DEFAULT NULL,
    ADD COLUMN ddns_qualifying_suffix VARCHAR(255) DEFAULT NULL;

ALTER TABLE dhcp6_shared_network
    ADD COLUMN ddns_send_updates TINYINT(1) DEFAULT NULL,
    ADD COLUMN ddns_override_no_update TINYINT(1) DEFAULT NULL,
    ADD COLUMN ddns_override_client_update TINYINT(1) DEFAULT NULL,
    ADD COLUMN ddns_replace_client_name TINYINT(3) DEFAULT NULL,
    ADD COLUMN ddns_generated_prefix VARCHAR(255) DEFAULT NULL,
    ADD COLUMN ddns_qualifying_suffix VARCHAR(255) DEFAULT NULL;

ALTER TABLE dhcp4_subnet
    ADD COLUMN ddns_send_updates TINYINT(1) DEFAULT NULL,
    ADD COLUMN ddns_override_no_update TINYINT(1) DEFAULT NULL,
    ADD COLUMN ddns_override_client_update TINYINT(1) DEFAULT NULL,
    ADD COLUMN ddns_replace_client_name TINYINT(3) DEFAULT NULL,
    ADD COLUMN ddns_generated_prefix VARCHAR(255) DEFAULT NULL,
    ADD COLUMN ddns_qualifying_suffix VARCHAR(255) DEFAULT NULL;

ALTER TABLE dhcp6_subnet
    ADD COLUMN ddns_send_updates TINYINT(1) DEFAULT NULL,
    ADD COLUMN ddns_override_no_update TINYINT(1) DEFAULT NULL,
    ADD COLUMN ddns_override_client_update TINYINT(1) DEFAULT NULL,
    ADD COLUMN ddns_replace_client_name TINYINT(3) DEFAULT NULL,
    ADD COLUMN ddns_generated_prefix VARCHAR(255) DEFAULT NULL,
    ADD COLUMN ddns_qualifying_suffix VARCHAR(255) DEFAULT NULL;

# Update the schema version number.
UPDATE schema_version
    SET version = '9', minor = '1';

# This line concludes the schema upgrade to version 9.1.

EOF
