#---------------------------------------------------------------
# The configuration options
#---------------------------------------------------------------

set foreground [option get . "foreground" "Foreground"]
set background [option get . "background" "Background"]
set activebackground [option get . "activeBackground" ""]
set activeforeground [option get . "activeForeground" ""]
#set backgroundhome "$background"
set backgroundhome "mistyrose3"

if {"$foreground" == "" || "$background" == ""} {
    set foreground "Black"
    set background "Mistyrose"
    set activeforeground "Black"
    set activebackground "Mistyrose2"
    option add "*Foreground" $foreground
    option add "*Background" $background
    option add "*activeForeground" $activeforeground
    option add "*activeBackground" $activebackground
    ;# need to do this explicitly because the root window already exists
    . configure -background $background
}
if {"$activebackground" == ""} {
    set activebackground $background
    option add "*activeBackground" $activebackground
}
if {"$activeforeground" == ""} {
    set activeforeground $foreground
    option add "*activeForeground" $activeforeground
}

option add "*activeBorderWidth" 2

# need to be a little darker than background to make scrollbars look right
option add "*Scrollbar.troughColor" "mistyrose3"
option add "*Scrollbar.Width" 12
option add "*Scrollbar.borderWidth" 2
option add "*Scrollbar.relief" "sunken"
option add "*Scrollbar.takeFocus" 0

# to have the indicator drawn properly
option add "*Menu.selectColor" $foreground

set filen ""
set physicalkeyboard "Qwerty"

#---------------------------------------------------------------
# Procedure: usage
#  Print out list of command line arguments.
#---------------------------------------------------------------
proc usage {} {
    global argv0
    puts "usage: $argv0 \[-dvorak] \[-qwerty] \[filename]"
}

while {$argc > 0} {
    if {[string compare [lindex "$argv" 0] "-dvorak"] == 0} {
	set physicalkeyboard "Dvorak"
	incr argc -1
	set argv [lrange "$argv" 1 end]
    } elseif {[string compare [lindex "$argv" 0] "-qwerty"] == 0} {
	set physicalkeyboard "Qwerty"
	incr argc -1
	set argv [lrange "$argv" 1 end]
    } elseif {[string compare [lindex "$argv" 0] "-help"] == 0} {
	usage
	exit 0
    } elseif {$argc == 1} {
	if [file isfile "$argv"] {
	    set filen "$argv"
	    incr argc -1
	    set argv [lrange "$argv" 1 end]
	} else {
	    usage
	    exit 1
	}
    } else {
	usage
	exit 1
    }
}

proc loadfilename {} {
    global filen
    return $filen
}

# set tk_strictMotif 1
