/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.configuration;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.Configuration;
import org.opensolaris.opengrok.configuration.Project;
import org.opensolaris.opengrok.history.HistoryGuru;
import org.opensolaris.opengrok.history.RepositoryInfo;
import org.opensolaris.opengrok.index.Filter;
import org.opensolaris.opengrok.index.IgnoredNames;
import org.opensolaris.opengrok.util.Executor;
import org.opensolaris.opengrok.util.IOUtils;

public final class RuntimeEnvironment {
    private Configuration configuration = new Configuration();
    private final ThreadLocal<Configuration> threadConfig = new ThreadLocal<Configuration>(){

        @Override
        protected Configuration initialValue() {
            return RuntimeEnvironment.this.configuration;
        }
    };
    private static final Logger log = Logger.getLogger(RuntimeEnvironment.class.getName());
    private static RuntimeEnvironment instance = new RuntimeEnvironment();
    private static ExecutorService historyExecutor = null;
    private static ExecutorService historyRenamedExecutor = null;
    private static boolean RenamedEnabled = false;
    private ServerSocket configServerSocket;

    public static synchronized ExecutorService getHistoryExecutor() {
        if (historyExecutor == null) {
            int num = Runtime.getRuntime().availableProcessors();
            String total = System.getProperty("org.opensolaris.opengrok.history.NumCacheThreads");
            if (total != null) {
                try {
                    num = Integer.valueOf(total);
                }
                catch (Throwable t) {
                    log.log(Level.WARNING, "Failed to parse the number of cache threads to use for cache creation", t);
                }
            }
            historyExecutor = Executors.newFixedThreadPool(num, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                    thread.setName("history-handling-" + thread.getId());
                    return thread;
                }
            });
        }
        return historyExecutor;
    }

    public static synchronized ExecutorService getHistoryRenamedExecutor() {
        if (historyRenamedExecutor == null) {
            int num = Runtime.getRuntime().availableProcessors();
            String total = System.getProperty("org.opensolaris.opengrok.history.NumCacheRenamedThreads");
            if (total != null) {
                try {
                    num = Integer.valueOf(total);
                }
                catch (Throwable t) {
                    log.log(Level.WARNING, "Failed to parse the number of cache threads to use for cache creation of renamed files", t);
                }
            }
            historyRenamedExecutor = Executors.newFixedThreadPool(num, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                    thread.setName("renamed-handling-" + thread.getId());
                    return thread;
                }
            });
        }
        return historyRenamedExecutor;
    }

    public static synchronized void freeHistoryExecutor() {
        historyExecutor = null;
    }

    public static synchronized void destroyRenamedHistoryExecutor() throws InterruptedException {
        if (historyRenamedExecutor != null) {
            historyRenamedExecutor.shutdown();
            historyRenamedExecutor.awaitTermination(1L, TimeUnit.MINUTES);
            historyRenamedExecutor = null;
        }
    }

    public static boolean isRenamedFilesEnabled() {
        String enabled = System.getProperty("org.opensolaris.opengrok.history.RenamedHandlingEnabled");
        if (enabled != null) {
            RenamedEnabled = true;
        }
        return RenamedEnabled;
    }

    public static RuntimeEnvironment getInstance() {
        return instance;
    }

    private RuntimeEnvironment() {
    }

    private String getCanonicalPath(String s) {
        try {
            File file = new File(s);
            if (!file.exists()) {
                return s;
            }
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to get canonical path", ex);
            return s;
        }
    }

    public int getScanningDepth() {
        return this.threadConfig.get().getScanningDepth();
    }

    public void setScanningDepth(int scanningDepth) {
        this.threadConfig.get().setScanningDepth(scanningDepth);
    }

    public int getCommandTimeout() {
        return this.threadConfig.get().getCommandTimeout();
    }

    public void setCommandTimeout(int timeout) {
        this.threadConfig.get().setCommandTimeout(timeout);
    }

    public String getDataRootPath() {
        return this.threadConfig.get().getDataRoot();
    }

    public File getDataRootFile() {
        File ret = null;
        String file = this.getDataRootPath();
        if (file != null) {
            ret = new File(file);
        }
        return ret;
    }

    public void setDataRoot(String dataRoot) {
        this.threadConfig.get().setDataRoot(this.getCanonicalPath(dataRoot));
    }

    public String getSourceRootPath() {
        return this.configuration.getSourceRoot();
    }

    public File getSourceRootFile() {
        File ret = null;
        String file = this.getSourceRootPath();
        if (file != null) {
            ret = new File(file);
        }
        return ret;
    }

    public void setSourceRoot(String sourceRoot) {
        this.configuration.setSourceRoot(this.getCanonicalPath(sourceRoot));
    }

    public String getPathRelativeToSourceRoot(File file, int stripCount) throws IOException {
        String sourceRoot;
        String canonicalPath = file.getCanonicalPath();
        if (canonicalPath.startsWith(sourceRoot = this.getSourceRootPath())) {
            return canonicalPath.substring(sourceRoot.length() + stripCount);
        }
        for (String allowedSymlink : this.getAllowedSymlinks()) {
            String allowedTarget = new File(allowedSymlink).getCanonicalPath();
            if (!canonicalPath.startsWith(allowedTarget)) continue;
            return canonicalPath.substring(allowedTarget.length() + stripCount);
        }
        throw new FileNotFoundException("Failed to resolve [" + canonicalPath + "] relative to source root [" + sourceRoot + "]");
    }

    public boolean hasProjects() {
        List<Project> proj = this.getProjects();
        return proj != null && !proj.isEmpty();
    }

    public List<Project> getProjects() {
        return this.threadConfig.get().getProjects();
    }

    public void setProjects(List<Project> projects) {
        this.threadConfig.get().setProjects(projects);
    }

    public RuntimeEnvironment register() {
        this.threadConfig.set(this.configuration);
        return this;
    }

    public String getUrlPrefix() {
        return this.threadConfig.get().getUrlPrefix();
    }

    public void setUrlPrefix(String urlPrefix) {
        this.threadConfig.get().setUrlPrefix(urlPrefix);
    }

    public String getCtags() {
        return this.threadConfig.get().getCtags();
    }

    public void setCtags(String ctags) {
        this.threadConfig.get().setCtags(ctags);
    }

    public int getCachePages() {
        return this.threadConfig.get().getCachePages();
    }

    public void setCachePages(int cachePages) {
        this.threadConfig.get().setCachePages(cachePages);
    }

    public int getHitsPerPage() {
        return this.threadConfig.get().getHitsPerPage();
    }

    public void setHitsPerPage(int hitsPerPage) {
        this.threadConfig.get().setHitsPerPage(hitsPerPage);
    }

    public boolean validateExuberantCtags() {
        boolean ret = true;
        Executor executor = new Executor(new String[]{this.getCtags(), "--version"});
        executor.exec(false);
        String output = executor.getOutputString();
        if (output == null || output.indexOf("Exuberant Ctags") == -1) {
            log.log(Level.SEVERE, "Error: No Exuberant Ctags found in PATH !\n(tried running {0})\nPlease use option -c to specify path to a good Exuberant Ctags program.\nOr set it in java property org.opensolaris.opengrok.analysis.Ctags", this.getCtags());
            ret = false;
        }
        return ret;
    }

    public int getHistoryReaderTimeLimit() {
        return this.threadConfig.get().getHistoryCacheTime();
    }

    public void setHistoryReaderTimeLimit(int historyReaderTimeLimit) {
        this.threadConfig.get().setHistoryCacheTime(historyReaderTimeLimit);
    }

    public boolean useHistoryCache() {
        return this.threadConfig.get().isHistoryCache();
    }

    public void setUseHistoryCache(boolean useHistoryCache) {
        this.threadConfig.get().setHistoryCache(useHistoryCache);
    }

    public boolean storeHistoryCacheInDB() {
        return this.threadConfig.get().isHistoryCacheInDB();
    }

    public void setStoreHistoryCacheInDB(boolean store) {
        this.threadConfig.get().setHistoryCacheInDB(store);
    }

    public boolean isGenerateHtml() {
        return this.threadConfig.get().isGenerateHtml();
    }

    public void setGenerateHtml(boolean generateHtml) {
        this.threadConfig.get().setGenerateHtml(generateHtml);
    }

    public void setCompressXref(boolean compressXref) {
        this.threadConfig.get().setCompressXref(compressXref);
    }

    public boolean isCompressXref() {
        return this.threadConfig.get().isCompressXref();
    }

    public boolean isQuickContextScan() {
        return this.threadConfig.get().isQuickContextScan();
    }

    public void setQuickContextScan(boolean quickContextScan) {
        this.threadConfig.get().setQuickContextScan(quickContextScan);
    }

    public List<RepositoryInfo> getRepositories() {
        return this.threadConfig.get().getRepositories();
    }

    public void setRepositories(List<RepositoryInfo> repositories) {
        this.threadConfig.get().setRepositories(repositories);
    }

    public void setDefaultProject(Project defaultProject) {
        this.threadConfig.get().setDefaultProject(defaultProject);
    }

    public Project getDefaultProject() {
        return this.threadConfig.get().getDefaultProject();
    }

    public double getRamBufferSize() {
        return this.threadConfig.get().getRamBufferSize();
    }

    public void setRamBufferSize(double ramBufferSize) {
        this.threadConfig.get().setRamBufferSize(ramBufferSize);
    }

    public boolean isVerbose() {
        return this.threadConfig.get().isVerbose();
    }

    public void setVerbose(boolean verbose) {
        this.threadConfig.get().setVerbose(verbose);
    }

    public boolean isPrintProgress() {
        return this.threadConfig.get().isPrintProgress();
    }

    public void setPrintProgress(boolean printP) {
        this.threadConfig.get().setPrintProgress(printP);
    }

    public void setAllowLeadingWildcard(boolean allowLeadingWildcard) {
        this.threadConfig.get().setAllowLeadingWildcard(allowLeadingWildcard);
    }

    public boolean isAllowLeadingWildcard() {
        return this.threadConfig.get().isAllowLeadingWildcard();
    }

    public IgnoredNames getIgnoredNames() {
        return this.threadConfig.get().getIgnoredNames();
    }

    public void setIgnoredNames(IgnoredNames ignoredNames) {
        this.threadConfig.get().setIgnoredNames(ignoredNames);
    }

    public Filter getIncludedNames() {
        return this.threadConfig.get().getIncludedNames();
    }

    public void setIncludedNames(Filter includedNames) {
        this.threadConfig.get().setIncludedNames(includedNames);
    }

    public String getUserPage() {
        return this.threadConfig.get().getUserPage();
    }

    public String getRepoCmd(String clazzName) {
        return this.threadConfig.get().getRepoCmd(clazzName);
    }

    public String setRepoCmd(String clazzName, String cmd) {
        return this.threadConfig.get().setRepoCmd(clazzName, cmd);
    }

    public void setUserPage(String userPage) {
        this.threadConfig.get().setUserPage(userPage);
    }

    public String getUserPageSuffix() {
        return this.threadConfig.get().getUserPageSuffix();
    }

    public void setUserPageSuffix(String userPageSuffix) {
        this.threadConfig.get().setUserPageSuffix(userPageSuffix);
    }

    public String getBugPage() {
        return this.threadConfig.get().getBugPage();
    }

    public void setBugPage(String bugPage) {
        this.threadConfig.get().setBugPage(bugPage);
    }

    public String getBugPattern() {
        return this.threadConfig.get().getBugPattern();
    }

    public void setBugPattern(String bugPattern) {
        this.threadConfig.get().setBugPattern(bugPattern);
    }

    public String getReviewPage() {
        return this.threadConfig.get().getReviewPage();
    }

    public void setReviewPage(String reviewPage) {
        this.threadConfig.get().setReviewPage(reviewPage);
    }

    public String getReviewPattern() {
        return this.threadConfig.get().getReviewPattern();
    }

    public void setReviewPattern(String reviewPattern) {
        this.threadConfig.get().setReviewPattern(reviewPattern);
    }

    public String getWebappLAF() {
        return this.threadConfig.get().getWebappLAF();
    }

    public void setWebappLAF(String laf) {
        this.threadConfig.get().setWebappLAF(laf);
    }

    public Configuration.RemoteSCM getRemoteScmSupported() {
        return this.threadConfig.get().getRemoteScmSupported();
    }

    public void setRemoteScmSupported(Configuration.RemoteSCM supported) {
        this.threadConfig.get().setRemoteScmSupported(supported);
    }

    public boolean isOptimizeDatabase() {
        return this.threadConfig.get().isOptimizeDatabase();
    }

    public void setOptimizeDatabase(boolean optimizeDatabase) {
        this.threadConfig.get().setOptimizeDatabase(optimizeDatabase);
    }

    public boolean isUsingLuceneLocking() {
        return this.threadConfig.get().isUsingLuceneLocking();
    }

    public void setUsingLuceneLocking(boolean useLuceneLocking) {
        this.threadConfig.get().setUsingLuceneLocking(useLuceneLocking);
    }

    public boolean isIndexVersionedFilesOnly() {
        return this.threadConfig.get().isIndexVersionedFilesOnly();
    }

    public void setIndexVersionedFilesOnly(boolean indexVersionedFilesOnly) {
        this.threadConfig.get().setIndexVersionedFilesOnly(indexVersionedFilesOnly);
    }

    public boolean isTagsEnabled() {
        return this.threadConfig.get().isTagsEnabled();
    }

    public void setTagsEnabled(boolean tagsEnabled) {
        this.threadConfig.get().setTagsEnabled(tagsEnabled);
    }

    public Date getDateForLastIndexRun() {
        return this.threadConfig.get().getDateForLastIndexRun();
    }

    public String getDatabaseDriver() {
        return this.threadConfig.get().getDatabaseDriver();
    }

    public void setDatabaseDriver(String databaseDriver) {
        this.threadConfig.get().setDatabaseDriver(databaseDriver);
    }

    public String getDatabaseUrl() {
        return this.threadConfig.get().getDatabaseUrl();
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.threadConfig.get().setDatabaseUrl(databaseUrl);
    }

    public String getCTagsExtraOptionsFile() {
        return this.threadConfig.get().getCTagsExtraOptionsFile();
    }

    public void setCTagsExtraOptionsFile(String filename) {
        this.threadConfig.get().setCTagsExtraOptionsFile(filename);
    }

    public Set<String> getAllowedSymlinks() {
        return this.threadConfig.get().getAllowedSymlinks();
    }

    public void setAllowedSymlinks(Set<String> allowedSymlinks) {
        this.threadConfig.get().setAllowedSymlinks(allowedSymlinks);
    }

    public boolean isObfuscatingEMailAddresses() {
        return this.threadConfig.get().isObfuscatingEMailAddresses();
    }

    public void setObfuscatingEMailAddresses(boolean obfuscate) {
        this.threadConfig.get().setObfuscatingEMailAddresses(obfuscate);
    }

    public boolean isChattyStatusPage() {
        return this.threadConfig.get().isChattyStatusPage();
    }

    public void setChattyStatusPage(boolean chatty) {
        this.threadConfig.get().setChattyStatusPage(chatty);
    }

    public void setFetchHistoryWhenNotInCache(boolean nofetch) {
        this.threadConfig.get().setFetchHistoryWhenNotInCache(nofetch);
    }

    public boolean isFetchHistoryWhenNotInCache() {
        return this.threadConfig.get().isFetchHistoryWhenNotInCache();
    }

    public void readConfiguration(File file) throws IOException {
        this.setConfiguration(Configuration.read(file));
    }

    public void writeConfiguration(File file) throws IOException {
        this.threadConfig.get().write(file);
    }

    public void writeConfiguration(InetAddress host, int port) throws IOException {
        try (Socket sock = new Socket(host, port);
             XMLEncoder e = new XMLEncoder(sock.getOutputStream());){
            e.writeObject(this.threadConfig.get());
        }
    }

    protected void writeConfiguration() throws IOException {
        this.writeConfiguration(this.configServerSocket.getInetAddress(), this.configServerSocket.getLocalPort());
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.register();
        HistoryGuru.getInstance().invalidateRepositories(configuration.getRepositories());
    }

    public void setConfiguration(Configuration configuration, List<String> subFileList) {
        this.configuration = configuration;
        this.register();
        HistoryGuru.getInstance().invalidateRepositories(configuration.getRepositories(), subFileList);
    }

    public Configuration getConfiguration() {
        return this.threadConfig.get();
    }

    public void stopConfigurationListenerThread() {
        IOUtils.close(this.configServerSocket);
    }

    public boolean startConfigurationListenerThread(SocketAddress endpoint) {
        boolean ret = false;
        try {
            this.configServerSocket = new ServerSocket();
            this.configServerSocket.bind(endpoint);
            ret = true;
            final ServerSocket sock = this.configServerSocket;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);
                    while (!sock.isClosed()) {
                        try {
                            Socket s = sock.accept();
                            Throwable throwable = null;
                            try {
                                BufferedInputStream in = new BufferedInputStream(s.getInputStream());
                                Throwable throwable2 = null;
                                try {
                                    Object obj;
                                    int len;
                                    bos.reset();
                                    log.log(Level.FINE, "OpenGrok: Got request from {0}", s.getInetAddress().getHostAddress());
                                    byte[] buf = new byte[1024];
                                    while ((len = in.read(buf)) != -1) {
                                        bos.write(buf, 0, len);
                                    }
                                    buf = bos.toByteArray();
                                    if (log.isLoggable(Level.FINE)) {
                                        log.log(Level.FINE, "new config:{0}", new String(buf));
                                    }
                                    try (XMLDecoder d = new XMLDecoder(new ByteArrayInputStream(buf));){
                                        obj = d.readObject();
                                    }
                                    if (!(obj instanceof Configuration)) continue;
                                    RuntimeEnvironment.this.setConfiguration((Configuration)obj);
                                    log.log(Level.INFO, "Configuration updated: {0}", RuntimeEnvironment.this.configuration.getSourceRoot());
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (in == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    in.close();
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (s == null) continue;
                                if (throwable != null) {
                                    try {
                                        s.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                s.close();
                            }
                        }
                        catch (IOException e) {
                            log.log(Level.SEVERE, "Error reading config file: ", e);
                        }
                        catch (RuntimeException e) {
                            log.log(Level.SEVERE, "Error parsing config file: ", e);
                        }
                    }
                }
            });
            t.start();
        }
        catch (UnknownHostException ex) {
            log.log(Level.FINE, "Problem resolving sender: ", ex);
        }
        catch (IOException ex) {
            log.log(Level.FINE, "I/O error when waiting for config: ", ex);
        }
        if (!ret && this.configServerSocket != null) {
            IOUtils.close(this.configServerSocket);
        }
        return ret;
    }
}

