/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationKey;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XMLConfiguration
extends HierarchicalConfiguration
implements FileConfiguration {
    private static final String DEFAULT_ROOT_NAME = "configuration";
    private static char ATTR_DELIMITER = (char)44;
    private FileConfigurationDelegate delegate = new FileConfigurationDelegate();
    private Document document;
    private String rootElementName;

    public XMLConfiguration() {
    }

    public XMLConfiguration(String fileName) throws ConfigurationException {
        this();
        this.setFileName(fileName);
        this.load();
    }

    public XMLConfiguration(File file) throws ConfigurationException {
        this();
        this.setFile(file);
        if (file.exists()) {
            this.load();
        }
    }

    public XMLConfiguration(URL url) throws ConfigurationException {
        this();
        this.setURL(url);
        this.load();
    }

    public String getRootElementName() {
        if (this.getDocument() == null) {
            return this.rootElementName == null ? DEFAULT_ROOT_NAME : this.rootElementName;
        }
        return this.getDocument().getDocumentElement().getNodeName();
    }

    public void setRootElementName(String name) {
        if (this.getDocument() != null) {
            throw new UnsupportedOperationException("The name of the root element cannot be changed when loaded from an XML document!");
        }
        this.rootElementName = name;
    }

    public Document getDocument() {
        return this.document;
    }

    protected void addPropertyDirect(String key, Object obj) {
        super.addPropertyDirect(key, obj);
        this.delegate.possiblySave();
    }

    public void clearProperty(String key) {
        super.clearProperty(key);
        this.delegate.possiblySave();
    }

    public void clearTree(String key) {
        super.clearTree(key);
        this.delegate.possiblySave();
    }

    public void setProperty(String key, Object value) {
        super.setProperty(key, value);
        this.delegate.possiblySave();
    }

    public void initProperties(Document document, boolean elemRefs) {
        this.constructHierarchy(this.getRoot(), document.getDocumentElement(), elemRefs);
    }

    private void constructHierarchy(HierarchicalConfiguration.Node node, Element element, boolean elemRefs) {
        this.processAttributes(node, element);
        StringBuffer buffer = new StringBuffer();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node w3cNode = list.item(i);
            if (w3cNode instanceof Element) {
                Element child = (Element)w3cNode;
                XMLNode childNode = new XMLNode(child.getTagName(), elemRefs ? child : null);
                this.constructHierarchy(childNode, child, elemRefs);
                node.addChild(childNode);
                continue;
            }
            if (!(w3cNode instanceof Text)) continue;
            Text data = (Text)w3cNode;
            buffer.append(data.getData());
        }
        String text = buffer.toString().trim();
        if (text.length() > 0) {
            node.setValue(text);
        }
    }

    private void processAttributes(HierarchicalConfiguration.Node node, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node w3cNode = attributes.item(i);
            if (!(w3cNode instanceof Attr)) continue;
            Attr attr = (Attr)w3cNode;
            Iterator it = PropertyConverter.split(attr.getValue(), ATTR_DELIMITER).iterator();
            while (it.hasNext()) {
                XMLNode child = new XMLNode(ConfigurationKey.constructAttributeKey(attr.getName()), element);
                ((HierarchicalConfiguration.Node)child).setValue(it.next());
                node.addChild(child);
            }
        }
    }

    protected Document createDocument() throws ConfigurationException {
        try {
            Object builder;
            if (this.document == null) {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document newDocument = ((DocumentBuilder)builder).newDocument();
                Element rootElem = newDocument.createElement(this.getRootElementName());
                newDocument.appendChild(rootElem);
                this.document = newDocument;
            }
            builder = new XMLBuilderVisitor(this.document);
            ((XMLBuilderVisitor)builder).processDocument(this.getRoot());
            return this.document;
        }
        catch (DOMException domEx) {
            throw new ConfigurationException(domEx);
        }
        catch (ParserConfigurationException pex) {
            throw new ConfigurationException(pex);
        }
    }

    protected HierarchicalConfiguration.Node createNode(String name) {
        return new XMLNode(name, null);
    }

    public void load() throws ConfigurationException {
        this.delegate.load();
    }

    public void load(String fileName) throws ConfigurationException {
        this.delegate.load(fileName);
    }

    public void load(File file) throws ConfigurationException {
        this.delegate.load(file);
    }

    public void load(URL url) throws ConfigurationException {
        this.delegate.load(url);
    }

    public void load(InputStream in) throws ConfigurationException {
        this.delegate.load(in);
    }

    public void load(InputStream in, String encoding) throws ConfigurationException {
        this.delegate.load(in, encoding);
    }

    public void load(Reader in) throws ConfigurationException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document newDocument = builder.parse(new InputSource(in));
            Document oldDocument = this.document;
            this.document = null;
            this.initProperties(newDocument, oldDocument == null);
            this.document = oldDocument == null ? newDocument : oldDocument;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public void save() throws ConfigurationException {
        this.delegate.save();
    }

    public void save(String fileName) throws ConfigurationException {
        this.delegate.save(fileName);
    }

    public void save(File file) throws ConfigurationException {
        this.delegate.save(file);
    }

    public void save(URL url) throws ConfigurationException {
        this.delegate.save(url);
    }

    public void save(OutputStream out) throws ConfigurationException {
        this.delegate.save(out);
    }

    public void save(OutputStream out, String encoding) throws ConfigurationException {
        this.delegate.save(out, encoding);
    }

    public void save(Writer writer) throws ConfigurationException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(this.createDocument());
            StreamResult result = new StreamResult(writer);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public String getFileName() {
        return this.delegate.getFileName();
    }

    public void setFileName(String fileName) {
        this.delegate.setFileName(fileName);
    }

    public String getBasePath() {
        return this.delegate.getBasePath();
    }

    public void setBasePath(String basePath) {
        this.delegate.setBasePath(basePath);
    }

    public File getFile() {
        return this.delegate.getFile();
    }

    public void setFile(File file) {
        this.delegate.setFile(file);
    }

    public URL getURL() {
        return this.delegate.getURL();
    }

    public void setURL(URL url) {
        this.delegate.setURL(url);
    }

    public void setAutoSave(boolean autoSave) {
        this.delegate.setAutoSave(autoSave);
    }

    public boolean isAutoSave() {
        return this.delegate.isAutoSave();
    }

    public ReloadingStrategy getReloadingStrategy() {
        return this.delegate.getReloadingStrategy();
    }

    public void setReloadingStrategy(ReloadingStrategy strategy) {
        this.delegate.setReloadingStrategy(strategy);
    }

    public void reload() {
        this.delegate.reload();
    }

    public String getEncoding() {
        return this.delegate.getEncoding();
    }

    public void setEncoding(String encoding) {
        this.delegate.setEncoding(encoding);
    }

    private class FileConfigurationDelegate
    extends AbstractFileConfiguration {
        private FileConfigurationDelegate() {
        }

        public void load(Reader in) throws ConfigurationException {
            XMLConfiguration.this.load(in);
        }

        public void save(Writer out) throws ConfigurationException {
            XMLConfiguration.this.save(out);
        }
    }

    static class XMLBuilderVisitor
    extends HierarchicalConfiguration.BuilderVisitor {
        private Document document;

        public XMLBuilderVisitor(Document doc) {
            this.document = doc;
        }

        public void processDocument(HierarchicalConfiguration.Node rootNode) {
            rootNode.visit(this, null);
        }

        protected Object insert(HierarchicalConfiguration.Node newNode, HierarchicalConfiguration.Node parent, HierarchicalConfiguration.Node sibling1, HierarchicalConfiguration.Node sibling2) {
            if (ConfigurationKey.isAttributeKey(newNode.getName())) {
                XMLBuilderVisitor.updateAttribute(parent, this.getElement(parent), newNode.getName());
                return null;
            }
            Element elem = this.document.createElement(newNode.getName());
            if (newNode.getValue() != null) {
                elem.appendChild(this.document.createTextNode(newNode.getValue().toString()));
            }
            if (sibling2 == null) {
                this.getElement(parent).appendChild(elem);
            } else if (sibling1 != null) {
                this.getElement(parent).insertBefore(elem, this.getElement(sibling1).getNextSibling());
            } else {
                this.getElement(parent).insertBefore(elem, this.getElement(parent).getFirstChild());
            }
            return elem;
        }

        private static void updateAttribute(HierarchicalConfiguration.Node node, Element elem, String name) {
            if (node != null && elem != null) {
                List attrs = node.getChildren(name);
                StringBuffer buf = new StringBuffer();
                Iterator it = attrs.iterator();
                while (it.hasNext()) {
                    HierarchicalConfiguration.Node attr = (HierarchicalConfiguration.Node)it.next();
                    if (attr.getValue() != null) {
                        if (buf.length() > 0) {
                            buf.append(ATTR_DELIMITER);
                        }
                        buf.append(attr.getValue());
                    }
                    attr.setReference(elem);
                }
                if (buf.length() < 1) {
                    elem.removeAttribute(ConfigurationKey.removeAttributeMarkers(name));
                } else {
                    elem.setAttribute(ConfigurationKey.removeAttributeMarkers(name), buf.toString());
                }
            }
        }

        static void updateAttribute(HierarchicalConfiguration.Node node, String name) {
            if (node != null) {
                XMLBuilderVisitor.updateAttribute(node, (Element)node.getReference(), name);
            }
        }

        private Element getElement(HierarchicalConfiguration.Node node) {
            return node.getName() != null ? (Element)node.getReference() : this.document.getDocumentElement();
        }
    }

    class XMLNode
    extends HierarchicalConfiguration.Node {
        public XMLNode(Element elem) {
            this.setReference(elem);
        }

        public XMLNode(String name, Element elem) {
            super(name);
            this.setReference(elem);
        }

        public void setValue(Object value) {
            super.setValue(value);
            if (this.getReference() != null && XMLConfiguration.this.document != null) {
                if (ConfigurationKey.isAttributeKey(this.getName())) {
                    this.updateAttribute();
                } else {
                    this.updateElement(value);
                }
            }
        }

        protected void removeReference() {
            if (this.getReference() != null) {
                Element element = (Element)this.getReference();
                if (ConfigurationKey.isAttributeKey(this.getName())) {
                    this.updateAttribute();
                } else {
                    Node parentElem = element.getParentNode();
                    if (parentElem != null) {
                        parentElem.removeChild(element);
                    }
                }
            }
        }

        private void updateElement(Object value) {
            Text txtNode = this.findTextNodeForUpdate();
            if (value == null) {
                if (txtNode != null) {
                    ((Element)this.getReference()).removeChild(txtNode);
                }
            } else if (txtNode == null) {
                txtNode = XMLConfiguration.this.document.createTextNode(value.toString());
                if (((Element)this.getReference()).getFirstChild() != null) {
                    ((Element)this.getReference()).insertBefore(txtNode, ((Element)this.getReference()).getFirstChild());
                } else {
                    ((Element)this.getReference()).appendChild(txtNode);
                }
            } else {
                txtNode.setNodeValue(value.toString());
            }
        }

        private void updateAttribute() {
            XMLBuilderVisitor.updateAttribute(this.getParent(), this.getName());
        }

        private Text findTextNodeForUpdate() {
            Text result = null;
            Element elem = (Element)this.getReference();
            NodeList children = elem.getChildNodes();
            ArrayList<Node> textNodes = new ArrayList<Node>();
            for (int i = 0; i < children.getLength(); ++i) {
                Node nd = children.item(i);
                if (!(nd instanceof Text)) continue;
                if (result == null) {
                    result = (Text)nd;
                    continue;
                }
                textNodes.add(nd);
            }
            if (result instanceof CDATASection) {
                textNodes.add(result);
                result = null;
            }
            Iterator it = textNodes.iterator();
            while (it.hasNext()) {
                elem.removeChild((Node)it.next());
            }
            return result;
        }
    }
}

