#!/usr/pkg/bin/bash

#*******************************************************************************
# The contents of this file are subject to the Common Public Attribution License 
# Version 1.0 (the "License"); you may not use this file except in compliance with 
# the License. You may obtain a copy of the License at 
# http://www.projectlibre.com/license . The License is based on the Mozilla Public 
# License Version 1.1 but Sections 14 and 15 have been added to cover use of 
# software over a computer network and provide for limited attribution for the 
# Original Developer. In addition, Exhibit A has been modified to be consistent 
# with Exhibit B. 
#
# Software distributed under the License is distributed on an "AS IS" basis, 
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the 
# specific language governing rights and limitations under the License. The 
# Original Code is ProjectLibre. The Original Developer is the Initial Developer 
# and is ProjectLibre Inc. All portions of the code written by ProjectLibre are 
# Copyright (c) 2012-2019. All Rights Reserved. All portions of the code written by 
# ProjectLibre are Copyright (c) 2012-2019. All Rights Reserved. Contributor 
# ProjectLibre, Inc.
#
# Alternatively, the contents of this file may be used under the terms of the 
# ProjectLibre End-User License Agreement (the ProjectLibre License) in which case 
# the provisions of the ProjectLibre License are applicable instead of those above. 
# If you wish to allow use of your version of this file only under the terms of the 
# ProjectLibre License and not to allow others to use your version of this file 
# under the CPAL, indicate your decision by deleting the provisions above and 
# replace them with the notice and other provisions required by the ProjectLibre 
# License. If you do not delete the provisions above, a recipient may use your 
# version of this file under either the CPAL or the ProjectLibre Licenses. 
#
#
# [NOTE: The text of this Exhibit A may differ slightly from the text of the notices 
# in the Source Code files of the Original Code. You should use the text of this 
# Exhibit A rather than the text found in the Original Code Source Code for Your 
# Modifications.] 
#
# EXHIBIT B. Attribution Information for ProjectLibre required
#
# Attribution Copyright Notice: Copyright (c) 2012-2019, ProjectLibre, Inc.
# Attribution Phrase (not exceeding 10 words): 
# ProjectLibre, open source project management software.
# Attribution URL: http://www.projectlibre.com
# Graphic Image as provided in the Covered Code as file: projectlibre-logo.png with 
# alternatives listed on http://www.projectlibre.com/logo 
#
# Display of Attribution Information is required in Larger Works which are defined 
# in the CPAL as a work which combines Covered Code or portions thereof with code 
# not governed by the terms of the CPAL. However, in addition to the other notice 
# obligations, all copies of the Covered Code in Executable and Source Code form 
# distributed must, as a form of attribution of the original author, include on 
# each user interface screen the "ProjectLibre" logo visible to all users. 
# The ProjectLibre logo should be located horizontally aligned with the menu bar 
# and left justified on the top left of the screen adjacent to the File menu. The 
# logo must be at least 144 x 31 pixels. When users click on the "ProjectLibre" 
# logo it must direct them back to http://www.projectlibre.com. 
#*******************************************************************************

CONF_DIR="$HOME/.projectlibre"
RUN_CONF="$CONF_DIR/run.conf"
VERSION_FILE="$CONF_DIR/java-version"
JAVA_INSTALL_DIR="/usr/java"
JAVA_INSTALL_DIR_EXE="bin/java"
JAVA_INSTALL_DIR2="/usr/lib/jvm"
JAVA_INSTALL_DIR_EXE2="bin/java"
JAVA_INSTALL_DIR3="/opt/ibm"
JAVA_INSTALL_DIR_EXE3="jre/bin/java"
MIN_JAVA_VERSION="6"

#Default conf values
JAVA_EXE="/usr/pkg/java/openjdk17/bin/java"
JAVA_OPTS="-Xms128m -Xmx768m"
#PROJECTLIBRE_HOME0="/usr/share/projectlibre"
PROJECTLIBRE_HOME0=/usr/pkg/share/projectlibre
PROJECTLIBRE_HOME="$PROJECTLIBRE_HOME0"
LOG_LEVEL="DEBUG"
LOG_FILE="/dev/null"
AUTO_CONFIGURATION="1"
JAVA_OK="0"
FIRST_JAVA_WITH_CORRECT_VERSION=""
OS_NAME=`uname`

if [ "x$OS_NAME" = "xSunOS" ]; then
	TAIL_COMMAND="/usr/xpg4/bin/tail"
else
	TAIL_COMMAND="tail"
fi

create_run_conf() {
	echo "#Auto-generated parameters" > "$RUN_CONF"
	echo "AUTO_CONFIGURATION=\"$AUTO_CONFIGURATION\"" >> "$RUN_CONF"
	echo "JAVA_EXE=\"$JAVA_EXE\"" >> "$RUN_CONF"

	if [ "x$OS_NAME" = "xLinux" ]; then
		OS_ID=`lsb_release -i 2> /dev/null | sed "s/.*:[ \t]*\(.*\)/\1/"`
		OS_RELEASE=`lsb_release -r 2> /dev/null | sed "s/.*:[ \t]*\(.*\)/\1/"`
	else
		#OS_ID=`uname -v`
		OS_RELEASE=`uname -r`
	fi
	echo "OS_NAME=\"$OS_NAME\"" >> "$RUN_CONF"
	echo "OS_ID=\"$OS_ID\"" >> "$RUN_CONF"
	echo "OS_RELEASE=\"$OS_RELEASE\"" >> "$RUN_CONF"

	if [ "x$OS_ID" = "xSUSE LINUX" ]; then
		#fix broken prefs on SLED10/IBM
		JAVA_OPTS="$JAVA_OPTS -Djava.util.prefs.userRoot=$HOME/.java/.userPrefs -Djava.util.prefs.systemRoot=$HOME/.projectlibre"
	fi
	echo "JAVA_OPTS=\"$JAVA_OPTS\"" >> "$RUN_CONF"

	#echo "PROJECTLIBRE_HOME=\"$PROJECTLIBRE_HOME\"" >> "$RUN_CONF"
	echo "LOG_LEVEL=\"$LOG_LEVEL\"" >> "$RUN_CONF"
	echo "LOG_FILE=\"$LOG_FILE\"" >> "$RUN_CONF"
}

check_java() {
	JAVA_EXE="$1"
	echo "Checking $JAVA_EXE"

	"$JAVA_EXE" -version > "$VERSION_FILE" 2>&1 || rm -f "$VERSION_FILE"

	if [ -r "$VERSION_FILE" ]; then
		local JAVA_VERSION
		local IFS=$'\n'		
		local lines=`cat "$VERSION_FILE" | tr '\r' '\n'`
		
		for line in $lines; do
			if [[ -z $JAVA_VERSION && $line = *"version \""* ]]
			then
				local version=$(echo $line | sed -e 's/.*version "\(.*\)"\(.*\)/\1/; 1q')
				if [[ $version = "1."* ]]
				then
					JAVA_VERSION=$(echo $version | sed -e 's/1\.\([0-9]*\)\(.*\)/\1/; 1q')
				else
					JAVA_VERSION=$(echo $version | sed -e 's/\([0-9]*\)\(.*\)/\1/; 1q')
				fi
			fi
		done

		if [ "x$OS_NAME" = "xSunOS" ]; then
			echo "    Java version: $JAVA_VERSION \c"
		else
			echo -n "    Java version: $JAVA_VERSION "
		fi


		#Comparable format
		if [ "$JAVA_VERSION" ]; then
			if [ "$JAVA_VERSION" -ge "$MIN_JAVA_VERSION" ];	then
				echo "OK"
				JAVA_IMPL=`cat "$VERSION_FILE" | awk '/^(java|openjdk) version/ { getline; print $1; }'`
				if [ "x$OS_NAME" = "xSunOS" ]; then
					echo "    Java implementation: $JAVA_IMPL \c"
				else
					echo -n "    Java implementation: $JAVA_IMPL "
				fi
				if [ "x$FIRST_JAVA_WITH_CORRECT_VERSION" = "x" ]; then
					FIRST_JAVA_WITH_CORRECT_VERSION="$JAVA_EXE"
				fi
				if [ "x$JAVA_IMPL" = "xJava(TM)" ] || [ "x$JAVA_IMPL" = "xOpenJDK" ]; then
					echo "OK"
				else
					echo "Warning, Unknown Java implementation"
				fi
                create_run_conf
                JAVA_OK="1"
			else
				echo "NOK, version < $MIN_JAVA_VERSION"
			fi
		else
			echo "NOK"
		fi
	else
		echo "    Error"
	fi
}

run_projectlibre() { # call function with parameters to hand over
	if [ "$LOG_LEVEL" ] && [ "x$LOG_LEVEL" = "xDEBUG" ]; then
		"$JAVA_EXE" $JAVA_OPTS -jar "$PROJECTLIBRE_HOME/projectlibre.jar" "$@" > "$LOG_FILE"
	else
		"$JAVA_EXE" $JAVA_OPTS -jar "$PROJECTLIBRE_HOME/projectlibre.jar" "$@" > /dev/null 2>&1
	fi
}


if [ ! -d "$CONF_DIR" ]; then
	mkdir "$CONF_DIR"
	OS_ID=`lsb_release -i 2> /dev/null | sed "s/.*:[ \t]*\(.*\)/\1/"`
	if [ "x$OS_ID" = "xSUSE LINUX" ]; then
		#fix broken prefs on SLED10/IBM
		mkdir "$CONF_DIR/.systemPrefs"
	fi
fi


if [ -f "$RUN_CONF" ]; then
	. "$RUN_CONF"
	PROJECTLIBRE_HOME="$PROJECTLIBRE_HOME0"
	#PROJECTLIBRE_HOME can be harmful with multiple versions. disable
	JAVA_OK="1"
	run_projectlibre --silentlyFail true "$@" || if [[ $? -eq 126 || $? -eq 127 || $? -eq 64 ]]; then
		#126 command invoked cannot execute
		#127 command not found
		#64 bad java version/impl
		if [ "x$AUTO_CONFIGURATION" != "x0" ]; then
			JAVA_OK="0"
			#auto-detection will be performed
		fi
	fi
fi

if [ "$JAVA_OK" -eq "0" ]; then
	echo "Java auto-detection..."

	if [ "$JAVA_HOME" ] && [ -x "$JAVA_HOME/bin/java" ]; then
		check_java "$JAVA_HOME/bin/java"
	fi

	if [ "$JAVA_OK" -eq "0" ]; then
		check_java "java"
	fi

	#search in $JAVA_INSTALL_DIR
	if [ "$JAVA_OK" -eq "0" ] && [ -d "$JAVA_INSTALL_DIR" ]; then
		J="$JAVA_INSTALL_DIR/latest/$JAVA_INSTALL_DIR_EXE"
		if [ -x "$J" ]; then
			check_java "$J"
		fi
		if [ "$JAVA_OK" -eq "0" ]; then
			J="$JAVA_INSTALL_DIR/default/$JAVA_INSTALL_DIR_EXE"
			if [ -x "$J" ]; then
				check_java "$J"
			fi
		fi
		if [ "$JAVA_OK" -eq "0" ]; then
			for i in $JAVA_INSTALL_DIR/* ; do
				J="$i/$JAVA_INSTALL_DIR_EXE"
				if [ "$J" = "$JAVA_INSTALL_DIR/latest" ] || [ "$J" = "$JAVA_INSTALL_DIR/default" ]; then
					#already checked
					continue
				fi
				if [ -x "$J" ]; then
					check_java "$J"
					if [ "$JAVA_OK" -eq "1" ]; then
						break
					fi
				fi
			done
		fi
	fi

	JAVA_INSTALL_DIR="$JAVA_INSTALL_DIR2"
	JAVA_INSTALL_DIR_EXE="$JAVA_INSTALL_DIR_EXE2"

	#search in $JAVA_INSTALL_DIR
	if [ "$JAVA_OK" -eq "0" ] && [ -d "$JAVA_INSTALL_DIR" ]; then
		J="$JAVA_INSTALL_DIR/latest/$JAVA_INSTALL_DIR_EXE"
		if [ -x "$J" ]; then
			check_java "$J"
		fi
		if [ "$JAVA_OK" -eq "0" ]; then
			J="$JAVA_INSTALL_DIR/default/$JAVA_INSTALL_DIR_EXE"
			if [ -x "$J" ]; then
				check_java "$J"
			fi
		fi
		if [ "$JAVA_OK" -eq "0" ]; then
			for i in $JAVA_INSTALL_DIR/* ; do
				J="$i/$JAVA_INSTALL_DIR_EXE"
				if [ "$J" = "$JAVA_INSTALL_DIR/latest" ] || [ "$J" = "$JAVA_INSTALL_DIR/default" ]; then
					#already checked
					continue
				fi
				if [ -x "$J" ]; then
					check_java "$J"
					if [ "$JAVA_OK" -eq "1" ]; then
						break
					fi
				fi
			done
		fi
	fi

	JAVA_INSTALL_DIR="$JAVA_INSTALL_DIR3"
	JAVA_INSTALL_DIR_EXE="$JAVA_INSTALL_DIR_EXE3"

	#search in $JAVA_INSTALL_DIR
	if [ "$JAVA_OK" -eq "0" ] && [ -d "$JAVA_INSTALL_DIR" ]; then
		J="$JAVA_INSTALL_DIR/latest/$JAVA_INSTALL_DIR_EXE"
		if [ -x "$J" ]; then
			check_java "$J"
		fi
		if [ "$JAVA_OK" -eq "0" ]; then
			J="$JAVA_INSTALL_DIR/default/$JAVA_INSTALL_DIR_EXE"
			if [ -x "$J" ]; then
				check_java "$J"
			fi
		fi
		if [ "$JAVA_OK" -eq "0" ]; then
			for i in $JAVA_INSTALL_DIR/* ; do
				J="$i/$JAVA_INSTALL_DIR_EXE"
				if [ "$J" = "$JAVA_INSTALL_DIR/latest" ] || [ "$J" = "$JAVA_INSTALL_DIR/default" ]; then
					#already checked
					continue
				fi
				if [ -x "$J" ]; then
					check_java "$J"
					if [ "$JAVA_OK" -eq "1" ]; then
						break
					fi
				fi
			done
		fi
	fi


	if [ "$JAVA_OK" -eq "0" ]; then
		echo "Java not found or incorrect version."
		echo "Please install OpenJDK, Oracle JRE 1.6+ or set JAVA_HOME environment variable if it's already installed."
	else
		echo "Java OK"
	fi

	if [ "$JAVA_OK" -eq "1" ]; then
		run_projectlibre "$@"
	else
		if [ "x$FIRST_JAVA_WITH_CORRECT_VERSION" != "x" ]; then
			echo "Trying $FIRST_JAVA_WITH_CORRECT_VERSION ..."
			JAVA_EXE="$FIRST_JAVA_WITH_CORRECT_VERSION"
			create_run_conf
			run_projectlibre "$@"
			echo $?
		fi
	fi


fi

