require 'mkmf'

pkg_config = with_config("pkg-config", "pkg-config")

$CFLAGS << ' -DX_DISPLAY_MISSING ' << `#{pkg_config} imlib2 --cflags`.chomp
$LDFLAGS << ' ' << `#{pkg_config} imlib2 --libs`.chomp

if have_library("Imlib2", "imlib_create_image")
  # test for faulty versions of imlib2
  ver = `pkg-config imlib2 --modversion`.chomp.split(/\./)
  major, minor, revision = ver[0].to_i, ver[1].to_i, ver[2].to_i
  if ((major > 1)               ||
      (major == 1 && minor > 0) ||
      (major == 1 && minor == 0 && revision > 5))
    $CFLAGS << ' -DDISABLE_DRAW_PIXEL_WORKAROUND '
  else
    puts 'Note: This version of Imlib2 has a bug in imlib_image_draw_pixel().',
         'Enabling workaround (see documentation for details).'
  end

  create_makefile("imlib2")
end
