/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionActionWithTextCaching
implements Comparable<IntentionActionWithTextCaching>,
PossiblyDumbAware,
ShortcutProvider,
IntentionActionDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching");
    private final List<IntentionAction> myOptionIntentions;
    private final List<IntentionAction> myOptionErrorFixes;
    private final List<IntentionAction> myOptionInspectionFixes;
    private final String myText;
    private final IntentionAction myAction;
    private final String myDisplayName;
    private final Icon myIcon;

    IntentionActionWithTextCaching(@NotNull IntentionAction action) {
        if (action == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(0);
        }
        this(action, action.getText(), null, null);
    }

    IntentionActionWithTextCaching(@NotNull HighlightInfo.IntentionActionDescriptor descriptor, @Nullable BiConsumer<? super IntentionActionWithTextCaching, ? super IntentionAction> markInvoked) {
        if (descriptor == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(1);
        }
        this(descriptor.getAction(), descriptor.getDisplayName(), descriptor.getIcon(), markInvoked);
    }

    private IntentionActionWithTextCaching(@NotNull IntentionAction action, String displayName, @Nullable Icon icon, @Nullable BiConsumer<? super IntentionActionWithTextCaching, ? super IntentionAction> markInvoked) {
        if (action == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(2);
        }
        this.myOptionIntentions = new ArrayList<IntentionAction>();
        this.myOptionErrorFixes = new ArrayList<IntentionAction>();
        this.myOptionInspectionFixes = new ArrayList<IntentionAction>();
        this.myIcon = icon;
        this.myText = action.getText();
        LOG.assertTrue(this.myText != null, (Object)("action " + action.getClass() + " text returned null"));
        this.myAction = new MyIntentionAction(action, markInvoked);
        this.myDisplayName = displayName;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(3);
        }
        return string;
    }

    void addIntention(@NotNull IntentionAction action) {
        if (action == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(4);
        }
        this.myOptionIntentions.add(action);
    }

    void addErrorFix(@NotNull IntentionAction action) {
        if (action == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(5);
        }
        this.myOptionErrorFixes.add(action);
    }

    void addInspectionFix(@NotNull IntentionAction action) {
        if (action == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(6);
        }
        this.myOptionInspectionFixes.add(action);
    }

    @NotNull
    public IntentionAction getAction() {
        IntentionAction intentionAction = this.myAction;
        if (intentionAction == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(7);
        }
        return intentionAction;
    }

    @NotNull
    List<IntentionAction> getOptionIntentions() {
        List<IntentionAction> list2 = this.myOptionIntentions;
        if (list2 == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    List<IntentionAction> getOptionErrorFixes() {
        List<IntentionAction> list2 = this.myOptionErrorFixes;
        if (list2 == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    List<IntentionAction> getOptionInspectionFixes() {
        List<IntentionAction> list2 = this.myOptionInspectionFixes;
        if (list2 == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public List<IntentionAction> getOptionActions() {
        List list2 = ContainerUtil.concat((List[])new List[]{this.myOptionIntentions, this.myOptionErrorFixes, this.myOptionInspectionFixes});
        if (list2 == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(11);
        }
        return list2;
    }

    String getToolName() {
        return this.myDisplayName;
    }

    @NotNull
    public String toString() {
        String string = this.getText();
        if (string == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull IntentionActionWithTextCaching other) {
        if (other == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(13);
        }
        if (this.myAction instanceof Comparable) {
            return ((Comparable)this.myAction).compareTo(other.getAction());
        }
        if (other.getAction() instanceof Comparable) {
            return -((Comparable)other.getAction()).compareTo(this.myAction);
        }
        return Comparing.compare((Comparable)((Object)this.getText()), (Comparable)((Object)other.getText()));
    }

    Icon getIcon() {
        return this.myIcon;
    }

    public boolean isDumbAware() {
        return DumbService.isDumbAware((Object)this.myAction);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        return this.myAction instanceof ShortcutProvider ? ((ShortcutProvider)this.myAction).getShortcut() : null;
    }

    @NotNull
    public IntentionAction getDelegate() {
        IntentionAction intentionAction = this.getAction();
        if (intentionAction == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(14);
        }
        return intentionAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionIntentions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionErrorFixes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionInspectionFixes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionActions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addIntention";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addErrorFix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addInspectionFix";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyIntentionAction
    implements IntentionAction,
    IntentionActionDelegate,
    Comparable<MyIntentionAction>,
    ShortcutProvider {
        private final IntentionAction myAction;
        private final BiConsumer<? super IntentionActionWithTextCaching, ? super IntentionAction> myMarkInvoked;

        MyIntentionAction(IntentionAction action, BiConsumer<? super IntentionActionWithTextCaching, ? super IntentionAction> markInvoked) {
            this.myAction = action;
            this.myMarkInvoked = markInvoked;
        }

        @Nls
        @NotNull
        public String getText() {
            String string = this.myAction.getText();
            if (string == null) {
                MyIntentionAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        public String toString() {
            return this.getDelegate().getClass() + ": " + this.getDelegate();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.myAction.getFamilyName();
            if (string == null) {
                MyIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
            if (project == null) {
                MyIntentionAction.$$$reportNull$$$0(2);
            }
            return this.myAction.isAvailable(project, editor, file2);
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
            if (project == null) {
                MyIntentionAction.$$$reportNull$$$0(3);
            }
            this.myAction.invoke(project, editor, file2);
            if (this.myMarkInvoked != null) {
                this.myMarkInvoked.accept(IntentionActionWithTextCaching.this, (IntentionAction)this.myAction);
            }
        }

        public boolean startInWriteAction() {
            return this.myAction.startInWriteAction();
        }

        @NotNull
        public IntentionAction getDelegate() {
            IntentionAction intentionAction = this.myAction;
            if (intentionAction == null) {
                MyIntentionAction.$$$reportNull$$$0(4);
            }
            return intentionAction;
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                MyIntentionAction.$$$reportNull$$$0(5);
            }
            return this.myAction.getElementToMakeWritable(currentFile);
        }

        @Nullable
        public ShortcutSet getShortcut() {
            return this.myAction instanceof ShortcutProvider ? ((ShortcutProvider)this.myAction).getShortcut() : null;
        }

        @Override
        public int compareTo(@NotNull MyIntentionAction other) {
            if (other == null) {
                MyIntentionAction.$$$reportNull$$$0(6);
            }
            if (this.myAction instanceof Comparable) {
                return ((Comparable)this.myAction).compareTo(other.getDelegate());
            }
            if (other.getDelegate() instanceof Comparable) {
                return -((Comparable)other.getDelegate()).compareTo(this.myAction);
            }
            return Comparing.compare((Comparable)((Object)this.getText()), (Comparable)((Object)other.getText()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching$MyIntentionAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFile";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching$MyIntentionAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

