/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaCheckBoxUI;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WinIntelliJCheckBoxUI
extends DarculaCheckBoxUI {
    private static final Icon DEFAULT_ICON = ((EmptyIcon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)13))).asUIResource();

    public static ComponentUI createUI(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        b.setRolloverEnabled(true);
        return new WinIntelliJCheckBoxUI();
    }

    @Override
    protected Rectangle updateViewRect(AbstractButton b, Rectangle viewRect) {
        JBInsets.removeFrom((Rectangle)viewRect, (Insets)b.getInsets());
        return viewRect;
    }

    @Override
    protected Dimension updatePreferredSize(JComponent c, Dimension size) {
        return size;
    }

    @Override
    protected void drawCheckIcon(JComponent c, Graphics2D g, AbstractButton b, Rectangle iconRect, boolean selected, boolean enabled) {
        ButtonModel bm = b.getModel();
        boolean focused = c.hasFocus() || bm.isRollover() || WinIntelliJCheckBoxUI.isCellRollover(b);
        boolean pressed = bm.isPressed() || WinIntelliJCheckBoxUI.isCellPressed(b);
        String iconName = this.isIndeterminate(b) ? "checkBoxIndeterminate" : "checkBox";
        Icon icon = LafIconLookup.getIcon((String)iconName, (selected || this.isIndeterminate(b) ? 1 : 0) != 0, (boolean)focused, (boolean)enabled, (boolean)false, (boolean)pressed);
        icon.paintIcon(c, g, iconRect.x, iconRect.y);
    }

    private static boolean isCellRollover(AbstractButton checkBox2) {
        Rectangle cellPosition = (Rectangle)checkBox2.getClientProperty("JCheckBox.rollOver.rectangle");
        return cellPosition != null && cellPosition.getBounds().equals(checkBox2.getBounds());
    }

    private static boolean isCellPressed(AbstractButton checkBox2) {
        Rectangle cellPosition = (Rectangle)checkBox2.getClientProperty("JCheckBox.pressed.rectangle");
        return cellPosition != null && cellPosition.getBounds().equals(checkBox2.getBounds());
    }

    @Override
    public Icon getDefaultIcon() {
        return DEFAULT_ICON;
    }

    @Override
    protected int textIconGap() {
        return JBUI.scale((int)4);
    }
}

