/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeNode
extends DefaultMutableTreeNode {
    protected static final ArrayList<File> EMPTY_FILE_ARRAY = new ArrayList();
    DefaultTreeModel myTreeModel;
    private JTree myTree;
    private String myErrorText;
    protected SimpleTextAttributes myFilterAttributes;

    public void setTree(JTree tree) {
        this.myTree = tree;
        if (this.children == null) {
            return;
        }
        for (Object aChildren : this.children) {
            AbstractTreeNode node = (AbstractTreeNode)aChildren;
            node.setTree(tree);
        }
    }

    public void setTreeModel(DefaultTreeModel treeModel) {
        this.myTreeModel = treeModel;
        if (this.children == null) {
            return;
        }
        for (Object aChildren : this.children) {
            AbstractTreeNode node = (AbstractTreeNode)aChildren;
            node.setTreeModel(treeModel);
        }
    }

    public void setErrorText(String errorText) {
        this.myErrorText = errorText;
    }

    public String getErrorText() {
        return this.myErrorText;
    }

    protected boolean acceptFilter(@Nullable Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        boolean apply2 = false;
        if (this.children != null && filter != null) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                AbstractTreeNode node = (AbstractTreeNode)it.next();
                if (node.acceptFilter(filter, showOnlyFilteredItems)) {
                    apply2 = true;
                    continue;
                }
                if (!showOnlyFilteredItems) continue;
                if (node instanceof Disposable) {
                    Disposer.dispose((Disposable)((Disposable)node));
                }
                it.remove();
            }
            this.applyFilter(apply2);
        }
        return apply2;
    }

    protected void applyFilter(boolean apply2) {
        this.myFilterAttributes = apply2 ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : null;
    }

    protected DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    public JTree getTree() {
        return this.myTree;
    }

    public String getText() {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.getName());
        if (this.showStatistics()) {
            result2.append(" (");
            result2.append(AbstractTreeNode.getStatistics(this.getItemsCount()));
            result2.append(")");
        }
        return result2.toString();
    }

    private static String getStatistics(int itemsCount) {
        return VcsBundle.message((String)"update.tree.node.size.statistics", (Object[])new Object[]{itemsCount});
    }

    @NotNull
    protected abstract String getName();

    protected abstract int getItemsCount();

    protected abstract boolean showStatistics();

    @NonNls
    public abstract Icon getIcon(boolean var1);

    @NotNull
    public abstract Collection<VirtualFile> getVirtualFiles();

    @NotNull
    public abstract Collection<File> getFiles();

    @NotNull
    public abstract SimpleTextAttributes getAttributes();

    public abstract boolean getSupportsDeletion();
}

