/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SelectionModelWindow
implements SelectionModel {
    private final SelectionModel myHostModel;
    private final DocumentWindow myDocument;
    private final EditorWindow myInjectedEditor;

    SelectionModelWindow(EditorEx delegate, DocumentWindow document, EditorWindow injectedEditor) {
        this.myDocument = document;
        this.myInjectedEditor = injectedEditor;
        this.myHostModel = delegate.getSelectionModel();
    }

    public int getSelectionStart() {
        return this.myDocument.hostToInjected(this.myHostModel.getSelectionStart());
    }

    @Nullable
    public VisualPosition getSelectionStartPosition() {
        return this.myInjectedEditor.offsetToVisualPosition(this.getSelectionStart());
    }

    public int getSelectionEnd() {
        return this.myDocument.hostToInjected(this.myHostModel.getSelectionEnd());
    }

    @Nullable
    public VisualPosition getSelectionEndPosition() {
        return this.myInjectedEditor.offsetToVisualPosition(this.getSelectionEnd());
    }

    public String getSelectedText() {
        return this.myHostModel.getSelectedText();
    }

    @Nullable
    public String getSelectedText(boolean allCarets) {
        return this.myHostModel.getSelectedText(allCarets);
    }

    public int getLeadSelectionOffset() {
        return this.myDocument.hostToInjected(this.myHostModel.getLeadSelectionOffset());
    }

    @Nullable
    public VisualPosition getLeadSelectionPosition() {
        return this.myHostModel.getLeadSelectionPosition();
    }

    public boolean hasSelection() {
        return this.myHostModel.hasSelection();
    }

    public boolean hasSelection(boolean anyCaret) {
        return this.myHostModel.hasSelection(anyCaret);
    }

    public void setSelection(int startOffset, int endOffset) {
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myHostModel.setSelection(hostRange.getStartOffset(), hostRange.getEndOffset());
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myHostModel.setSelection(hostRange.getStartOffset(), endPosition, hostRange.getEndOffset());
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myHostModel.setSelection(startPosition, hostRange.getStartOffset(), endPosition, hostRange.getEndOffset());
    }

    public void removeSelection() {
        this.myHostModel.removeSelection();
    }

    public void removeSelection(boolean allCarets) {
        this.myHostModel.removeSelection(allCarets);
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.myHostModel.addSelectionListener(listener2);
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.myHostModel.removeSelectionListener(listener2);
    }

    public void selectLineAtCaret() {
        this.myHostModel.selectLineAtCaret();
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.myHostModel.selectWordAtCaret(honorCamelWordsSettings);
    }

    public void copySelectionToClipboard() {
        this.myHostModel.copySelectionToClipboard();
    }

    public void setBlockSelection(@NotNull LogicalPosition blockStart, @NotNull LogicalPosition blockEnd) {
        if (blockStart == null) {
            SelectionModelWindow.$$$reportNull$$$0(0);
        }
        if (blockEnd == null) {
            SelectionModelWindow.$$$reportNull$$$0(1);
        }
        this.myHostModel.setBlockSelection(this.myInjectedEditor.injectedToHost(blockStart), this.myInjectedEditor.injectedToHost(blockEnd));
    }

    @NotNull
    public int[] getBlockSelectionStarts() {
        int[] result2 = this.myHostModel.getBlockSelectionStarts();
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = this.myDocument.hostToInjected(result2[i]);
        }
        if (result2 == null) {
            SelectionModelWindow.$$$reportNull$$$0(2);
        }
        return result2;
    }

    @NotNull
    public int[] getBlockSelectionEnds() {
        int[] result2 = this.myHostModel.getBlockSelectionEnds();
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = this.myDocument.hostToInjected(result2[i]);
        }
        if (result2 == null) {
            SelectionModelWindow.$$$reportNull$$$0(3);
        }
        return result2;
    }

    public TextAttributes getTextAttributes() {
        return this.myHostModel.getTextAttributes();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStart";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockEnd";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/SelectionModelWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/SelectionModelWindow";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockSelectionStarts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockSelectionEnds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setBlockSelection";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

