/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.mac.touchbar.BarContainer;
import com.intellij.ui.mac.touchbar.BarType;
import com.intellij.ui.mac.touchbar.BuildUtils;
import com.intellij.ui.mac.touchbar.TouchBar;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectData {
    private static final Logger LOG = Logger.getInstance(ProjectData.class);
    @NotNull
    private final Project myProject;
    private final Map<BarType, BarContainer> myPermanentBars;
    private final Map<Editor, EditorData> myEditors;
    private final Map<ToolWindow, ToolWindowData> myToolWindows;
    private AtomicInteger myActiveDebugSessions;

    ProjectData(@NotNull Project project) {
        if (project == null) {
            ProjectData.$$$reportNull$$$0(0);
        }
        this.myPermanentBars = new HashMap<BarType, BarContainer>();
        this.myEditors = new HashMap<Editor, EditorData>();
        this.myToolWindows = new HashMap<ToolWindow, ToolWindowData>();
        this.myActiveDebugSessions = new AtomicInteger(0);
        this.myProject = project;
        this.myProject.getMessageBus().connect().subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (handler2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (ToolWindowId.DEBUG.equals(env.getExecutor().getToolWindowId())) {
                    ProjectData.this.myActiveDebugSessions.incrementAndGet();
                }
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2, int exitCode) {
                int val;
                if (executorId == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (handler2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (ToolWindowId.DEBUG.equals(env.getExecutor().getToolWindowId()) && (val = ProjectData.this.myActiveDebugSessions.decrementAndGet()) < 0) {
                    LOG.error("received 'processTerminated' when no process wasn't started");
                    ProjectData.this.myActiveDebugSessions.incrementAndGet();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/mac/touchbar/ProjectData$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myProject.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            @Override
            public void stateChanged() {
                ToolWindowManagerEx twm = ToolWindowManagerEx.getInstanceEx(ProjectData.this.myProject);
                String activeId = twm.getActiveToolWindowId();
                if (activeId != null && (activeId.equals(ToolWindowId.DEBUG) || activeId.equals(ToolWindowId.RUN_DASHBOARD))) {
                    if (ProjectData.this.getDbgSessions() <= 0) {
                        return;
                    }
                    ProjectData.this.get(BarType.DEBUGGER).show();
                }
            }

            @Override
            public void toolWindowRegistered(@NotNull String id) {
                if (id == null) {
                    2.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().assertIsDispatchThread();
                ToolWindowManagerEx twm = ToolWindowManagerEx.getInstanceEx(ProjectData.this.myProject);
                ToolWindow tw = twm.getToolWindow(id);
                ToolWindowData twd = new ToolWindowData(tw, id);
                ProjectData.this.myToolWindows.put(tw, twd);
                tw.getContentManager().addContentManagerListener((ContentManagerListener)twd);
            }

            @Override
            public void toolWindowUnregistered(@NotNull String id, @NotNull ToolWindow toolWindow) {
                if (id == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (toolWindow == null) {
                    2.$$$reportNull$$$0(2);
                }
                ApplicationManager.getApplication().assertIsDispatchThread();
                if (ProjectData.this.myToolWindows.isEmpty()) {
                    return;
                }
                ToolWindowData removed = (ToolWindowData)ProjectData.this.myToolWindows.remove(toolWindow);
                if (removed == null) {
                    LOG.error("try to remove unregistered tool-window: " + id + ", tw=" + toolWindow);
                    return;
                }
                removed.release();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "id";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "toolWindow";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/mac/touchbar/ProjectData$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toolWindowRegistered";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toolWindowUnregistered";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    boolean isDisposed() {
        return this.myProject.isDisposed();
    }

    @Nullable
    BarContainer get(BarType type) {
        BarContainer result2 = this.myPermanentBars.get((Object)type);
        if (result2 == null) {
            result2 = new BarContainer(type, TouchBar.EMPTY, null, null);
            this._fillBarContainer(result2);
            this.myPermanentBars.put(type, result2);
        }
        return result2;
    }

    boolean checkToolWindowContents(Component child2) {
        for (ToolWindowData twd : this.myToolWindows.values()) {
            ToolWindowData.ContentData cnt = twd.findParentContent(child2);
            if (cnt == null) continue;
            cnt.setContextActionsVisible(true);
            return true;
        }
        return false;
    }

    @Nullable
    EditorData findEditorDataByComponent(Component child2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (EditorData editorData : this.myEditors.values()) {
            JComponent ecmp = editorData.editorHeader;
            if (child2 != ecmp && !SwingUtilities.isDescendingFrom(child2, ecmp) || editorData.containerSearch == null) continue;
            return editorData;
        }
        return null;
    }

    @Nullable
    BarContainer findDebugToolWindowByComponent(Component child2) {
        JComponent compR;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myActiveDebugSessions.get() <= 0) {
            return null;
        }
        ToolWindowManagerEx twm = ToolWindowManagerEx.getInstanceEx(this.myProject);
        if (twm == null) {
            return null;
        }
        ToolWindow dtw = twm.getToolWindow(ToolWindowId.DEBUG);
        ToolWindow rtw = twm.getToolWindow(ToolWindowId.RUN_DASHBOARD);
        JComponent compD = dtw != null ? dtw.getComponent() : null;
        JComponent jComponent = compR = rtw != null ? rtw.getComponent() : null;
        if (compD == null && compR == null) {
            return null;
        }
        if (child2 == compD || child2 == compR || compD != null && SwingUtilities.isDescendingFrom(child2, compD) || compR != null && SwingUtilities.isDescendingFrom(child2, compR)) {
            return this.get(BarType.DEBUGGER);
        }
        return null;
    }

    EditorData registerEditor(@NotNull Editor editor) {
        if (editor == null) {
            ProjectData.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorData result2 = new EditorData(editor);
        this.myEditors.put(editor, result2);
        return result2;
    }

    EditorData getEditorData(@NotNull Editor editor) {
        if (editor == null) {
            ProjectData.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myEditors.get(editor);
    }

    void removeEditor(@NotNull Editor editor) {
        if (editor == null) {
            ProjectData.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myEditors.isEmpty()) {
            return;
        }
        EditorData removed = this.myEditors.remove(editor);
        if (removed == null) {
            return;
        }
        removed.release();
    }

    private void _fillBarContainer(@NotNull BarContainer container) {
        boolean replaceEsc;
        String barId;
        if (container == null) {
            ProjectData.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        BarType type = container.getType();
        if (type == BarType.DEFAULT) {
            barId = "Default";
            replaceEsc = false;
        } else if (type == BarType.DEBUGGER) {
            barId = ToolWindowId.DEBUG;
            replaceEsc = true;
        } else {
            LOG.error("can't create touchbar, unknown context: " + (Object)((Object)type));
            return;
        }
        ActionGroup mainLayout = BuildUtils.getCustomizedGroup(barId);
        if (mainLayout == null) {
            LOG.info("can't create touchbar because corresponding ActionGroup isn't defined (seems that user deleted it), context: " + barId);
            return;
        }
        Map<String, ActionGroup> strmod2alt = BuildUtils.getAltLayouts(mainLayout);
        HashMap<Long, TouchBar> alts = new HashMap<Long, TouchBar>();
        if (strmod2alt != null && !strmod2alt.isEmpty()) {
            for (String modId : strmod2alt.keySet()) {
                long mask = ProjectData._str2mask(modId);
                if (mask == 0L) continue;
                alts.put(mask, TouchBar.buildFromCustomizedGroup(type.name() + "_" + modId, strmod2alt.get(modId), replaceEsc));
            }
        }
        container.set(TouchBar.buildFromCustomizedGroup(type.name(), mainLayout, replaceEsc), alts);
    }

    void releaseAll() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myPermanentBars.forEach((t, bc) -> bc.release());
        this.myPermanentBars.clear();
        this.myEditors.forEach((e, ed) -> ed.release());
        this.myEditors.clear();
        this.myToolWindows.forEach((tw, twd) -> twd.release());
        this.myToolWindows.clear();
    }

    void reloadAll() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myPermanentBars.forEach((t, bc) -> {
            bc.release();
            this._fillBarContainer((BarContainer)bc);
        });
    }

    Collection<BarContainer> getAllContainers() {
        return this.myPermanentBars.values();
    }

    int getDbgSessions() {
        return this.myActiveDebugSessions.get();
    }

    static long getUsedKeyMask() {
        return 960L;
    }

    private static long _str2mask(@NotNull String modifierId) {
        if (modifierId == null) {
            ProjectData.$$$reportNull$$$0(5);
        }
        if (!modifierId.contains(".")) {
            if (modifierId.equalsIgnoreCase("alt")) {
                return 512L;
            }
            if (modifierId.equalsIgnoreCase("cmd")) {
                return 256L;
            }
            if (modifierId.equalsIgnoreCase("ctrl")) {
                return 128L;
            }
            if (modifierId.equalsIgnoreCase("shift")) {
                return 64L;
            }
            return 0L;
        }
        String[] spl = modifierId.split("\\.");
        if (spl == null) {
            return 0L;
        }
        long mask = 0L;
        for (String sub : spl) {
            mask |= ProjectData._str2mask(sub);
        }
        return mask;
    }

    private static ActionGroup _getTouchbarActions(Content content) {
        JComponent component = content.getComponent();
        return ProjectData._getTouchbarActions(component);
    }

    private static ActionGroup _getTouchbarActions(Component component) {
        return component instanceof DataProvider ? (ActionGroup)TouchbarDataKeys.ACTIONS_KEY.getData((DataProvider)component) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/mac/touchbar/ProjectData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "_fillBarContainer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "_str2mask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    class ToolWindowData
    implements ContentManagerListener {
        @NotNull
        final ToolWindow toolWindow;
        @NotNull
        final String toolWindowId;
        @NotNull
        final Map<Content, ContentData> contents;

        ToolWindowData(@NotNull ToolWindow toolWindow, String toolWindowId) {
            if (toolWindow == null) {
                ToolWindowData.$$$reportNull$$$0(0);
            }
            if (toolWindowId == null) {
                ToolWindowData.$$$reportNull$$$0(1);
            }
            this.contents = new HashMap<Content, ContentData>();
            this.toolWindow = toolWindow;
            this.toolWindowId = toolWindowId;
        }

        void release() {
        }

        @Nullable
        ContentData findParentContent(@NotNull Component childOfToolWindow) {
            if (childOfToolWindow == null) {
                ToolWindowData.$$$reportNull$$$0(2);
            }
            if (this.contents.isEmpty()) {
                return null;
            }
            for (ContentData cd : this.contents.values()) {
                if (!SwingUtilities.isDescendingFrom(childOfToolWindow, cd.content.getComponent())) continue;
                return cd;
            }
            return null;
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            if (event == null) {
                ToolWindowData.$$$reportNull$$$0(3);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            Content content = event.getContent();
            ContentData cd = this.contents.get(content);
            if (cd != null) {
                LOG.error("try to register existing content '" + content + "', will be skipped");
                return;
            }
            ActionGroup optAction = ProjectData._getTouchbarActions(content);
            if (optAction == null) {
                return;
            }
            this._registerContent(content, optAction);
            content.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("component".equals(evt.getPropertyName())) {
                        // empty if block
                    }
                }
            });
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            if (event == null) {
                ToolWindowData.$$$reportNull$$$0(4);
            }
            this._removeContent(event.getContent());
        }

        public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
            if (event == null) {
                ToolWindowData.$$$reportNull$$$0(5);
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            if (event == null) {
                ToolWindowData.$$$reportNull$$$0(6);
            }
        }

        private void _registerContent(@NotNull Content content, @NotNull ActionGroup optActions) {
            if (content == null) {
                ToolWindowData.$$$reportNull$$$0(7);
            }
            if (optActions == null) {
                ToolWindowData.$$$reportNull$$$0(8);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            ContentData cd = this.contents.get(content);
            if (cd != null) {
                LOG.error("try to register existing content '" + content + "' of ToolWindow " + this.toolWindowId + ", will be skipped");
                return;
            }
            cd = new ContentData(content, ProjectData.this.get(BarType.DEFAULT));
            this.contents.put(content, cd);
            cd.setOptionalContextActions(optActions);
        }

        private void _removeContent(@NotNull Content content) {
            if (content == null) {
                ToolWindowData.$$$reportNull$$$0(9);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            ContentData cd = this.contents.get(content);
            if (cd == null) {
                return;
            }
            this.contents.remove(cd);
            cd.setOptionalContextActions(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindowId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childOfToolWindow";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optActions";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/mac/touchbar/ProjectData$ToolWindowData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findParentContent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentAdded";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoveQuery";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "_registerContent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "_removeContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class ContentData {
            @NotNull
            final Content content;
            @NotNull
            final BarContainer barContainer;
            @NotNull
            final String contextName;

            ContentData(@NotNull Content content, BarContainer barContainer) {
                if (content == null) {
                    ContentData.$$$reportNull$$$0(0);
                }
                if (barContainer == null) {
                    ContentData.$$$reportNull$$$0(1);
                }
                this.content = content;
                this.barContainer = barContainer;
                this.contextName = ToolWindowData.this.toolWindowId + "_" + content.toString();
            }

            void setOptionalContextActions(ActionGroup group) {
                this.barContainer.setOptionalContextActions(group, this.contextName);
            }

            void setContextActionsVisible(boolean visible) {
                this.barContainer.setOptionalContextVisible(visible ? this.contextName : null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "content";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "barContainer";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/mac/touchbar/ProjectData$ToolWindowData$ContentData";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    static class EditorData {
        @NotNull
        final Editor editor;
        JComponent editorHeader;
        ActionGroup actionsSearch;
        BarContainer containerSearch;

        EditorData(Editor editor) {
            this.editor = editor;
        }

        void release() {
            if (this.containerSearch != null) {
                this.containerSearch.release();
            }
            this.containerSearch = null;
        }
    }
}

