/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogDateFilterImpl;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogFileFilter;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.impl.VcsLogHashFilterImpl;
import com.intellij.vcs.log.impl.VcsLogRootFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUserFilterImpl;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.filter.BranchFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.DateFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.StructureFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.UserFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogClassicFilterUi
implements VcsLogFilterUi {
    private static final String VCS_LOG_TEXT_FILTER_HISTORY = "Vcs.Log.Text.Filter.History";
    private static final String HASH_PATTERN = "[a-fA-F0-9]{7,}";
    private static final Logger LOG = Logger.getInstance(VcsLogClassicFilterUi.class);
    @NotNull
    private final VcsLogUiImpl myUi;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private VcsLogDataPack myDataPack;
    @NotNull
    private final BranchFilterModel myBranchFilterModel;
    @NotNull
    private final FilterModel<VcsLogUserFilter> myUserFilterModel;
    @NotNull
    private final FilterModel<VcsLogDateFilter> myDateFilterModel;
    @NotNull
    private final FilterModel<VcsLogFileFilter> myStructureFilterModel;
    @NotNull
    private final TextFilterModel myTextFilterModel;

    public VcsLogClassicFilterUi(@NotNull VcsLogUiImpl ui, @NotNull VcsLogData logData, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogDataPack initialDataPack) {
        if (ui == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(2);
        }
        if (initialDataPack == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(3);
        }
        this.myUi = ui;
        this.myLogData = logData;
        this.myUiProperties = uiProperties;
        this.myDataPack = initialDataPack;
        NotNullComputable dataPackGetter = () -> this.myDataPack;
        this.myBranchFilterModel = new BranchFilterModel((Computable<? extends VcsLogDataPack>)dataPackGetter, this.myUiProperties);
        this.myUserFilterModel = new UserFilterModel((NotNullComputable<VcsLogDataPack>)dataPackGetter, this.myUiProperties);
        this.myDateFilterModel = new DateFilterModel((NotNullComputable<VcsLogDataPack>)dataPackGetter, this.myUiProperties);
        this.myStructureFilterModel = new FileFilterModel((NotNullComputable<VcsLogDataPack>)dataPackGetter, this.myLogData.getLogProviders().keySet(), this.myUiProperties);
        this.myTextFilterModel = new TextFilterModel((NotNullComputable<VcsLogDataPack>)dataPackGetter, this.myUiProperties);
        this.updateUiOnFilterChange();
        this.myUi.applyFiltersAndUpdateUi(this.getFilters());
    }

    private void updateUiOnFilterChange() {
        FilterModel[] models;
        for (FilterModel model : models = new FilterModel[]{this.myBranchFilterModel, this.myUserFilterModel, this.myDateFilterModel, this.myStructureFilterModel, this.myTextFilterModel}) {
            model.addSetFilterListener(() -> {
                this.myUi.applyFiltersAndUpdateUi(this.getFilters());
                this.myBranchFilterModel.onStructureFilterChanged(new HashSet<VirtualFile>(this.myLogData.getRoots()), this.myStructureFilterModel.getFilter());
            });
        }
    }

    public void updateDataPack(@NotNull VcsLogDataPack dataPack) {
        if (dataPack == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(4);
        }
        this.myDataPack = dataPack;
    }

    @NotNull
    public SearchTextField createTextFilter() {
        TextFilterField textFilterField = new TextFilterField(this.myTextFilterModel);
        if (textFilterField == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(5);
        }
        return textFilterField;
    }

    @NotNull
    public ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new FilterActionComponent((Computable<JComponent>)((Computable)() -> new BranchFilterPopupComponent(this.myUiProperties, this.myBranchFilterModel).initUi())));
        actionGroup.add((AnAction)new FilterActionComponent((Computable<JComponent>)((Computable)() -> new UserFilterPopupComponent(this.myUiProperties, this.myLogData, this.myUserFilterModel).initUi())));
        actionGroup.add((AnAction)new FilterActionComponent((Computable<JComponent>)((Computable)() -> new DateFilterPopupComponent(this.myDateFilterModel).initUi())));
        actionGroup.add((AnAction)new FilterActionComponent((Computable<JComponent>)((Computable)() -> new StructureFilterPopupComponent(this.myUiProperties, this.myStructureFilterModel, this.myUi.getColorManager()).initUi())));
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(6);
        }
        return defaultActionGroup;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Pair<VcsLogTextFilter, VcsLogHashFilter> filtersFromText = VcsLogClassicFilterUi.getFiltersFromTextArea((VcsLogTextFilter)this.myTextFilterModel.getFilter(), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_REGEX), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE));
        VcsLogFilterCollection vcsLogFilterCollection = new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder().with((VcsLogFilter)this.myBranchFilterModel.getFilter()).with((VcsLogFilter)this.myUserFilterModel.getFilter()).with((VcsLogFilter)filtersFromText.second).with((VcsLogFilter)this.myDateFilterModel.getFilter()).with((VcsLogFilter)filtersFromText.first).with((VcsLogFilter)(this.myStructureFilterModel.getFilter() == null ? null : this.myStructureFilterModel.getFilter().getStructureFilter())).with((VcsLogFilter)(this.myStructureFilterModel.getFilter() == null ? null : this.myStructureFilterModel.getFilter().getRootFilter())).build();
        if (vcsLogFilterCollection == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(7);
        }
        return vcsLogFilterCollection;
    }

    @NotNull
    private static Pair<VcsLogTextFilter, VcsLogHashFilter> getFiltersFromTextArea(@Nullable VcsLogTextFilter filter, boolean isRegexAllowed, boolean matchesCase) {
        if (filter == null) {
            Pair pair = Pair.empty();
            if (pair == null) {
                VcsLogClassicFilterUi.$$$reportNull$$$0(8);
            }
            return pair;
        }
        String text = filter.getText().trim();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            Pair pair = Pair.empty();
            if (pair == null) {
                VcsLogClassicFilterUi.$$$reportNull$$$0(9);
            }
            return pair;
        }
        VcsLogTextFilter textFilter = VcsLogTextFilterImpl.createTextFilter(text, isRegexAllowed, matchesCase);
        VcsLogHashFilterImpl hashFilter = VcsLogClassicFilterUi.createHashFilter(text);
        Pair pair = Pair.create((Object)textFilter, (Object)hashFilter);
        if (pair == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(10);
        }
        return pair;
    }

    @Nullable
    private static VcsLogHashFilterImpl createHashFilter(@NotNull String text) {
        if (text == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(11);
        }
        ArrayList hashes = ContainerUtil.newArrayList();
        for (String word : StringUtil.split((String)text, (String)" ")) {
            if (!word.matches(HASH_PATTERN)) {
                return null;
            }
            hashes.add(word);
        }
        if (hashes.isEmpty()) {
            return null;
        }
        return new VcsLogHashFilterImpl(hashes);
    }

    public void setFilter(@Nullable VcsLogFilter filter) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (filter == null) {
            this.myBranchFilterModel.setFilter(null);
            this.myStructureFilterModel.setFilter(null);
            this.myDateFilterModel.setFilter(null);
            this.myTextFilterModel.setFilter((VcsLogTextFilter)null);
            this.myUserFilterModel.setFilter(null);
        } else if (filter instanceof VcsLogBranchFilter) {
            this.myBranchFilterModel.setFilter((VcsLogBranchFilter)filter);
        } else if (filter instanceof VcsLogStructureFilter) {
            this.myStructureFilterModel.setFilter(new VcsLogFileFilter((VcsLogStructureFilter)filter, null));
        }
        JComponent toolbar = this.myUi.getToolbar();
        toolbar.revalidate();
        toolbar.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialDataPack";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextFilter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionGroup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiltersFromTextArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateDataPack";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createHashFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TextFilterField
    extends SearchTextField {
        @NotNull
        private final TextFilterModel myTextFilterModel;

        TextFilterField(@NotNull TextFilterModel model) {
            if (model == null) {
                TextFilterField.$$$reportNull$$$0(0);
            }
            super(VcsLogClassicFilterUi.VCS_LOG_TEXT_FILTER_HISTORY);
            this.myTextFilterModel = model;
            this.setText(this.myTextFilterModel.getText());
            this.getTextEditor().addActionListener(e -> this.applyFilter());
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        myTextFilterModel.setUnsavedText(e.getDocument().getText(0, e.getDocument().getLength()));
                    }
                    catch (BadLocationException ex) {
                        LOG.error((Throwable)ex);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterField$1", "textChanged"));
                }
            });
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"Vcs.Log.FocusTextFilter");
            if (!shortcutText.isEmpty()) {
                this.getTextEditor().setToolTipText("Use " + shortcutText + " to switch between text filter and commits list");
            }
        }

        protected void applyFilter() {
            boolean isRegexpAllowed = this.myTextFilterModel.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_REGEX);
            boolean isMatchCase = this.myTextFilterModel.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE);
            this.myTextFilterModel.setFilter(VcsLogTextFilterImpl.createTextFilter(this.getText(), isRegexpAllowed, isMatchCase));
            this.addCurrentTextToHistory();
        }

        protected void onFieldCleared() {
            this.myTextFilterModel.setFilter((VcsLogTextFilter)null);
        }

        protected void onFocusLost() {
            if (this.myTextFilterModel.hasUnsavedChanges()) {
                this.applyFilter();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterField", "<init>"));
        }
    }

    private class UserFilterModel
    extends FilterModel<VcsLogUserFilter> {
        UserFilterModel(NotNullComputable<VcsLogDataPack> dataPackGetter, MainVcsLogUiProperties uiProperties) {
            super("user", (Computable<? extends VcsLogDataPack>)dataPackGetter, uiProperties);
        }

        @Override
        @NotNull
        protected VcsLogUserFilter createFilter(@NotNull List<String> values) {
            if (values == null) {
                UserFilterModel.$$$reportNull$$$0(0);
            }
            VcsLogUserFilterImpl vcsLogUserFilterImpl = new VcsLogUserFilterImpl(values, VcsLogClassicFilterUi.this.myLogData.getCurrentUser(), VcsLogClassicFilterUi.this.myLogData.getAllUsers());
            if (vcsLogUserFilterImpl == null) {
                UserFilterModel.$$$reportNull$$$0(1);
            }
            return vcsLogUserFilterImpl;
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogUserFilter filter) {
            if (filter == null) {
                UserFilterModel.$$$reportNull$$$0(2);
            }
            ArrayList arrayList = ContainerUtil.newArrayList(((VcsLogUserFilterImpl)filter).getUserNamesForPresentation());
            if (arrayList == null) {
                UserFilterModel.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$UserFilterModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$UserFilterModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFilter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilterValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilterValues";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DateFilterModel
    extends FilterModel<VcsLogDateFilter> {
        DateFilterModel(NotNullComputable<VcsLogDataPack> dataPackGetter, MainVcsLogUiProperties uiProperties) {
            super("date", (Computable<? extends VcsLogDataPack>)dataPackGetter, uiProperties);
        }

        @Override
        @Nullable
        protected VcsLogDateFilter createFilter(@NotNull List<String> values) {
            if (values == null) {
                DateFilterModel.$$$reportNull$$$0(0);
            }
            if (values.size() != 2) {
                LOG.warn("Can not create date filter from " + values + " before and after dates are required.");
                return null;
            }
            String after2 = values.get(0);
            String before = values.get(1);
            try {
                return new VcsLogDateFilterImpl(after2.isEmpty() ? null : new Date(Long.parseLong(after2)), before.isEmpty() ? null : new Date(Long.parseLong(before)));
            }
            catch (NumberFormatException e) {
                LOG.warn("Can not create date filter from " + values);
                return null;
            }
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogDateFilter filter) {
            if (filter == null) {
                DateFilterModel.$$$reportNull$$$0(1);
            }
            Date after2 = filter.getAfter();
            Date before = filter.getBefore();
            List<String> list2 = Arrays.asList(after2 == null ? "" : Long.toString(after2.getTime()), before == null ? "" : Long.toString(before.getTime()));
            if (list2 == null) {
                DateFilterModel.$$$reportNull$$$0(2);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$DateFilterModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$DateFilterModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilterValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilterValues";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class FileFilterModel
    extends FilterModel<VcsLogFileFilter> {
        @NotNull
        private static final String ROOTS = "roots";
        @NotNull
        private static final String STRUCTURE = "structure";
        @NotNull
        private static final String DIR = "dir:";
        @NotNull
        private static final String FILE = "file:";
        @NotNull
        private final Set<VirtualFile> myRoots;

        FileFilterModel(NotNullComputable<VcsLogDataPack> dataPackGetter, @NotNull Set<VirtualFile> roots, MainVcsLogUiProperties uiProperties) {
            if (roots == null) {
                FileFilterModel.$$$reportNull$$$0(0);
            }
            super("file", (Computable<? extends VcsLogDataPack>)dataPackGetter, uiProperties);
            this.myRoots = roots;
        }

        @Override
        protected void saveFilter(@Nullable VcsLogFileFilter filter) {
            if (filter == null) {
                this.myUiProperties.saveFilterValues(ROOTS, null);
                this.myUiProperties.saveFilterValues(STRUCTURE, null);
            } else if (filter.getStructureFilter() != null) {
                this.myUiProperties.saveFilterValues(STRUCTURE, FileFilterModel.getFilterValues(filter.getStructureFilter()));
            } else if (filter.getRootFilter() != null) {
                this.myUiProperties.saveFilterValues(ROOTS, FileFilterModel.getFilterValues(filter.getRootFilter()));
            }
        }

        @NotNull
        static List<String> getFilterValues(@NotNull VcsLogStructureFilter filter) {
            if (filter == null) {
                FileFilterModel.$$$reportNull$$$0(1);
            }
            List list2 = ContainerUtil.map((Collection)filter.getFiles(), path -> (path.isDirectory() ? DIR : FILE) + path.getPath());
            if (list2 == null) {
                FileFilterModel.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @NotNull
        private static List<String> getFilterValues(@NotNull VcsLogRootFilter filter) {
            if (filter == null) {
                FileFilterModel.$$$reportNull$$$0(3);
            }
            List list2 = ContainerUtil.map((Collection)filter.getRoots(), VirtualFile::getPath);
            if (list2 == null) {
                FileFilterModel.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @NotNull
        static VcsLogStructureFilter createStructureFilter(@NotNull List<String> values) {
            if (values == null) {
                FileFilterModel.$$$reportNull$$$0(5);
            }
            VcsLogStructureFilterImpl vcsLogStructureFilterImpl = new VcsLogStructureFilterImpl(ContainerUtil.map(values, path -> {
                if (path.startsWith(DIR)) {
                    return VcsUtil.getFilePath((String)path.substring(DIR.length()), (boolean)true);
                }
                if (path.startsWith(FILE)) {
                    return VcsUtil.getFilePath((String)path.substring(FILE.length()), (boolean)false);
                }
                return VcsUtil.getFilePath((String)path);
            }));
            if (vcsLogStructureFilterImpl == null) {
                FileFilterModel.$$$reportNull$$$0(6);
            }
            return vcsLogStructureFilterImpl;
        }

        @Override
        @Nullable
        protected VcsLogFileFilter getLastFilter() {
            List<String> values = this.myUiProperties.getFilterValues(STRUCTURE);
            if (values != null) {
                return new VcsLogFileFilter(FileFilterModel.createStructureFilter(values), null);
            }
            values = this.myUiProperties.getFilterValues(ROOTS);
            if (values != null) {
                return new VcsLogFileFilter(null, this.createRootsFilter(values));
            }
            return null;
        }

        @Nullable
        private VcsLogRootFilter createRootsFilter(@NotNull List<String> values) {
            if (values == null) {
                FileFilterModel.$$$reportNull$$$0(7);
            }
            ArrayList selectedRoots = ContainerUtil.newArrayList();
            for (String path : values) {
                VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path);
                if (root != null) {
                    if (this.myRoots.contains(root)) {
                        selectedRoots.add(root);
                        continue;
                    }
                    LOG.warn("Can not find VCS root for filtering " + root);
                    continue;
                }
                LOG.warn("Can not filter by file that does not exist " + path);
            }
            if (selectedRoots.isEmpty()) {
                return null;
            }
            return new VcsLogRootFilterImpl(selectedRoots);
        }

        @Override
        @NotNull
        protected VcsLogFileFilter createFilter(@NotNull List<String> values) {
            if (values == null) {
                FileFilterModel.$$$reportNull$$$0(8);
            }
            throw new UnsupportedOperationException("Can not create file filter from list of strings");
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogFileFilter filter) {
            if (filter == null) {
                FileFilterModel.$$$reportNull$$$0(9);
            }
            throw new UnsupportedOperationException("Can not save file filter to a list of strings");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ROOTS;
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel";
                    break;
                }
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilterValues";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStructureFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilterValues";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createStructureFilter";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createRootsFilter";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TextFilterModel
    extends FilterModel<VcsLogTextFilter> {
        @Nullable
        private String myText;

        TextFilterModel(NotNullComputable<VcsLogDataPack> dataPackProvider, @NotNull MainVcsLogUiProperties properties) {
            if (properties == null) {
                TextFilterModel.$$$reportNull$$$0(0);
            }
            super("text", (Computable<? extends VcsLogDataPack>)dataPackProvider, properties);
        }

        @NotNull
        String getText() {
            if (this.myText != null) {
                String string = this.myText;
                if (string == null) {
                    TextFilterModel.$$$reportNull$$$0(1);
                }
                return string;
            }
            if (this.getFilter() != null) {
                String string = ((VcsLogTextFilter)this.getFilter()).getText();
                if (string == null) {
                    TextFilterModel.$$$reportNull$$$0(2);
                }
                return string;
            }
            if ("" == null) {
                TextFilterModel.$$$reportNull$$$0(3);
            }
            return "";
        }

        void setUnsavedText(@NotNull String text) {
            if (text == null) {
                TextFilterModel.$$$reportNull$$$0(4);
            }
            this.myText = text;
        }

        boolean hasUnsavedChanges() {
            if (this.myText == null) {
                return false;
            }
            return this.getFilter() == null || !this.myText.equals(((VcsLogTextFilter)this.getFilter()).getText());
        }

        @Override
        void setFilter(@Nullable VcsLogTextFilter filter) {
            super.setFilter(filter);
            this.myText = null;
        }

        @Override
        @NotNull
        protected VcsLogTextFilter createFilter(@NotNull List<String> values) {
            if (values == null) {
                TextFilterModel.$$$reportNull$$$0(5);
            }
            VcsLogTextFilter vcsLogTextFilter = VcsLogTextFilterImpl.createTextFilter((String)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(values)), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_REGEX), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE));
            if (vcsLogTextFilter == null) {
                TextFilterModel.$$$reportNull$$$0(6);
            }
            return vcsLogTextFilter;
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogTextFilter filter) {
            if (filter == null) {
                TextFilterModel.$$$reportNull$$$0(7);
            }
            List<String> list2 = Collections.singletonList(filter.getText());
            if (list2 == null) {
                TextFilterModel.$$$reportNull$$$0(8);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFilter";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilterValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setUnsavedText";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilterValues";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BranchFilterModel
    extends FilterModel<VcsLogBranchFilter> {
        @Nullable
        private Collection<VirtualFile> myVisibleRoots;

        BranchFilterModel(@NotNull Computable<? extends VcsLogDataPack> provider, @NotNull MainVcsLogUiProperties properties) {
            if (provider == null) {
                BranchFilterModel.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                BranchFilterModel.$$$reportNull$$$0(1);
            }
            super("branch", provider, properties);
        }

        public void onStructureFilterChanged(@NotNull Set<VirtualFile> roots, @Nullable VcsLogFileFilter filter) {
            if (roots == null) {
                BranchFilterModel.$$$reportNull$$$0(2);
            }
            this.myVisibleRoots = filter == null ? null : VcsLogUtil.getAllVisibleRoots(roots, filter.getRootFilter(), filter.getStructureFilter());
        }

        @Nullable
        public Collection<VirtualFile> getVisibleRoots() {
            return this.myVisibleRoots;
        }

        @Override
        @NotNull
        protected VcsLogBranchFilter createFilter(@NotNull List<String> values) {
            if (values == null) {
                BranchFilterModel.$$$reportNull$$$0(3);
            }
            VcsLogBranchFilterImpl vcsLogBranchFilterImpl = VcsLogBranchFilterImpl.fromTextPresentation(values, ContainerUtil.map2Set((Collection)this.getDataPack().getRefs().getBranches(), VcsRef::getName));
            if (vcsLogBranchFilterImpl == null) {
                BranchFilterModel.$$$reportNull$$$0(4);
            }
            return vcsLogBranchFilterImpl;
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogBranchFilter filter) {
            if (filter == null) {
                BranchFilterModel.$$$reportNull$$$0(5);
            }
            ArrayList arrayList = ContainerUtil.newArrayList((Iterable)ContainerUtil.sorted((Collection)filter.getTextPresentation()));
            if (arrayList == null) {
                BranchFilterModel.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$BranchFilterModel";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$BranchFilterModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFilter";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilterValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "onStructureFilterChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilterValues";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FilterActionComponent
    extends DumbAwareAction
    implements CustomComponentAction {
        @NotNull
        private final Computable<JComponent> myComponentCreator;

        FilterActionComponent(@NotNull Computable<JComponent> componentCreator) {
            if (componentCreator == null) {
                FilterActionComponent.$$$reportNull$$$0(0);
            }
            this.myComponentCreator = componentCreator;
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation) {
            if (presentation == null) {
                FilterActionComponent.$$$reportNull$$$0(1);
            }
            JComponent jComponent = (JComponent)this.myComponentCreator.compute();
            if (jComponent == null) {
                FilterActionComponent.$$$reportNull$$$0(2);
            }
            return jComponent;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                FilterActionComponent.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentCreator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FilterActionComponent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FilterActionComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

