/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.formatting.WrapType;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import java.io.Serializable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public abstract class CodeStyleBean
implements Serializable {
    @NotNull
    private CodeStyleSettings myRootSettings = new CodeStyleSettings();

    public void setRootSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleBean.$$$reportNull$$$0(0);
        }
        this.myRootSettings = settings;
    }

    @NotNull
    protected abstract Language getLanguage();

    public int getRightMargin() {
        return this.myRootSettings.getRightMargin(this.getLanguage());
    }

    public void setRightMargin(int rightMargin) {
        this.myRootSettings.setRightMargin(this.getLanguage(), rightMargin);
    }

    @NotNull
    public CommonCodeStyleSettings.WrapOnTyping getWrapOnTyping() {
        for (CommonCodeStyleSettings.WrapOnTyping c : CommonCodeStyleSettings.WrapOnTyping.values()) {
            if (c.intValue != this.getCommonSettings().WRAP_ON_TYPING) continue;
            CommonCodeStyleSettings.WrapOnTyping wrapOnTyping = c;
            if (wrapOnTyping == null) {
                CodeStyleBean.$$$reportNull$$$0(1);
            }
            return wrapOnTyping;
        }
        CommonCodeStyleSettings.WrapOnTyping wrapOnTyping = CommonCodeStyleSettings.WrapOnTyping.NO_WRAP;
        if (wrapOnTyping == null) {
            CodeStyleBean.$$$reportNull$$$0(2);
        }
        return wrapOnTyping;
    }

    public void setWrapOnTyping(@NotNull CommonCodeStyleSettings.WrapOnTyping value) {
        if (value == null) {
            CodeStyleBean.$$$reportNull$$$0(3);
        }
        this.getCommonSettings().WRAP_ON_TYPING = value.intValue;
    }

    @NotNull
    protected final CommonCodeStyleSettings getCommonSettings() {
        CommonCodeStyleSettings commonCodeStyleSettings = this.myRootSettings.getCommonSettings(this.getLanguage());
        if (commonCodeStyleSettings == null) {
            CodeStyleBean.$$$reportNull$$$0(4);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    protected final CommonCodeStyleSettings.IndentOptions getIndentOptions(boolean isWritable) {
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getCommonSettings().getIndentOptions();
        if (indentOptions == null && isWritable) {
            indentOptions = this.getCommonSettings().initIndentOptions();
        }
        CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions != null ? indentOptions : this.myRootSettings.OTHER_INDENT_OPTIONS;
        if (indentOptions2 == null) {
            CodeStyleBean.$$$reportNull$$$0(5);
        }
        return indentOptions2;
    }

    @NotNull
    protected final <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull Class<T> settingsClass) {
        if (settingsClass == null) {
            CodeStyleBean.$$$reportNull$$$0(6);
        }
        T t = this.myRootSettings.getCustomSettings(settingsClass);
        if (t == null) {
            CodeStyleBean.$$$reportNull$$$0(7);
        }
        return t;
    }

    protected static WrapType intToWrapType(int wrap) {
        return WrapType.byLegacyRepresentation(wrap);
    }

    protected static int wrapTypeToInt(@NotNull WrapType wrapType) {
        if (wrapType == null) {
            CodeStyleBean.$$$reportNull$$$0(8);
        }
        return wrapType.getLegacyRepresentation();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyleBean";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyleBean";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapOnTyping";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setRootSettings";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setWrapOnTyping";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "wrapTypeToInt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

