/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreterType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WslCommandLineConfigurator
extends NodeCommandLineConfigurator {
    private static final Key<Boolean> WSL_FLAG = Key.create((String)"WSL_FLAG");
    private static final String WSLENV = "WSLENV";
    private static final String PATH = "PATH";
    private final WslNodeInterpreter myInterpreter;

    public WslCommandLineConfigurator(WslNodeInterpreter interpreter) {
        this.myInterpreter = interpreter;
    }

    @Override
    public void configure(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(0);
        }
        if (!WslNodeInterpreterType.getInstance().isAvailable()) {
            throw new ExecutionException("WSL is not available");
        }
        WSLDistribution distribution = this.myInterpreter.getDistribution();
        if (distribution == null) {
            throw new ExecutionException("WSL " + this.myInterpreter.getWslDistributionId() + " is not available");
        }
        commandLine.setExePath(this.myInterpreter.getWslInterpreterPath());
        List parameters = commandLine.getParametersList().getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            String wslPath;
            String value = (String)parameters.get(i);
            if (!WslCommandLineConfigurator.isWindowsAbsolutePath(value) || (wslPath = distribution.getWslPath(value)) == null) continue;
            commandLine.getParametersList().set(i, wslPath);
        }
        HashMap envs = new HashMap(commandLine.getEnvironment());
        commandLine.getEnvironment().clear();
        this.fixPathIfNeeded(commandLine);
        commandLine = distribution.patchCommandLine(commandLine, null, null, false);
        commandLine.getEnvironment().clear();
        commandLine.getEnvironment().putAll(envs);
        WslCommandLineConfigurator.setWSLENV(commandLine);
        commandLine.putUserData(WSL_FLAG, (Object)true);
    }

    @Override
    public String convertLocalPathToRemote(@NotNull String localPath) {
        if (localPath == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(1);
        }
        return NodeInterpreterUtil.convertLocalPathToRemote(localPath, this.myInterpreter);
    }

    private static boolean isWindowsAbsolutePath(@NotNull String value) {
        if (value == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(2);
        }
        return FileUtil.isWindowsAbsolutePath((String)value) && value.length() >= 3 && StringUtil.containsChar((String)"/\\", (char)value.charAt(2));
    }

    private void fixPathIfNeeded(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(3);
        }
        String defaultPath2 = "/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/games:/usr/local/games";
        String binDir = PathUtil.getParentPath((String)this.myInterpreter.getWslInterpreterPath());
        if (!StringUtil.split((String)defaultPath2, (String)":").contains(binDir)) {
            String prevPath = "$PATH";
            if ("UBUNTU_LEGACY".equals(this.myInterpreter.getWslDistributionId())) {
                prevPath = "'" + prevPath + "'";
            }
            commandLine.getEnvironment().put(PATH, PathUtil.getParentPath((String)this.myInterpreter.getWslInterpreterPath()) + ":" + prevPath);
        }
    }

    private static void setWSLENV(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(4);
        }
        StringBuilder builder = new StringBuilder();
        for (String envName : commandLine.getEnvironment().keySet()) {
            if (!StringUtil.isNotEmpty((String)envName)) continue;
            if (builder.length() > 0) {
                builder.append(":");
            }
            builder.append(envName).append("/u");
        }
        if (builder.length() > 0) {
            String prevValue = (String)commandLine.getParentEnvironment().get(WSLENV);
            String value = prevValue != null ? StringUtil.trimEnd((String)prevValue, (char)':') + ':' + builder.toString() : builder.toString();
            commandLine.getEnvironment().put(WSLENV, value);
        }
    }

    public static boolean isWslConfigured(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(5);
        }
        return commandLine.getUserData(WSL_FLAG) == Boolean.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/wsl/WslCommandLineConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "convertLocalPathToRemote";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isWindowsAbsolutePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fixPathIfNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setWSLENV";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isWslConfigured";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

