/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.parsing.JSParser;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentImpl;
import com.intellij.lang.javascript.types.PsiGenerator;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;

public class JavascriptParserDefinition
implements ParserDefinition {
    private static Function<? super IElementType, ? extends ASTNode> ourGwtReferenceExpressionCreator;

    @NotNull
    public Lexer createLexer(Project project) {
        JSFlexAdapter jSFlexAdapter = new JSFlexAdapter(JavascriptLanguage.E4X_OPTION_HOLDER);
        if (jSFlexAdapter == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(0);
        }
        return jSFlexAdapter;
    }

    public IFileElementType getFileNodeType() {
        return JSStubElementTypes.FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = JSTokenTypes.PARSER_WHITE_SPACE_TOKENS;
        if (tokenSet == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = JSTokenTypes.COMMENTS;
        if (tokenSet == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = JSTokenTypes.STRING_LITERALS;
        if (tokenSet == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        JSParser jSParser = new JSParser(null);
        if (jSParser == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(4);
        }
        return jSParser;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new JSFileImpl(viewProvider, this.getFileNodeType().getLanguage());
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        if (left instanceof PsiWhiteSpace) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        if (left.getElementType() == JSTokenTypes.BACKQUOTE) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        Lexer lexer = this.createLexer(left.getPsi().getProject());
        return LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)lexer);
    }

    public static void setGwtReferenceExpressionCreator(Function<? super IElementType, ? extends ASTNode> gwtReferenceExpressionCreator) {
        ourGwtReferenceExpressionCreator = gwtReferenceExpressionCreator;
    }

    public static ASTNode createGwtReferenceExpression(IElementType type) {
        return (ASTNode)ourGwtReferenceExpressionCreator.fun((Object)type);
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement element;
        IElementType type = node.getElementType();
        if (JSElementTypes.XML_LITERAL_EXPRESSION == type) {
            if (!(node instanceof PsiElement)) {
                throw new AssertionError((Object)("Literal must be PsiElement but was: " + node + " (" + node.getClass() + ")"));
            }
            PsiElement psiElement = (PsiElement)node;
            if (psiElement == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        if (type instanceof PsiGenerator && (element = ((PsiGenerator)type).construct(node)) != null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(6);
            }
            return psiElement;
        }
        if (type == JSTokenTypes.DOC_COMMENT) {
            JSDocCommentImpl jSDocCommentImpl = new JSDocCommentImpl(node);
            if (jSDocCommentImpl == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(7);
            }
            return jSDocCommentImpl;
        }
        ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(node);
        if (aSTWrapperPsiElement == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(8);
        }
        return aSTWrapperPsiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/JavascriptParserDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createParser";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

