/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.ES6CreateConstructorFix;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6CreateClassOrInterfaceFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myTargetName;
    private final boolean myIsInterface;
    @Nullable
    private final JSType myExpectedType;
    @Nullable
    private final SmartPsiElementPointer<JSArgumentList> myConstructorArguments;
    private final boolean myTargetNameIsQualified;

    public ES6CreateClassOrInterfaceFix(@NotNull PsiElement expression, boolean isInterface, @Nullable JSArgumentList constructorArguments, @Nullable JSType expectedType) {
        if (expression == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(0);
        }
        super(expression);
        String expressionText = expression instanceof ES6ImportExportDeclarationPart ? JSReferenceChecker.getNameToCreate((ES6ImportExportDeclarationPart)expression) : expression.getText();
        this.myTargetNameIsQualified = expressionText.indexOf(46) > 0;
        this.myTargetName = this.myTargetNameIsQualified ? expressionText.substring(expressionText.lastIndexOf(46) + 1) : expressionText;
        this.myIsInterface = isInterface;
        this.myExpectedType = expectedType;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)expression.getProject());
        this.myConstructorArguments = constructorArguments != null ? smartPointerManager.createSmartPsiElementPointer((PsiElement)constructorArguments) : null;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(2);
        }
        if (startElement == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(3);
        }
        if (endElement == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(4);
        }
        if (this.myTargetNameIsQualified && !(startElement instanceof JSReferenceExpression)) {
            return false;
        }
        if (!super.isAvailable(project, file2, startElement, endElement)) {
            return false;
        }
        if (this.myIsInterface && !DialectDetector.hasFeature(startElement, JSLanguageFeature.TYPES)) {
            return false;
        }
        if (this.myTargetNameIsQualified) {
            JSExpression qualifier = ((JSReferenceExpression)startElement).getQualifier();
            if (!(qualifier instanceof JSReferenceExpression)) {
                return false;
            }
            PsiElement element = BaseCreateFix.resolveElementForQualifier((JSReferenceExpression)qualifier);
            if (!(element instanceof TypeScriptModule) && !(element instanceof JSFile)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String getText() {
        String key = this.myIsInterface ? "javascript.create.interface.intention.name" : "javascript.create.class.intention.name";
        String string = JSBundle.message((String)key, (Object[])new Object[]{this.myTargetName});
        if (string == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSArgumentList argumentList;
        PsiElement resolvedElement;
        JSExpression qualifier;
        JSClass result2;
        JSClass jsClass;
        if (project == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(8);
        }
        if (startElement == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(9);
        }
        if (endElement == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(10);
        }
        boolean isImportExport = startElement instanceof ES6ImportExportSpecifier;
        boolean isExportDefault = startElement instanceof ES6ImportedBinding;
        PsiElement original = startElement;
        if ((startElement = ES6CreateClassOrInterfaceFix.updateStartElement(startElement)) == null) {
            return;
        }
        PsiFile targetFile = startElement.getContainingFile();
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(startElement);
        if (!FileModificationService.getInstance().prepareFileForWrite(targetFile)) {
            return;
        }
        String declarationText = ES6CreateClassOrInterfaceFix.getDeclarationText(this.myIsInterface, this.myTargetName, this.getBaseClass(this.myExpectedType), this.getImplementsList(this.myExpectedType), this.myTargetNameIsQualified || isImportExport && !BaseCreateFix.isExportWithoutFrom(original), isExportDefault);
        if (!isExportDefault) {
            result2 = jsClass = JSChangeUtil.createStatementPsiFromTextWithContext(declarationText, (PsiElement)targetFile, JSClass.class);
        } else {
            ES6ExportDefaultAssignment assignment = JSChangeUtil.createStatementPsiFromTextWithContext(declarationText, (PsiElement)targetFile, ES6ExportDefaultAssignment.class);
            result2 = assignment;
            assert (assignment != null);
            jsClass = (JSClassExpression)assignment.getExpression();
        }
        if (result2 == null || jsClass == null) {
            return;
        }
        if (dialect != null && dialect.isTypeScript) {
            TypeScriptImplementMemberUtil.implementAllMissingMembersForMemberOwner((PsiElement)jsClass, null);
        }
        PsiElement topLevelDeclaration = PsiTreeUtil.findFirstParent((PsiElement)startElement, element -> {
            PsiElement parent = element.getParent();
            return parent instanceof JSFile || parent instanceof JSEmbeddedContent && !JSPsiImplUtils.isEmbeddedExpressionContent(parent) && !JSPsiImplUtils.isEmbeddedTypeContext(parent);
        });
        PsiElement anchor = JSPsiImplUtils.findLeadingCommentOrSelf(topLevelDeclaration);
        PsiFile insertionPlace = targetFile;
        if (this.myTargetNameIsQualified && startElement instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)startElement).getQualifier()) instanceof JSReferenceExpression && ((resolvedElement = BaseCreateFix.resolveElementForQualifier((JSReferenceExpression)qualifier)) instanceof TypeScriptModule || resolvedElement instanceof JSFile)) {
            insertionPlace = resolvedElement;
            anchor = resolvedElement instanceof JSFile ? null : resolvedElement.getLastChild();
        }
        Object object = jsClass = (result2 = insertionPlace.addBefore((PsiElement)result2, anchor)) instanceof JSClass ? result2 : (JSClassExpression)((ES6ExportDefaultAssignment)result2).getExpression();
        assert (editor != null);
        assert (jsClass != null);
        BaseCreateFix.navigate(project, editor, jsClass.getTextOffset(), insertionPlace.getContainingFile().getVirtualFile());
        CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(result2.getParent().getNode(), result2.getNode());
        JSArgumentList jSArgumentList = argumentList = this.myConstructorArguments != null ? (JSArgumentList)this.myConstructorArguments.getElement() : null;
        if (argumentList != null && argumentList.getArguments().length > 0) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document document = documentManager.getDocument(file2);
            if (document == null) {
                return;
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            ES6CreateConstructorFix.generateConstructor(jsClass, argumentList, editor);
        }
    }

    @Nullable
    private static PsiElement updateStartElement(PsiElement element) {
        if (element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding) {
            return ES6PsiUtil.computeFromFileForImportExport(element);
        }
        return element;
    }

    private static String getDeclarationText(boolean isInterface, String name, String baseClass, List<String> implementsList, boolean shouldExport, boolean exportDefault) {
        StringBuilder builder = new StringBuilder();
        if (exportDefault) {
            builder.append("export default ");
        } else if (shouldExport) {
            builder.append("export ");
        }
        builder.append(isInterface ? "interface " : "class ").append(name);
        if (!StringUtil.isEmpty((String)baseClass)) {
            builder.append(" extends ").append(baseClass);
        }
        if (!implementsList.isEmpty()) {
            builder.append(" implements ").append(StringUtil.join(implementsList, s -> s, (String)","));
        }
        builder.append("{\n}");
        return builder.toString();
    }

    @Nullable
    private String getBaseClass(@Nullable JSType expectedType) {
        if (expectedType instanceof JSNamedType) {
            return this.getNameIfApplicable(expectedType, false);
        }
        if (expectedType instanceof JSIntersectionTypeImpl) {
            List classNames = ContainerUtil.mapNotNull(((JSIntersectionTypeImpl)expectedType).getTypes(), type -> this.getNameIfApplicable((JSType)type, false));
            return classNames.size() == 1 ? (String)classNames.get(0) : null;
        }
        return null;
    }

    @NotNull
    private List<String> getImplementsList(@Nullable JSType expectedType) {
        if (expectedType instanceof JSNamedType) {
            List list = ContainerUtil.createMaybeSingletonList((Object)this.getNameIfApplicable(expectedType, true));
            if (list == null) {
                ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(11);
            }
            return list;
        }
        if (expectedType instanceof JSIntersectionTypeImpl) {
            List list = ContainerUtil.mapNotNull(((JSIntersectionTypeImpl)expectedType).getTypes(), type -> this.getNameIfApplicable((JSType)type, true));
            if (list == null) {
                ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(12);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    private String getNameIfApplicable(@NotNull JSType expectedType, boolean isInterface) {
        String name;
        JSResolvedTypeInfo resolvedType;
        if (expectedType == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(14);
        }
        if (expectedType instanceof JSResolvableType && (resolvedType = ((JSResolvableType)expectedType).resolveType()).isInterface() == isInterface && !StringUtil.equals((CharSequence)(name = expectedType.getTypeText(JSType.TypeTextFormat.CODE)), (CharSequence)this.myTargetName)) {
            return name;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6CreateClassOrInterfaceFix";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6CreateClassOrInterfaceFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNameIfApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

