/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.JSLinterBaseView;
import com.intellij.lang.javascript.linter.jshint.JSHintConfigFileView;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionsTreeView;
import com.intellij.lang.javascript.linter.jshint.JSHintState;
import com.intellij.lang.javascript.linter.jshint.version.JSHintVersionView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.SwingHelper;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintView
extends JSLinterBaseView<JSHintState> {
    private final JCheckBox myConfigFileUsedCheckBox;
    private final JSHintOptionsTreeView myOptionsTreeView;
    private final JSHintVersionView myVersionView;
    private final JPanel myCardPanel;
    private final JSHintConfigFileView myConfigFileView;

    public JSHintView(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            JSHintView.$$$reportNull$$$0(0);
        }
        this.myConfigFileUsedCheckBox = new JCheckBox("Use config files");
        this.myVersionView = new JSHintVersionView(project);
        this.myOptionsTreeView = new JSHintOptionsTreeView(fullModeDialog);
        this.myCardPanel = new JPanel(new CardLayout(0, 0));
        this.myCardPanel.add(this.myOptionsTreeView.getComponent(), ConfigFileUsed.OFF.name());
        this.myConfigFileView = new JSHintConfigFileView(project);
        this.myCardPanel.add(this.myConfigFileView.getComponent(), ConfigFileUsed.ON.name());
        this.myConfigFileUsedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSHintView.this.showCard(JSHintView.this.myConfigFileUsedCheckBox.isSelected());
            }
        });
    }

    private void showCard(boolean configFileUsed) {
        CardLayout layout = (CardLayout)this.myCardPanel.getLayout();
        ConfigFileUsed type = configFileUsed ? ConfigFileUsed.ON : ConfigFileUsed.OFF;
        layout.show(this.myCardPanel, type.name());
    }

    @Override
    @Nullable
    protected Component createTopRightComponent() {
        return SwingHelper.newHorizontalPanel((float)0.5f, (Component[])new Component[]{this.myConfigFileUsedCheckBox, Box.createHorizontalStrut(20), this.myVersionView.getComponent()});
    }

    @Override
    @NotNull
    protected Component createCenterComponent() {
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.add((Component)this.myCardPanel, "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            JSHintView.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    protected void handleEnableStatusChanged(boolean enabled) {
        this.myOptionsTreeView.setEnabled(enabled);
        this.myConfigFileView.onEnabledStateChange(enabled);
    }

    @Override
    @NotNull
    protected JSHintState getState() {
        JSHintState.Builder builder = new JSHintState.Builder();
        builder.setVersion(this.myVersionView.getVersion()).setOptionsState(this.myOptionsTreeView.getOptionsState()).setConfigFileUsed(this.myConfigFileUsedCheckBox.isSelected()).setCustomConfigFileUsed(this.myConfigFileView.isCustomConfigFileUsed()).setCustomConfigFilePath(this.myConfigFileView.getCustomConfigFilePath());
        JSHintState jSHintState = builder.build();
        if (jSHintState == null) {
            JSHintView.$$$reportNull$$$0(2);
        }
        return jSHintState;
    }

    @Override
    protected void setState(@NotNull JSHintState state) {
        if (state == null) {
            JSHintView.$$$reportNull$$$0(3);
        }
        this.myVersionView.setVersion(state.getVersion());
        this.myOptionsTreeView.setOptionsState(state.getOptionsState());
        this.myConfigFileUsedCheckBox.setSelected(state.isConfigFileUsed());
        this.myConfigFileView.setCustomConfigFileUsed(state.isCustomConfigFileUsed());
        this.myConfigFileView.setCustomConfigFilePath(state.getCustomConfigFilePath());
        this.showCard(state.isConfigFileUsed());
    }

    @Override
    public void disposeResources() {
        this.myOptionsTreeView.disposeUI();
        Disposer.dispose((Disposable)this.myVersionView);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ConfigFileUsed {
        ON,
        OFF;

    }
}

