/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.lexer;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergeFunction;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.coffeescript.lang.lexer._CoffeeScriptLexer;

public class CoffeeScriptFlexLexer
extends MergingLexerAdapter {
    private static final TokenSet TOKENS_TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{CoffeeScriptTokenTypes.STRING_LITERAL, JSTokenTypes.XML_TAG_CONTENT});
    private static final MergeFunction MY_MERGE_FUNCTION = new MyMergeFunction();

    public CoffeeScriptFlexLexer() {
        super((Lexer)new FlexAdapter((FlexLexer)new _CoffeeScriptLexer(null, false)), TOKENS_TO_MERGE);
    }

    public CoffeeScriptFlexLexer(boolean highlightMode) {
        super((Lexer)new FlexAdapter((FlexLexer)new _CoffeeScriptLexer(null, highlightMode)), TOKENS_TO_MERGE);
    }

    public MergeFunction getMergeFunction() {
        return MY_MERGE_FUNCTION;
    }

    private static class MyMergeFunction
    implements MergeFunction {
        private IElementType previousTokenType;

        private MyMergeFunction() {
        }

        public IElementType merge(IElementType type, Lexer originalLexer) {
            if (this.previousTokenType == JSTokenTypes.XML_JS_SCRIPT_START) {
                this.previousTokenType = null;
                int braceBalance = 1;
                while (originalLexer.getTokenType() != null && (braceBalance > 1 || originalLexer.getTokenType() != JSTokenTypes.XML_JS_SCRIPT_END)) {
                    IElementType tokenType = originalLexer.getTokenType();
                    originalLexer.advance();
                    if (tokenType == JSTokenTypes.XML_JS_SCRIPT_START) {
                        ++braceBalance;
                    }
                    if (tokenType == JSTokenTypes.XML_JS_SCRIPT_END) {
                        --braceBalance;
                    }
                    if (braceBalance != 0) continue;
                    break;
                }
                return CoffeeScriptTokenTypes.EMBEDDED_CONTENT;
            }
            if (TOKENS_TO_MERGE.contains(type)) {
                while (originalLexer.getTokenType() == type) {
                    originalLexer.advance();
                }
            }
            this.previousTokenType = type;
            return type;
        }
    }
}

