/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby.compose;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.docker.remote.ruby.RubyDockerBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import java.io.File;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;

public class RubyDockerBundleInstallQuickfix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(RubyDockerBundleInstallQuickfix.class);
    private final Module myModule;
    private final String[] myCommands;
    private final String myFamilyName;

    public RubyDockerBundleInstallQuickfix(@NotNull Module module, @NotNull String[] commands, @NotNull String familyName) {
        if (module == null) {
            RubyDockerBundleInstallQuickfix.$$$reportNull$$$0(0);
        }
        if (commands == null) {
            RubyDockerBundleInstallQuickfix.$$$reportNull$$$0(1);
        }
        if (familyName == null) {
            RubyDockerBundleInstallQuickfix.$$$reportNull$$$0(2);
        }
        this.myModule = module;
        this.myCommands = commands;
        this.myFamilyName = familyName;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            RubyDockerBundleInstallQuickfix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
        String pathToCommand;
        if (project == null) {
            RubyDockerBundleInstallQuickfix.$$$reportNull$$$0(4);
        }
        if (problemDescriptor == null) {
            RubyDockerBundleInstallQuickfix.$$$reportNull$$$0(5);
        }
        this.myCommands[0] = pathToCommand = RubyDockerBundleInstallQuickfix.getFullPathToCommand(this.myCommands[0]);
        GeneralCommandLine commandLine = new GeneralCommandLine(this.myCommands);
        commandLine.setWorkDirectory(project.getBasePath());
        OSProcessHandler processHandler = null;
        try {
            processHandler = new OSProcessHandler(commandLine);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        if (processHandler == null) {
            return;
        }
        RunContentExecutor contentExecutor = new RunContentExecutor(project, (ProcessHandler)processHandler).withTitle(RubyDockerBundle.message("ruby.sdk.bundle.install.quick.display.name", new Object[0])).withAfterCompletion(() -> {
            Sdk sdk = ModuleRootManager.getInstance((Module)this.myModule).getSdk();
            if (sdk != null) {
                RubyRemoteInterpreterManager manager = RubyRemoteInterpreterManager.getInstance();
                manager.updateGemsCopy(sdk, this.myModule, true);
                GemManager gemManager = GemManager.getInstance();
                gemManager.refresh(sdk);
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                RubyDockerBundleInstallQuickfix.$$$reportNull$$$0(6);
            }
            if (!project.isDisposed()) {
                contentExecutor.run();
            }
        });
    }

    private static String getFullPathToCommand(String command) {
        File executablePath = PathEnvironmentVariableUtil.findInPath((String)command);
        if (executablePath != null) {
            return executablePath.getAbsolutePath();
        }
        return command;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/ruby/compose/RubyDockerBundleInstallQuickfix";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/ruby/compose/RubyDockerBundleInstallQuickfix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyFix$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

