/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import b.h.la;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.psi.PsiElement;
import com.intellij.util.Alarm;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDataContext;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemsDataKeys;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RWords;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RNameUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.utils.NamingConventions;
import org.yaml.snakeyaml.error.YAMLException;

public class GemSpecParser
implements Disposable {
    private static final Logger e;
    static final String PARSER_VERSION = "16";
    @NonNls
    static final String NAME_ATTRIBUTE = "name";
    @NonNls
    static final String VERSION_ATTRIBUTE = "version";
    @NonNls
    static final String AUTHORS_ATTRIBUTE = "authors";
    @NonNls
    static final String EMAIL_ATTRIBUTE = "email";
    @NonNls
    static final String HOMEPAGE_ATTRIBUTE = "homepage";
    @NonNls
    static final String SUMMARY_ATTRIBUTE = "summary";
    @NonNls
    static final String DESCRIPTION_ATTRIBUTE = "description";
    @NonNls
    static final String DEPENDENCIES_ATTRIBUTE = "add_dependency";
    @NonNls
    static final String RUNTIME_DEPENDENCIES_ATTRIBUTE = "add_runtime_dependency";
    @NonNls
    static final String DEVELOPMENT_DEPENDENCIES_ATTRIBUTE = "add_development_dependency";
    @NonNls
    static final String REQUIRE_PATHS = "require_paths";
    @NonNls
    static final String GIT_ATTRIBUTE = "git";
    @NonNls
    static final String REF_ATTRIBUTE = "ref";
    @NonNls
    static final String DOT_FREEZE_SUFFIX = ".freeze";
    @NonNls
    static final String FREEZE_SUFFIX = "\".freeze";
    private final VirtualFileListener c;
    private final Map<String, GemDataContext> b = new HashMap<String, GemDataContext>();
    private final Map<String, LocalFileSystem.WatchRequest> f = new HashMap<String, LocalFileSystem.WatchRequest>();
    private final Alarm d;
    @NonNls
    private static final Pattern a;
    private static final long g;

    @NotNull
    protected static String unfreezeQuoted(String valueText) {
        long l2 = g ^ 0x6AAFF05B8447L;
        String string = valueText.substring(1, valueText.length() - FREEZE_SUFFIX.length());
        if (string == null) {
            GemSpecParser.a(0);
        }
        return string;
    }

    protected static boolean isFrozenQuoted(String valueText) {
        long l2 = g ^ 0x1838FDC4740EL;
        return valueText.startsWith("\"") && valueText.endsWith(FREEZE_SUFFIX);
    }

    @Nullable
    protected static String unfreeze(@Nullable String valueText) {
        long l2 = g ^ 0x113A71C1F89CL;
        return valueText == null ? null : valueText.substring(0, valueText.length() - FREEZE_SUFFIX.length() + 1);
    }

    public GemSpecParser() {
        this.c = new VirtualFileListener(){
            private static final long a = la.a(-7955810729584881015L, -7708454085095713658L, MethodHandles.lookup().lookupClass()).a(32017726355698L);

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.a(0);
                }
                GemSpecParser.this.b.remove(event.getFile().getPath());
            }

            public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    1.a(1);
                }
                GemSpecParser.this.b.remove(event.getFile().getPath());
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x4EF2DE809831L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemSpecParser$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeFileMovement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        VirtualFileManager.getInstance().addVirtualFileListener(this.c);
        this.d = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    public static GemSpecParser getInstance() {
        return (GemSpecParser)ServiceManager.getService(GemSpecParser.class);
    }

    @Nullable
    public GemDataContext getGemSpec(@Nullable VirtualFile gemFile, @Nullable VirtualFile specFile) {
        return this.getGemSpec(gemFile, specFile, false);
    }

    @Nullable
    public GemDataContext getGemSpec(@Nullable VirtualFile gemFile, @Nullable VirtualFile specFile, boolean isProjectGemSpec) {
        if (specFile == null || gemFile == null) {
            return null;
        }
        String string = specFile.getPath();
        if (!this.b.containsKey(string) || isProjectGemSpec) {
            this.b.put(string, GemSpecParser.a(gemFile, specFile, isProjectGemSpec));
            this.b(specFile);
        }
        return this.b.get(string);
    }

    @Nullable
    private static GemDataContext a(@NotNull VirtualFile virtualFile, @NotNull VirtualFile virtualFile2, boolean bl2) {
        if (virtualFile == null) {
            GemSpecParser.a(1);
        }
        if (virtualFile2 == null) {
            GemSpecParser.a(2);
        }
        Ref ref = new Ref();
        ApplicationManager.getApplication().runReadAction(() -> {
            long l2 = g ^ 0x1A4379B2746BL;
            if (virtualFile2 == null) {
                GemSpecParser.a(7);
            }
            if (virtualFile == null) {
                GemSpecParser.a(8);
            }
            try {
                String string = VfsUtilCore.loadText((VirtualFile)virtualFile2);
                string = string.replace("\r", "");
                GemDataContext gemDataContext = new GemDataContext();
                gemDataContext.putData(GemsDataKeys.SPEC_NAME, virtualFile2.getNameWithoutExtension());
                GemSpecParser.b(virtualFile2, gemDataContext);
                GemSpecParser.parseSpec(string, gemDataContext);
                Set set = (Set)GemsDataKeys.DEVELOPMENT_DEPENDENCIES.getData((DataContext)gemDataContext);
                Set set2 = (Set)GemsDataKeys.DEPENDENCIES.getData((DataContext)gemDataContext);
                if (set != null) {
                    if (bl2) {
                        if (set2 != null) {
                            set2.addAll(set);
                        } else {
                            gemDataContext.putData(GemsDataKeys.DEPENDENCIES, set);
                        }
                    } else if (set2 != null) {
                        set2.removeAll(set);
                    }
                }
                GemSpecParser.a(virtualFile, gemDataContext);
                String string2 = (String)GemsDataKeys.VERSION.getData((DataContext)gemDataContext);
                if (string2 != null && !a.matcher(string2).matches()) {
                    gemDataContext.putData(GemsDataKeys.VERSION, null);
                }
                ref.set((Object)gemDataContext);
            }
            catch (IOException iOException) {
                e.warn("Failed to read description", (Throwable)iOException);
            }
        });
        return (GemDataContext)ref.get();
    }

    static void parseSpec(String contents, @NotNull GemDataContext result) {
        if (result == null) {
            GemSpecParser.a(3);
        }
        GemSpecParser.parseRubySpec(contents, result);
        if (GemSpecParser.a(result)) {
            GemSpecParser.a(contents, result);
        }
    }

    private static boolean a(@NotNull GemDataContext gemDataContext) {
        if (gemDataContext == null) {
            GemSpecParser.a(4);
        }
        return StringUtil.isEmpty((String)((String)GemsDataKeys.NAME.getData((DataContext)gemDataContext)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean a(String string, GemDataContext gemDataContext) {
        long l2 = g ^ 0x4656803B233AL;
        Map map = null;
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(CharsetToolkit.UTF8_CHARSET));){
            map = RubyUtil.loadYaml(byteArrayInputStream);
            if (map == null) {
                boolean bl2 = false;
                return bl2;
            }
        }
        catch (IOException iOException) {
            e.error((Throwable)iOException);
            return false;
        }
        catch (YAMLException yAMLException) {
            e.debug((Throwable)yAMLException);
            return false;
        }
        catch (RuntimeException runtimeException) {
            e.debug((Throwable)runtimeException);
        }
        if (map == null) return true;
        Object v2 = map.get(NAME_ATTRIBUTE);
        gemDataContext.putData(GemsDataKeys.NAME, v2 != null ? v2.toString() : null);
        Map map2 = (Map)map.get(VERSION_ATTRIBUTE);
        Object v3 = map2.get(VERSION_ATTRIBUTE);
        gemDataContext.putData(GemsDataKeys.VERSION, v3 != null ? v3.toString() : null);
        Object v4 = map.get(EMAIL_ATTRIBUTE);
        gemDataContext.putData(GemsDataKeys.EMAIL, v4 != null ? v4.toString() : null);
        Object v5 = map.get(HOMEPAGE_ATTRIBUTE);
        gemDataContext.putData(GemsDataKeys.HOMEPAGE, v5 != null ? v5.toString() : null);
        return true;
    }

    static void parseRubySpec(String contents, GemDataContext result) {
        long l2 = g ^ 0x3A7F61CBF8A1L;
        RFile rFile = RubyElementFactory.createRubyFile(ProjectManager.getInstance().getDefaultProject(), contents);
        if (rFile == null) {
            return;
        }
        RubyPsiInterpreter rubyPsiInterpreter = new RubyPsiInterpreter(true);
        final GemSpecCallable gemSpecCallable = new GemSpecCallable(result);
        rubyPsiInterpreter.registerCallable(new PsiCallable(){

            @Override
            public void processCall(RCallArguments arguments) {
                arguments.interpretBlock(gemSpecCallable);
            }
        }, "Gem::Specification.new");
        rubyPsiInterpreter.interpret((PsiElement)rFile, null);
    }

    private static void a(VirtualFile virtualFile, GemDataContext gemDataContext) {
        long l2 = g ^ 0x7B62937FA2DAL;
        String string = (String)GemsDataKeys.VERSION.getData((DataContext)gemDataContext);
        if (string == null || !string.contains(RNameUtilCore.SYMBOL_DELIMITER)) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile.findChild("lib");
        if (virtualFile2 == null) {
            gemDataContext.putData(GemsDataKeys.VERSION, null);
            return;
        }
        int n2 = string.lastIndexOf(RNameUtilCore.SYMBOL_DELIMITER);
        String string2 = NamingConventions.toUnderscoreCase(string, false) + ".rb";
        String string3 = string.substring(n2 + 2);
        VirtualFile virtualFile3 = virtualFile2.findFileByRelativePath(string2);
        if (virtualFile3 == null) {
            string2 = NamingConventions.toUnderscoreCase(string.substring(0, n2), false) + ".rb";
            virtualFile3 = virtualFile2.findFileByRelativePath(string2);
        }
        if (virtualFile3 == null) {
            gemDataContext.putData(GemsDataKeys.VERSION, null);
            return;
        }
        try {
            String string4 = VfsUtilCore.loadText((VirtualFile)virtualFile3);
            Pattern pattern = Pattern.compile("^\\s*" + string3 + "\\s*=\\s*['\"](.*)['\"].*$", 8);
            Matcher matcher = pattern.matcher(string4);
            if (matcher.find() && matcher.groupCount() > 0) {
                gemDataContext.putData(GemsDataKeys.VERSION, TextUtil.removeQuoting(matcher.group(1)));
            } else {
                gemDataContext.putData(GemsDataKeys.VERSION, null);
            }
        }
        catch (IOException iOException) {
            gemDataContext.putData(GemsDataKeys.VERSION, null);
            e.warn("Failed to read version file", (Throwable)iOException);
        }
    }

    private static void b(VirtualFile virtualFile, GemDataContext gemDataContext) {
        VirtualFile virtualFile2;
        long l2 = g ^ 0x6686B09041ADL;
        for (virtualFile2 = virtualFile.getParent(); virtualFile2 != null && virtualFile2.findChild(".git") == null; virtualFile2 = virtualFile2.getParent()) {
        }
        if (virtualFile2 == null) {
            return;
        }
        String string = virtualFile2.getName();
        int n2 = string.lastIndexOf(45);
        if (n2 == -1) {
            return;
        }
        String string2 = string.substring(n2 + 1);
        if (!GemSpecParser.b(string2)) {
            return;
        }
        gemDataContext.putData(GemsDataKeys.GIT, true);
        gemDataContext.putData(GemsDataKeys.REF, string2);
    }

    private static boolean b(@Nullable String string) {
        if (string == null || string.length() < 6) {
            return false;
        }
        for (int i10 = string.length() - 1; i10 >= 0; --i10) {
            if (StringUtil.isHexDigit((char)string.charAt(i10))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<String> a(@NotNull RArray rArray) {
        if (rArray == null) {
            GemSpecParser.a(5);
        }
        List list2 = StreamEx.of((Collection)rArray.getElements()).map(rPsiElement -> GemSpecParser.isFrozenQuoted(rPsiElement.getText()) ? GemSpecParser.unfreezeQuoted(rPsiElement.getText()) : rPsiElement.getText()).map(string -> TextUtil.removeQuoting(string)).toList();
        if (list2 == null) {
            GemSpecParser.a(6);
        }
        return list2;
    }

    private void b(VirtualFile virtualFile) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.d.addRequest(() -> ApplicationManager.getApplication().runReadAction(() -> {
            LocalFileSystem.WatchRequest watchRequest;
            String string;
            VirtualFile virtualFile2 = virtualFile.getParent();
            String string2 = string = virtualFile2 != null ? virtualFile2.getPath() : null;
            if (string != null && !this.f.containsKey(string) && (watchRequest = LocalFileSystem.getInstance().addRootToWatch(VfsUtilCore.urlToPath((String)string), true)) != null) {
                this.f.put(string, watchRequest);
            }
        }), -1);
    }

    public void dispose() {
        VirtualFileManager.getInstance().removeVirtualFileListener(this.c);
        LocalFileSystem.getInstance().removeWatchedRoots(this.f.values());
    }

    static {
        g = la.a(-7004043307075548205L, -4326560599543976497L, MethodHandles.lookup().lookupClass()).a(261366712271688L);
        long l2 = g ^ 0x4C058F860DABL;
        e = Logger.getInstance(GemSpecParser.class);
        a = Pattern.compile("([0-9]+(\\.[0-9A-z]+)*)");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x74B04D4E6BDL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemSpecParser";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFile";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "unfreezeQuoted";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemSpecParser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArrayOfStrings";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseGemSpec";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseSpec";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIncomplete";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseArrayOfStrings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$parseGemSpec$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GemSpecCallable
    implements PsiCallable {
        private final GemDataContext a;
        private static final long b = la.a(8602792860195229067L, 1540765512866577384L, MethodHandles.lookup().lookupClass()).a(258070529812576L);

        GemSpecCallable(GemDataContext spec) {
            this.a = spec;
        }

        @Override
        public void processCall(RCallArguments args) {
            RPsiElement rPsiElement;
            long l2 = b ^ 0x335FA2F0450FL;
            RAssignmentExpression rAssignmentExpression = RAssignmentExpressionNavigator.getAssignmentByLeftPart(args.getCallElement());
            String string = args.getCommand();
            RPsiElement rPsiElement2 = rPsiElement = rAssignmentExpression != null ? rAssignmentExpression.getValue() : null;
            if (rPsiElement == null) {
                if (GemSpecCallable.a(string)) {
                    this.a(args);
                }
                return;
            }
            String string2 = rPsiElement.getText();
            if (Comparing.strEqual((String)GemSpecParser.NAME_ATTRIBUTE, (String)string)) {
                String string3;
                if (rPsiElement instanceof RStringLiteral) {
                    string3 = TextUtil.removeQuoting(string2);
                } else {
                    int n2;
                    String string4;
                    string3 = string4 = (String)GemsDataKeys.SPEC_NAME.getData((DataContext)this.a);
                    if (string4 != null && (n2 = string4.lastIndexOf(45)) > 0) {
                        String string5 = string4.substring(n2 + 1);
                        if (string5.matches("([0-9]+(\\.[0-9A-z]+)*)")) {
                            string3 = string4.substring(0, n2);
                        } else if (GemSpecParser.isFrozenQuoted(string2)) {
                            string3 = GemSpecParser.unfreezeQuoted(string2);
                        }
                    }
                }
                this.a.putData(GemsDataKeys.NAME, string3);
            } else if (Comparing.strEqual((String)GemSpecParser.VERSION_ATTRIBUTE, (String)string)) {
                this.a.putData(GemsDataKeys.VERSION, TextUtil.removeQuoting(rPsiElement.getText()));
            } else if (Comparing.strEqual((String)GemSpecParser.EMAIL_ATTRIBUTE, (String)string)) {
                if (rPsiElement instanceof RArray) {
                    this.a.putData(GemsDataKeys.EMAIL, TextUtil.arrayToString((RArray)rPsiElement));
                } else {
                    this.a.putData(GemsDataKeys.EMAIL, TextUtil.removeQuoting(rPsiElement.getText()));
                }
            } else if (Comparing.strEqual((String)GemSpecParser.HOMEPAGE_ATTRIBUTE, (String)string)) {
                String string6 = rPsiElement.getText();
                string6 = GemSpecParser.isFrozenQuoted(string6) ? GemSpecParser.unfreezeQuoted(string6) : TextUtil.removeQuoting(string6);
                this.a.putData(GemsDataKeys.HOMEPAGE, string6);
            } else if (Comparing.strEqual((String)GemSpecParser.SUMMARY_ATTRIBUTE, (String)string)) {
                this.a.putData(GemsDataKeys.SUMMARY, TextUtil.removeQuoting(rPsiElement.getText()));
            } else if (Comparing.strEqual((String)GemSpecParser.AUTHORS_ATTRIBUTE, (String)string) && rPsiElement instanceof RArray) {
                this.a.putData(GemsDataKeys.AUTHORS, TextUtil.arrayToString((RArray)rPsiElement));
            } else if (Comparing.strEqual((String)GemSpecParser.REQUIRE_PATHS, (String)string)) {
                if (rPsiElement instanceof RArray) {
                    this.a.putData(GemsDataKeys.REQUIRE_PATHS, GemSpecParser.a((RArray)rPsiElement));
                } else if (rPsiElement instanceof RWords) {
                    ArrayList arrayList = new ArrayList();
                    TextUtil.flattern(rPsiElement, arrayList);
                    this.a.putData(GemsDataKeys.REQUIRE_PATHS, arrayList);
                } else {
                    this.a.putData(GemsDataKeys.REQUIRE_PATHS, Collections.singletonList("lib"));
                }
            }
        }

        private void a(RCallArguments rCallArguments) {
            List<RPsiElement> list2;
            LinkedHashSet<GemDependency> linkedHashSet;
            long l2 = b ^ 0x1CED6CF7F239L;
            boolean bl2 = GemSpecParser.DEVELOPMENT_DEPENDENCIES_ATTRIBUTE.equals(rCallArguments.getCommand());
            Set<GemDependency> set = linkedHashSet = bl2 ? (LinkedHashSet<GemDependency>)GemsDataKeys.DEVELOPMENT_DEPENDENCIES.getData((DataContext)this.a) : (Set)GemsDataKeys.DEPENDENCIES.getData((DataContext)this.a);
            if (linkedHashSet == null) {
                linkedHashSet = new LinkedHashSet<GemDependency>();
                this.a.putData(bl2 ? GemsDataKeys.DEVELOPMENT_DEPENDENCIES : GemsDataKeys.DEPENDENCIES, linkedHashSet);
            }
            if ((list2 = rCallArguments.getArguments()).size() > 0) {
                String string = list2.get(0).getText();
                if (string != null) {
                    string = string.replace(GemSpecParser.DOT_FREEZE_SUFFIX, "");
                }
                GemSpecCallable.a(TextUtil.removeQuoting(string), list2, linkedHashSet);
            }
        }

        private static void a(String string, List<RPsiElement> list2, Set<GemDependency> set) {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list2.size() == 2 && list2.get(1) instanceof RArray) {
                object = (RArray)list2.get(1);
                PsiElement[] psiElementArray = object.getChildren();
                if (psiElementArray.length == 0 || !(psiElementArray[0] instanceof RListOfExpressions)) {
                    set.add(GemDependency.any(string));
                    return;
                }
                RListOfExpressions rListOfExpressions = (RListOfExpressions)psiElementArray[0];
                for (RPsiElement rPsiElement : rListOfExpressions.getElements()) {
                    arrayList.add(TextUtil.removeQuoting(rPsiElement.getText()));
                }
            } else {
                int n2 = list2.size();
                for (int i10 = 1; i10 < n2; ++i10) {
                    RPsiElement rPsiElement = list2.get(i10);
                    if (!(rPsiElement instanceof RStringLiteral)) continue;
                    arrayList.add(TextUtil.removeQuoting(rPsiElement.getText()));
                }
            }
            GemDependency gemDependency = object = arrayList.size() == 0 ? GemDependency.any(string) : GemDependency.create(string, arrayList.toArray(new String[0]));
            if (object != null) {
                set.add((GemDependency)object);
            }
        }

        private static boolean a(String string) {
            long l2 = b ^ 0x695F143D8883L;
            return Comparing.strEqual((String)string, (String)GemSpecParser.DEPENDENCIES_ATTRIBUTE) || Comparing.strEqual((String)string, (String)GemSpecParser.RUNTIME_DEPENDENCIES_ATTRIBUTE) || Comparing.strEqual((String)string, (String)GemSpecParser.DEVELOPMENT_DEPENDENCIES_ATTRIBUTE);
        }
    }
}

