/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils;

import b.h.la;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubySymbolsLookupCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUndefStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RMethodImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyVisibilityCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.containers.RMethodStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class RContainerUtil {
    private static final Logger a;
    private static final long b;

    private RContainerUtil() {
    }

    @NotNull
    public static <T extends RPsiStructureElement> List<T> selectElementsByType(@NotNull List<? extends RPsiStructureElement> fullList, @NotNull Class<T> type) {
        if (fullList == null) {
            RContainerUtil.a(0);
        }
        if (type == null) {
            RContainerUtil.a(1);
        }
        ArrayList<RPsiStructureElement> arrayList = new ArrayList<RPsiStructureElement>();
        for (RPsiStructureElement rPsiStructureElement : fullList) {
            if (!type.isInstance(rPsiStructureElement)) continue;
            arrayList.add(rPsiStructureElement);
        }
        ArrayList<RPsiStructureElement> arrayList2 = arrayList;
        if (arrayList2 == null) {
            RContainerUtil.a(2);
        }
        return arrayList2;
    }

    @Nullable
    public static RClass getClassByName(@NotNull RContainer container, @Nullable String className) {
        if (container == null) {
            RContainerUtil.a(3);
        }
        for (RClass rClass : RContainerUtil.selectElementsByType(container.getStructureElements(), RClass.class)) {
            if (!Comparing.strEqual((String)rClass.getName(), (String)className, (boolean)true)) continue;
            return rClass;
        }
        return null;
    }

    public static boolean isTopLevel(@NotNull RContainer container) {
        if (container == null) {
            RContainerUtil.a(4);
        }
        RContainer rContainer = container.getParentContainer();
        return rContainer instanceof RFile;
    }

    @Nullable
    public static RClass findClassByName(@NotNull RContainer container, @Nullable String className) {
        if (container == null) {
            RContainerUtil.a(5);
        }
        if (className == null) {
            return null;
        }
        String[] stringArray = className.split(RubyTokenTypes.tCOLON2.toString());
        RContainer rContainer = container;
        for (String string : stringArray) {
            RContainer rContainer2 = RContainerUtil.getContainerByName(rContainer, string);
            rContainer = rContainer2 != null ? rContainer2 : rContainer;
        }
        return rContainer instanceof RClass ? (RClass)rContainer : null;
    }

    @Nullable
    public static RMethod getMethodByName(@NotNull RContainer container, @NonNls @Nullable String methodName) {
        if (container == null) {
            RContainerUtil.a(6);
        }
        for (RMethod rMethod : RContainerUtil.selectElementsByType(container.getStructureElements(), RMethod.class)) {
            if (!Comparing.strEqual((String)rMethod.getName(), (String)methodName, (boolean)true)) continue;
            return rMethod;
        }
        return null;
    }

    @Nullable
    public static RModule getModuleByName(@NotNull RContainer container, @Nullable String moduleName) {
        if (container == null) {
            RContainerUtil.a(7);
        }
        for (RModule rModule : RContainerUtil.selectElementsByType(container.getStructureElements(), RModule.class)) {
            if (!Comparing.strEqual((String)rModule.getName(), (String)moduleName, (boolean)true)) continue;
            return rModule;
        }
        return null;
    }

    @Nullable
    public static RContainer getContainerByName(@NotNull RContainer container, @Nullable String name) {
        if (container == null) {
            RContainerUtil.a(8);
        }
        for (RContainer rContainer : RContainerUtil.selectElementsByType(container.getStructureElements(), RContainer.class)) {
            if (!Comparing.strEqual((String)rContainer.getName(), (String)name, (boolean)true)) continue;
            return rContainer;
        }
        return null;
    }

    @NotNull
    public static <E> List<RPsiStructureElement> getStructureElements(final @NotNull RPsiElement container, StubElement<? extends E> stub) {
        if (container == null) {
            RContainerUtil.a(9);
        }
        final ArrayList<RPsiStructureElement> arrayList = new ArrayList<RPsiStructureElement>();
        if (stub != null) {
            List list2 = stub.getChildrenStubs();
            RContainerUtil.a(arrayList, list2);
        } else {
            RubyRecursiveElementVisitor rubyRecursiveElementVisitor = new RubyRecursiveElementVisitor(){
                private static final long a = la.a(-7661080391364192993L, 8784371825581732564L, MethodHandles.lookup().lookupClass()).a(91598145919075L);

                @Override
                public void visitRModule(RModule rModule) {
                    arrayList.add(rModule);
                }

                @Override
                public void visitRClass(RClass rClass) {
                    arrayList.add(rClass);
                }

                @Override
                public void visitRObjectClass(RObjectClass rMetaClass) {
                    arrayList.add(rMetaClass);
                }

                @Override
                public void visitRMethod(RMethod rMethod) {
                    arrayList.add(rMethod);
                }

                @Override
                public void visitRSingletonMethod(RSingletonMethod rSingletonMethod) {
                    arrayList.add(rSingletonMethod);
                }

                @Override
                public void visitRBlockCall(RBlockCall blockCall) {
                    if (RContainerUtil.isClassEval(blockCall) && container != blockCall) {
                        arrayList.add(blockCall);
                    } else {
                        super.visitRBlockCall(blockCall);
                    }
                }

                @Override
                public void visitRCall(@NotNull RCall rCall) {
                    RBlockCall rBlockCall;
                    RubyCallType rubyCallType;
                    if (rCall == null) {
                        1.b(0);
                    }
                    if ((rubyCallType = rCall.getCallType()) instanceof RubyVisibilityCallType) {
                        rBlockCall = ((List)rCall.getData(new RubyCallType[]{(RubyVisibilityCallType)rubyCallType})).iterator();
                        while (rBlockCall.hasNext()) {
                            RPsiElement rPsiElement;
                            String string = (String)rBlockCall.next();
                            if (!RContainerUtil.isMethodArg((PsiElement)rCall, string) || !((rPsiElement = (RPsiElement)ContainerUtil.getFirstItem((List)rCall.getArguments())) instanceof RMethodImpl)) continue;
                            this.visitRMethod((RMethodImpl)rPsiElement);
                            break;
                        }
                    }
                    if (rubyCallType.isPersistent()) {
                        if ((RubyCallTypes.isIncludeCall((RPossibleCall)rCall) || RubyCallTypes.isExtendCall((RPossibleCall)rCall)) && (rBlockCall = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)rCall, RBlockCall.class, (boolean)true, (Class[])new Class[]{RContainer.class, PsiFile.class})) != null && RContainerUtil.isContextChangingBlockCall(rBlockCall) && container != rBlockCall) {
                            return;
                        }
                        arrayList.add(rCall);
                    }
                }

                @Override
                public void visitRAliasStatement(RAliasStatement rAliasStatement) {
                    arrayList.add(rAliasStatement);
                }

                @Override
                public void visitRUndefStatement(RUndefStatement rUndefStatement) {
                    arrayList.add(rUndefStatement);
                }

                private static /* synthetic */ void b(int n2) {
                    long l2 = a ^ 0xF2B5E5ADB62L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rCall", "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/holders/utils/RContainerUtil$1", "visitRCall"));
                }
            };
            container.acceptChildren((PsiElementVisitor)rubyRecursiveElementVisitor);
        }
        ArrayList<RPsiStructureElement> arrayList2 = arrayList;
        if (arrayList2 == null) {
            RContainerUtil.a(10);
        }
        return arrayList2;
    }

    public static boolean isMethodArg(PsiElement rCall, String arg) {
        if (arg == null || LanguageLevel.RUBY21.isGreaterThan(RubyLanguageLevelPusher.getInstance().getLanguageLevelByElement(rCall))) {
            return false;
        }
        String string = RubyTokenTypes.kDEF.toString();
        if (!arg.startsWith(string) || arg.length() <= string.length()) {
            return false;
        }
        char c10 = arg.charAt(string.length());
        return Character.isWhitespace(c10);
    }

    private static void a(List<? super RPsiStructureElement> list2, List<? extends StubElement> list3) {
        long l2 = b ^ 0x9DFDADCE7F3L;
        for (StubElement stubElement : list3) {
            PsiElement psiElement = stubElement.getPsi();
            if (psiElement instanceof RCodeBlock || psiElement instanceof RBlockCall && !RContainerUtil.isClassEval((RBlockCall)psiElement)) {
                RContainerUtil.a(list2, stubElement.getChildrenStubs());
                continue;
            }
            if (!(psiElement instanceof RPsiStructureElement)) continue;
            if (stubElement instanceof RMethodStub && psiElement instanceof RMethodImpl) {
                ((RMethodImpl)psiElement).setVisibility(((RMethodStub)stubElement).getScopeVisibility());
            }
            if (psiElement instanceof RCall) {
                String string;
                RubyCallType rubyCallType = ((RCall)psiElement).getCallType();
                String string2 = string = rubyCallType instanceof RubyVisibilityCallType ? (String)ContainerUtil.getFirstItem((List)((List)((RCall)psiElement).getData(new RubyCallType[0]))) : null;
                if (RContainerUtil.isMethodArg(psiElement, string)) {
                    StubElement stubElement2 = (StubElement)ContainerUtil.getFirstItem((List)stubElement.getChildrenStubs());
                    a.assertTrue(stubElement2 != null, (Object)("Null stub for " + stubElement2 + (stubElement.getPsi().isValid() ? stubElement.getPsi().getContainingFile().getVirtualFile().getPath() : "")));
                    RPsiStructureElement rPsiStructureElement = (RPsiStructureElement)stubElement2.getPsi();
                    list2.add((RPsiStructureElement)rPsiStructureElement);
                }
            }
            list2.add((RPsiStructureElement)((RPsiStructureElement)psiElement));
        }
    }

    public static boolean isClassEval(@NotNull RBlockCall call) {
        long l2 = b ^ 0x17FCAA178E57L;
        if (call == null) {
            RContainerUtil.a(11);
        }
        String string = call.getCommand();
        return "class_eval".equals(string);
    }

    public static boolean isContextChangingBlockCall(@NotNull RBlockCall call) {
        String string;
        long l2 = b ^ 0x6DA989EF4356L;
        if (call == null) {
            RContainerUtil.a(12);
        }
        return "class_eval".equals(string = call.getCommand()) || "autoload_under".equals(string) || call.getCall() != null && "RSpec.configure".equals(call.getCall().getText());
    }

    @NotNull
    public static List<RClass> getTopLevelClasses(@NotNull RContainer container) {
        if (container == null) {
            RContainerUtil.a(13);
        }
        ArrayList<RClass> arrayList = new ArrayList<RClass>();
        RContainerUtil.a(container, arrayList);
        ArrayList<RClass> arrayList2 = arrayList;
        if (arrayList2 == null) {
            RContainerUtil.a(14);
        }
        return arrayList2;
    }

    private static void a(@NotNull RContainer rContainer, @NotNull List<? super RClass> list2) {
        if (rContainer == null) {
            RContainerUtil.a(15);
        }
        if (list2 == null) {
            RContainerUtil.a(16);
        }
        list2.addAll(RContainerUtil.selectElementsByType(rContainer.getStructureElements(), RClass.class));
        for (RModule rModule : RContainerUtil.selectElementsByType(rContainer.getStructureElements(), RModule.class)) {
            RContainerUtil.a((RContainer)rModule, list2);
        }
    }

    public static List<RModule> getTopLevelModules(@NotNull RContainer container) {
        if (container == null) {
            RContainerUtil.a(17);
        }
        return new ArrayList<RModule>(RContainerUtil.selectElementsByType(container.getStructureElements(), RModule.class));
    }

    public static List<String> getAllModulesNames(@NotNull RContainer container) {
        if (container == null) {
            RContainerUtil.a(18);
        }
        return RContainerUtil.a(container, "");
    }

    private static List<String> a(@NotNull RContainer rContainer, @NotNull String string) {
        long l2 = b ^ 0xB6663FC3FEEL;
        if (rContainer == null) {
            RContainerUtil.a(19);
        }
        if (string == null) {
            RContainerUtil.a(20);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = Comparing.equal((String)string, (String)"") ? "" : string + "::";
        for (RModule rModule : RContainerUtil.selectElementsByType(rContainer.getStructureElements(), RModule.class)) {
            String string3 = string2 + rModule.getFQN().getFullPath();
            arrayList.add(string3);
            arrayList.addAll(RContainerUtil.a((RContainer)rModule, string3));
        }
        return arrayList;
    }

    @Nullable
    public static RClass getFirstClassInFile(@Nullable PsiFile psiFile) {
        List<RClass> list2;
        if (psiFile instanceof RFile && !(list2 = RContainerUtil.getTopLevelClasses((RContainer)((RFile)psiFile))).isEmpty()) {
            return list2.get(0);
        }
        return null;
    }

    @Nullable
    public static RModule getFirstModuleInFile(@Nullable PsiFile psiFile) {
        List<RModule> list2;
        if (psiFile instanceof RFile && !(list2 = RContainerUtil.getTopLevelModules((RContainer)((RFile)psiFile))).isEmpty()) {
            return list2.get(0);
        }
        return null;
    }

    public static boolean isInheritor(RClass rubyClass, @NonNls String className) {
        Symbol symbol2 = SymbolUtil.getSymbolByContainer((RElementWithFQN)rubyClass);
        if (symbol2 instanceof ClassModuleSymbol) {
            RubySymbolsLookupCache rubySymbolsLookupCache = RubySymbolsLookupCache.getInstance(rubyClass.getProject());
            Boolean bl2 = rubySymbolsLookupCache.isInheritor((PsiElement)rubyClass, symbol2, className);
            if (bl2 != null) {
                return bl2;
            }
            if (!((ClassModuleSymbol)symbol2).processSuperClassSymbols((Processor<? super Symbol>)((Processor)symbol -> !symbol.getFQNWithNesting().getFullPath().equals(className)), (PsiElement)rubyClass, true)) {
                rubySymbolsLookupCache.registerIsInheritor((PsiElement)rubyClass, symbol2, className, true);
                return true;
            }
            rubySymbolsLookupCache.registerIsInheritor((PsiElement)rubyClass, symbol2, className, false);
        }
        return false;
    }

    static {
        b = la.a(3380014525338837819L, 3918898780025031319L, MethodHandles.lookup().lookupClass()).a(172353313297982L);
        a = Logger.getInstance(RContainerUtil.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x108BE7CF7556L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/holders/utils/RContainerUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allClasses";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentModuleName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/holders/utils/RContainerUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "selectElementsByType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructureElements";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelClasses";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectElementsByType";
                break;
            }
            case 2: 
            case 10: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getClassByName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findClassByName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMethodByName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleByName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContainerByName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStructureElements";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isClassEval";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isContextChangingBlockCall";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelClasses";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "gatherClasses";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelModules";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAllModulesNames";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAllModulesNamesImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

