/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.common;

import b.h.la;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.AbstractUsesDependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.DependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.ui.ConflictsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfoStorage;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.UpDirectedMembersMovingDialog;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public abstract class RubyExtractSuperBaseDialog
extends UpDirectedMembersMovingDialog {
    protected JTextField mySourceClassField;
    protected JLabel mySuperNameLabel;
    protected JTextField myExtractedSuperNameField;
    protected TextFieldWithBrowseButton myTargetDirField;
    protected JLabel myDirLabel;
    private static final long c = la.a(-5062691502487495105L, -3441168579732041547L, MethodHandles.lookup().lookupClass()).a(92204963243453L);

    public RubyExtractSuperBaseDialog(Project project, RContainer clazz, RubyMemberInfoStorage memberInfos) {
        super(project, clazz);
        this.myMemberInfos = memberInfos.getClassMemberInfos((PsiElement)this.myClass);
        this.myExtractedSuperNameField = new JTextField();
        this.myTargetDirField = new TextFieldWithBrowseButton();
        this.initSourceClassField();
    }

    @Override
    protected DependencyMemberInfoModel<RPsiElement, RubyMemberInfo> createMemberInfoModel() {
        return new MyMemberInfoModel(this.myClass);
    }

    protected void initSourceClassField() {
        this.mySourceClassField = new JTextField();
        this.mySourceClassField.setEditable(false);
        this.mySourceClassField.setText(this.myClass instanceof RClass ? ((RClass)this.myClass).getQualifiedName() : ((RModule)this.myClass).getQualifiedName());
    }

    @Override
    protected abstract String getMembersBorderTitle();

    public JComponent getPreferredFocusedComponent() {
        return this.myExtractedSuperNameField;
    }

    @Override
    protected void doOKAction() {
        long l2 = c ^ 0x767CF9B58B49L;
        String string = this.getSuperBaseName();
        if (!NamingConventions.isInCamelCaseExt(string)) {
            this.setErrorText(RBundle.message((String)"refactoring.extract.superbase.name.error", (Object[])new Object[]{StringUtil.capitalize((String)this.getSuperBaseType())}), this.myExtractedSuperNameField);
            return;
        }
        String string2 = this.a();
        VirtualFile virtualFile = this.getTargetDirectory();
        if (virtualFile == null) {
            this.setErrorText(RBundle.message((String)"refactoring.extract.superbase.directory.does.not.exist", (Object[])new Object[]{string2}), (JComponent)this.myTargetDirField);
            return;
        }
        String string3 = RubyRefactoringUtil.getNewFileName(string);
        if (virtualFile.findFileByRelativePath(string3) != null) {
            this.setErrorText(RBundle.message((String)"refactoring.extract.superbase.directory.file.exists", (Object[])new Object[]{string3}), this.myExtractedSuperNameField);
            return;
        }
        super.doOKAction();
    }

    @Nullable
    public VirtualFile getTargetDirectory() {
        return VirtualFileManager.getInstance().findFileByUrl(VfsUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)this.a())));
    }

    private String a() {
        return this.myTargetDirField.getText();
    }

    protected abstract String getSuperBaseType();

    public String getSuperBaseName() {
        return this.myExtractedSuperNameField.getText();
    }

    protected VirtualFile getRoot() {
        return this.myClass.getContainingFile().getVirtualFile().getParent();
    }

    protected JPanel createNorthPanel() {
        long l2 = c ^ 0x3AEE304420F2L;
        Box box = this.createBox();
        box.add(Box.createVerticalStrut(10));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)box, "Center");
        return jPanel;
    }

    protected Box createBox() {
        long l2 = c ^ 0x76A4358969CCL;
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(RBundle.message((String)"refactoring.extract.superbase.from", (Object[])new Object[]{this.getSuperBaseType()})), "North");
        jPanel.add((Component)this.mySourceClassField, "Center");
        box.add(jPanel);
        box.add(Box.createVerticalStrut(10));
        this.mySuperNameLabel = new JLabel();
        this.mySuperNameLabel.setText(RBundle.message((String)"refactoring.extract.superbase.name.prompt", (Object[])new Object[]{StringUtil.capitalize((String)this.getSuperBaseType())}));
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.mySuperNameLabel, "North");
        jPanel.add((Component)this.myExtractedSuperNameField, "Center");
        box.add(jPanel);
        box.add(Box.createVerticalStrut(5));
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        VirtualFile virtualFile = this.getRoot();
        fileChooserDescriptor.setRoots(new VirtualFile[]{virtualFile});
        fileChooserDescriptor.withTreeRootVisible(true);
        this.myTargetDirField.setText(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
        this.myTargetDirField.addBrowseFolderListener(this.getFileBrowserTitle(), null, this.myClass.getProject(), fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        jPanel = new JPanel(new BorderLayout());
        this.myDirLabel = new JLabel();
        this.myDirLabel.setText(this.getFileBrowserTitle());
        jPanel.add((Component)this.myDirLabel, "North");
        jPanel.add((Component)this.myTargetDirField, "Center");
        box.add(jPanel);
        return box;
    }

    @Override
    public boolean checkConflicts() {
        long l2 = c ^ 0x509E1C368E16L;
        Collection<RubyMemberInfo> collection = this.getSelectedMemberInfos();
        if (!RubyExtractSuperBaseDialog.checkWritable(this.myClass, collection)) {
            return false;
        }
        if (collection.size() == 0) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(this.myClass.getProject(), new String[]{RBundle.message((String)"refactoring.extract.superbase.no.members", (Object[])new Object[]{this.getSuperBaseType()})});
            return conflictsDialog.showAndGet();
        }
        return true;
    }

    protected abstract String getFileBrowserTitle();

    protected boolean isStaticAllowed() {
        return true;
    }

    protected boolean isInstanceAllowed() {
        return true;
    }

    private class MyMemberInfoModel
    extends AbstractUsesDependencyMemberInfoModel<RPsiElement, RContainer, RubyMemberInfo> {
        private static final long a = la.a(-1620947220704770069L, -8298870003566507564L, MethodHandles.lookup().lookupClass()).a(246483695793167L);

        MyMemberInfoModel(RContainer clazz) {
            super((PsiElement)clazz, null, false);
        }

        public boolean isMemberEnabled(RubyMemberInfo member) {
            return member.isStatic() && RubyExtractSuperBaseDialog.this.isStaticAllowed() || !member.isStatic() && RubyExtractSuperBaseDialog.this.isInstanceAllowed();
        }

        public boolean isAbstractEnabled(RubyMemberInfo member) {
            return false;
        }

        public int checkForProblems(@NotNull RubyMemberInfo member) {
            if (member == null) {
                MyMemberInfoModel.a(0);
            }
            return member.isChecked() ? 0 : super.checkForProblems((MemberInfoBase)member);
        }

        protected int doCheck(@NotNull RubyMemberInfo memberInfo, int problem) {
            if (memberInfo == null) {
                MyMemberInfoModel.a(1);
            }
            if (problem == 2 && memberInfo.isStatic()) {
                return 1;
            }
            return problem;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = a ^ 0x31C2AAC412C0L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberInfo";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/common/RubyExtractSuperBaseDialog$MyMemberInfoModel";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkForProblems";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCheck";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

