/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.ActionOnSelectedElement;
import com.intellij.cvsSupport2.actions.actionVisibility.CvsActionVisibility;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextWrapper;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class UnmarkAddedAction
extends AnAction {
    private final CvsActionVisibility myVisibility = new CvsActionVisibility();

    public UnmarkAddedAction() {
        this.myVisibility.canBePerformedOnSeveralFiles();
        this.myVisibility.shouldNotBePerformedOnDirectory();
        this.myVisibility.addCondition(ActionOnSelectedElement.FILES_ARE_LOCALLY_ADDED);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            UnmarkAddedAction.$$$reportNull$$$0(0);
        }
        this.myVisibility.applyToEvent(e);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            UnmarkAddedAction.$$$reportNull$$$0(1);
        }
        CvsContext context = CvsContextWrapper.createCachedInstance(e);
        VirtualFile[] selectedFiles = context.getSelectedFiles();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            for (int i = 0; i < selectedFiles.length; ++i) {
                File file = CvsVfsUtil.getFileFor(selectedFiles[i]);
                if (progressIndicator != null) {
                    progressIndicator.setFraction((double)i / (double)selectedFiles.length);
                    progressIndicator.setText(file.getAbsolutePath());
                }
                CvsUtil.removeEntryFor(file);
            }
        }, CvsBundle.message((String)"operation.name.undo.add", (Object[])new Object[0]), true, context.getProject());
        VirtualFileManager.getInstance().asyncRefresh(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/cvsSupport2/actions/UnmarkAddedAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

