/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportManager {
    public static final DbmsExtension<ImportManager> EP = new DbmsExtension("com.intellij.database.dataImporter");
    private final boolean myUseBatches;
    private final boolean myUseSavepoints;
    private final boolean myUseTransactions;
    private final TypeMerger[] myMergers;
    private final Dbms myDbms;
    private final TypeMerger.StringMerger myStringMerger;
    private final int myLinesPerStatement;
    private final boolean mySupportFastMode;

    protected ImportManager(@NotNull Dbms dbms, @NotNull String myTextType, int batchSize, TypeMerger ... mergers) {
        if (dbms == null) {
            ImportManager.$$$reportNull$$$0(0);
        }
        if (myTextType == null) {
            ImportManager.$$$reportNull$$$0(1);
        }
        if (mergers == null) {
            ImportManager.$$$reportNull$$$0(2);
        }
        this(dbms, myTextType, batchSize, false, true, true, true, mergers);
    }

    protected ImportManager(@NotNull Dbms dbms, @NotNull String myTextType, int linesPerStatement, boolean supportFastMode, boolean useBatches, boolean useSavepoints, boolean useTransactions, TypeMerger ... mergers) {
        if (dbms == null) {
            ImportManager.$$$reportNull$$$0(3);
        }
        if (myTextType == null) {
            ImportManager.$$$reportNull$$$0(4);
        }
        if (mergers == null) {
            ImportManager.$$$reportNull$$$0(5);
        }
        this.myDbms = dbms;
        this.myUseBatches = useBatches;
        this.myUseSavepoints = useSavepoints;
        this.myUseTransactions = useTransactions;
        this.myMergers = mergers;
        this.myStringMerger = new TypeMerger.StringMerger(myTextType);
        this.myLinesPerStatement = linesPerStatement;
        this.mySupportFastMode = supportFastMode;
        Arrays.sort(this.myMergers, Comparator.comparingInt(TypeMerger::getPriority));
    }

    public boolean shouldUseBatches() {
        return this.myUseBatches;
    }

    public boolean shouldUseSavepoints() {
        return this.myUseSavepoints;
    }

    public boolean shouldUseTransactions() {
        return this.myUseTransactions;
    }

    @NotNull
    public TypeMerger getType(String string) {
        for (TypeMerger merger : this.myMergers) {
            if (!merger.isSuitable(string)) continue;
            TypeMerger typeMerger = merger;
            if (typeMerger == null) {
                ImportManager.$$$reportNull$$$0(6);
            }
            return typeMerger;
        }
        TypeMerger.StringMerger stringMerger = this.myStringMerger;
        if (stringMerger == null) {
            ImportManager.$$$reportNull$$$0(7);
        }
        return stringMerger;
    }

    @NotNull
    public TypeMerger.StringMerger getStringMerger() {
        TypeMerger.StringMerger stringMerger = this.myStringMerger;
        if (stringMerger == null) {
            ImportManager.$$$reportNull$$$0(8);
        }
        return stringMerger;
    }

    @NotNull
    public String getInsertStatement(@NotNull ImportInfo info, int linesCount) {
        if (info == null) {
            ImportManager.$$$reportNull$$$0(9);
        }
        List<AutoValueDescriptor> columnsForInsert = info.getConsumersForInsert();
        String string = ImportManager.multiInsertStatement(this.createBuilder(info.getContext()), info.getTable(), JdbcEngine.getColumnNamesForInsert(columnsForInsert, this.getDbms()), this.getDbms(), ImportManager.getPlaceholders(this.getDbms(), columnsForInsert, linesCount)).getStatement();
        if (string == null) {
            ImportManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    public int getLinesPerStatement() {
        return this.myLinesPerStatement;
    }

    @NotNull
    public List<String> getFastModeOnQueries(@NotNull ImportInfo info) {
        if (info == null) {
            ImportManager.$$$reportNull$$$0(11);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ImportManager.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public List<String> getFastModeOffQueries(@NotNull ImportInfo info) {
        if (info == null) {
            ImportManager.$$$reportNull$$$0(13);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ImportManager.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    public String getLockQuery(@NotNull ImportInfo info) {
        if (info == null) {
            ImportManager.$$$reportNull$$$0(15);
        }
        return null;
    }

    public boolean isSupportFastMode() {
        return this.mySupportFastMode;
    }

    protected boolean isSuitable(@Nullable Version productVersion) {
        return true;
    }

    @NotNull
    protected DdlBuilder createBuilder(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            ImportManager.$$$reportNull$$$0(16);
        }
        DdlBuilder ddlBuilder = ImportManager.createConfiguredBuilder(context);
        if (ddlBuilder == null) {
            ImportManager.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    @NotNull
    protected List<String> getQueries(@NotNull ImportInfo info, boolean before2) {
        if (info == null) {
            ImportManager.$$$reportNull$$$0(18);
        }
        List list = ContainerUtil.list((Object[])new String[]{this.triggers(this.alter(this.createBuilder(info.getContext()), "TABLE", info.getTable()).space(), !before2).getStatement()});
        if (list == null) {
            ImportManager.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    protected DdlBuilder triggers(@NotNull DdlBuilder builder, boolean enable) {
        if (builder == null) {
            ImportManager.$$$reportNull$$$0(20);
        }
        DdlBuilder ddlBuilder = builder.keyword(enable ? "ENABLE" : "DISABLE").space().keyword("TRIGGER").space().keyword("ALL");
        if (ddlBuilder == null) {
            ImportManager.$$$reportNull$$$0(21);
        }
        return ddlBuilder;
    }

    @Deprecated
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            ImportManager.$$$reportNull$$$0(22);
        }
        return dbms;
    }

    @NotNull
    protected DdlBuilder alter(@NotNull DdlBuilder builder, @NotNull String objectToAlter, @NotNull DasObject table) {
        if (builder == null) {
            ImportManager.$$$reportNull$$$0(23);
        }
        if (objectToAlter == null) {
            ImportManager.$$$reportNull$$$0(24);
        }
        if (table == null) {
            ImportManager.$$$reportNull$$$0(25);
        }
        DdlBuilder ddlBuilder = builder.keyword("ALTER").space().keyword(objectToAlter).space().qualifiedRef(table);
        if (ddlBuilder == null) {
            ImportManager.$$$reportNull$$$0(26);
        }
        return ddlBuilder;
    }

    @NotNull
    public static ImportManager of(@NotNull Dbms dbms, @Nullable Version version) {
        if (dbms == null) {
            ImportManager.$$$reportNull$$$0(27);
        }
        for (ImportManager manager : EP.allForDbms(dbms)) {
            if (!manager.isSuitable(version)) continue;
            ImportManager importManager = manager;
            if (importManager == null) {
                ImportManager.$$$reportNull$$$0(28);
            }
            return importManager;
        }
        throw new AssertionError();
    }

    @NotNull
    public static DdlBuilder createConfiguredBuilder(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            ImportManager.$$$reportNull$$$0(29);
        }
        DdlBuilder ddlBuilder = DatabaseDialogsHelper.createDdlBuilder(context, false);
        if (ddlBuilder == null) {
            ImportManager.$$$reportNull$$$0(30);
        }
        return ddlBuilder;
    }

    @NotNull
    protected static List<List<Consumer<DdlBuilder>>> getPlaceholders(@NotNull Dbms dbms, @NotNull Collection<? extends AutoValueDescriptor> columns, int rows) {
        if (dbms == null) {
            ImportManager.$$$reportNull$$$0(31);
        }
        if (columns == null) {
            ImportManager.$$$reportNull$$$0(32);
        }
        List<List<Consumer<DdlBuilder>>> list = Collections.nCopies(rows, JdbcEngine.getPlaceholdersForInsert(columns, dbms));
        if (list == null) {
            ImportManager.$$$reportNull$$$0(33);
        }
        return list;
    }

    @NotNull
    public static DdlBuilder multiInsertStatement(@NotNull DdlBuilder builder, DasTable table, @NotNull List<String> columns, @NotNull Dbms dbms, @NotNull List<List<Consumer<DdlBuilder>>> params) {
        if (builder == null) {
            ImportManager.$$$reportNull$$$0(34);
        }
        if (columns == null) {
            ImportManager.$$$reportNull$$$0(35);
        }
        if (dbms == null) {
            ImportManager.$$$reportNull$$$0(36);
        }
        if (params == null) {
            ImportManager.$$$reportNull$$$0(37);
        }
        builder.keyword("INSERT").space().keyword("INTO").space().qualifiedRef((DasObject)table);
        boolean empty = columns.isEmpty();
        if (empty) {
            if (DbImplUtil.getDatabaseDialect(dbms).supportsInsertDefaultValues()) {
                builder.space().keyword("DEFAULT").space().keyword("VALUES");
                DdlBuilder ddlBuilder = builder;
                if (ddlBuilder == null) {
                    ImportManager.$$$reportNull$$$0(38);
                }
                return ddlBuilder;
            }
            throw new IllegalArgumentException("Can't insert values without columns");
        }
        builder.space().symbol("(");
        DialectUtils.appendStringList(builder, columns);
        builder.symbol(")");
        builder.space().keyword("VALUES").space();
        int linesCount = params.size();
        for (int i2 = 0; i2 < linesCount; ++i2) {
            builder.symbol("(");
            DialectUtils.appendCommaSeparated(builder, (Iterable<Consumer<DdlBuilder>>)params.get(i2));
            builder.symbol(")");
            if (i2 >= linesCount - 1) continue;
            builder.literal(",");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            ImportManager.$$$reportNull$$$0(39);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myTextType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergers";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportManager";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 16: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: 
            case 23: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectToAlter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportManager";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringMerger";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertStatement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOnQueries";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOffQueries";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueries";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "triggers";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "alter";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfiguredBuilder";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholders";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "multiInsertStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 38: 
            case 39: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInsertStatement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOnQueries";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOffQueries";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLockQuery";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "triggers";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "alter";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createConfiguredBuilder";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholders";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "multiInsertStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

