/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasTable;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlValuesExtractor
extends DefaultValuesExtractor<DatabaseSettings.DatabaseBaseState> {
    protected final DasTable myDatabaseTable;

    public SqlValuesExtractor(ObjectFormatter converter, DasTable databaseTable) {
        this(new DatabaseSettings.DatabaseBaseState(), converter, databaseTable);
    }

    public SqlValuesExtractor(DatabaseSettings.DatabaseBaseState state, ObjectFormatter converter, DasTable databaseTable) {
        super(state, converter);
        this.myDatabaseTable = databaseTable;
    }

    @Override
    @NotNull
    public String getNullLiteral(DataConsumer.Row row, DataConsumer.Column column2) {
        if ("null" == null) {
            SqlValuesExtractor.$$$reportNull$$$0(0);
        }
        return "null";
    }

    @Override
    @NotNull
    public String getValueLiteral(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2, @NotNull Dbms dbms) {
        String oraTemporal;
        if (row == null) {
            SqlValuesExtractor.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            SqlValuesExtractor.$$$reportNull$$$0(2);
        }
        if (dbms == null) {
            SqlValuesExtractor.$$$reportNull$$$0(3);
        }
        if ((oraTemporal = this.getOracleDateTimestamp(row, column2, dbms)) != null) {
            String string = oraTemporal;
            if (string == null) {
                SqlValuesExtractor.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = super.getValueLiteral(row, column2, dbms);
        if (string == null) {
            SqlValuesExtractor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getStringValue(@NotNull Dbms dbms, @Nullable DataConsumer.Column column2, @NotNull String value) {
        if (dbms == null) {
            SqlValuesExtractor.$$$reportNull$$$0(6);
        }
        if (value == null) {
            SqlValuesExtractor.$$$reportNull$$$0(7);
        }
        String fixedValue = StringUtil.replace((String)value, (String)"'", (String)"''");
        boolean isMysql = dbms.isMysql();
        boolean isClickHouse = dbms.isClickHouse();
        if ((isMysql || isClickHouse) && fixedValue.indexOf(92) >= 0) {
            fixedValue = StringUtil.replace((String)fixedValue, (String)"\\", (String)"\\\\");
        }
        String quoted = "'" + fixedValue + "'";
        String string = isMysql && column2 != null && ObjectFormatter.isBitString(column2) ? "b" + quoted : quoted;
        if (string == null) {
            SqlValuesExtractor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        if ("sql" == null) {
            SqlValuesExtractor.$$$reportNull$$$0(9);
        }
        return "sql";
    }

    @Override
    public String getLineSeparator() {
        return "";
    }

    @Override
    public DataExtractor.Extraction startExtraction(CharOut out, Dbms dbms, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new SqlExtractionBase(out, dbms, forceSkipHeader, allColumns, selectedColumns);
    }

    @Nullable
    private String getOracleDateTimestamp(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2, @NotNull Dbms dbms) {
        int fractionalSeconds;
        String formattedValue;
        if (row == null) {
            SqlValuesExtractor.$$$reportNull$$$0(10);
        }
        if (column2 == null) {
            SqlValuesExtractor.$$$reportNull$$$0(11);
        }
        if (dbms == null) {
            SqlValuesExtractor.$$$reportNull$$$0(12);
        }
        if (!dbms.isOracle()) {
            return null;
        }
        Object value = column2.getValue(row);
        if (!(value instanceof Timestamp)) {
            return null;
        }
        String function2 = "DATE".equals(column2.typeName) ? "TO_DATE" : "TO_TIMESTAMP";
        Formatter format = this.getFormatter().getTimestampFormat(column2, dbms);
        try {
            formattedValue = format.format(value);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        String pattern = format.toString();
        String oraPattern = StringUtil.replace((String)pattern, Arrays.asList("yyyy", "dd", "HH", "mm", "ss"), Arrays.asList("YYYY", "DD", "HH24", "MI", "SS"));
        int lastDotIdx = StringUtil.lastIndexOf((CharSequence)oraPattern, (char)'.', (int)0, (int)oraPattern.length());
        int n = fractionalSeconds = lastDotIdx != -1 ? oraPattern.length() - lastDotIdx - 1 : 0;
        if (fractionalSeconds > 0) {
            TextRange range = TextRange.create((int)lastDotIdx, (int)oraPattern.length());
            oraPattern = StringUtil.replaceSubstring((String)oraPattern, (TextRange)range, (String)(".FF" + fractionalSeconds));
        }
        return function2 + "('" + formattedValue + "', '" + oraPattern + "')";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/SqlValuesExtractor";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullLiteral";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/SqlValuesExtractor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueLiteral";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtension";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValueLiteral";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStringValue";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOracleDateTimestamp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class SqlExtractionBase
    extends DefaultValuesExtractor.DefaultExtraction {
        protected final DdlBuilder myDdlBuilder;

        public SqlExtractionBase(CharOut output, Dbms dbms, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            super(output, dbms, forceSkipHeader, allColumns, selectedColumnIndices);
            this.myDdlBuilder = new DdlBuilder(this.myOutput).qualifyReferences(true).withDialect(DbImplUtil.getDatabaseDialect(dbms));
        }

        @Override
        protected void appendHeader(boolean appendNewLine) {
        }
    }
}

