/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.exceptions.DBColumnAccessDeniedException;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.exceptions.DBLoginFailedException;
import org.jetbrains.dekaf.exceptions.DBSchemaAccessDeniedException;
import org.jetbrains.dekaf.exceptions.NoTableOrViewException;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;

public class SybaseExceptionRecognizer
extends BaseExceptionRecognizer {
    public static final SybaseExceptionRecognizer INSTANCE = new SybaseExceptionRecognizer();
    private static final Map<Integer, Class<? extends DBException>> simpleExceptionMap = new HashMap<Integer, Class<? extends DBException>>();
    private static final Map<String, Class<? extends DBException>> nativeExceptionMap = new HashMap<String, Class<? extends DBException>>();

    @Override
    @Nullable
    protected DBException recognizeSpecificException(@NotNull SQLException sqle, @Nullable String statementText) {
        int errCode = sqle.getErrorCode();
        if (errCode > 0) {
            return this.recognizeForJTDS(sqle, statementText, errCode);
        }
        String state = sqle.getSQLState();
        if (state != null && !state.isEmpty()) {
            return this.recognizeForNative(sqle, statementText, state);
        }
        return null;
    }

    @Nullable
    private DBException recognizeForJTDS(@NotNull SQLException sqle, @Nullable String statementText, int errCode) {
        Class<? extends DBException> exceptionClass = simpleExceptionMap.get(errCode);
        if (exceptionClass != null) {
            return this.instantiateDBException(exceptionClass, sqle, statementText);
        }
        return null;
    }

    @Nullable
    private DBException recognizeForNative(SQLException sqle, String statementText, String state) {
        Class<? extends DBException> exceptionClass = nativeExceptionMap.get(state);
        if (exceptionClass != null) {
            return this.instantiateDBException(exceptionClass, sqle, statementText);
        }
        return null;
    }

    static {
        simpleExceptionMap.put(208, NoTableOrViewException.class);
        simpleExceptionMap.put(4002, DBLoginFailedException.class);
        simpleExceptionMap.put(10332, DBColumnAccessDeniedException.class);
        simpleExceptionMap.put(10351, DBSchemaAccessDeniedException.class);
        nativeExceptionMap.put("JZ00L", DBLoginFailedException.class);
    }
}

