/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.jdbc.UnknownDatabaseInfo;
import org.jetbrains.dekaf.jdbc.UnknownDatabaseInfoHelper;
import org.jetbrains.dekaf.jdbc.UnknownDatabaseIntermediateFacade;

public class UnknownDatabaseIntermediateSession
extends JdbcIntermediateSession {
    @Nullable
    private UnknownDatabaseInfo myUnknownInfo = null;

    public UnknownDatabaseIntermediateSession(@Nullable JdbcIntermediateFacade facade, @NotNull DBExceptionRecognizer exceptionRecognizer, @NotNull Connection connection, boolean ownConnection) {
        super(facade, exceptionRecognizer, connection, ownConnection);
    }

    @NotNull
    private UnknownDatabaseInfo getUnknownInfo() {
        if (this.myUnknownInfo == null) {
            if (this.myFacade != null) {
                this.myUnknownInfo = ((UnknownDatabaseIntermediateFacade)this.myFacade).getUnknownInfo();
            }
            if (this.myUnknownInfo == null) {
                try {
                    this.myUnknownInfo = UnknownDatabaseInfoHelper.obtainDatabaseInfo(this.getConnection());
                }
                catch (SQLException e) {
                    throw this.recognizeException(e);
                }
            }
        }
        return this.myUnknownInfo;
    }

    @Override
    public long ping() {
        this.getUnknownInfo();
        return super.ping();
    }

    @Override
    protected void performPing(Statement statement) throws SQLException {
        UnknownDatabaseInfo ui = this.getUnknownInfo();
        String pingQuery = "select 1" + ui.fromSingleRowTable;
        statement.execute(pingQuery);
    }
}

